/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.misc.wizards.creation;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jwt.meta.model.core.Model;
import org.eclipse.jwt.we.Plugin;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.jwt.we.misc.views.Views;
import org.eclipse.jwt.we.misc.wizards.WizardHelper;
import org.eclipse.jwt.we.misc.wizards.creation.CreationWizardPageFileName;
import org.eclipse.jwt.we.misc.wizards.template.imp.ImportTemplateWizardPage;
import org.eclipse.jwt.we.model.view.Diagram;
import org.eclipse.jwt.we.model.view.impl.ViewFactoryImpl;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class CreationWizard1
extends Wizard
implements INewWizard {
    static final Logger logger = Logger.getLogger(CreationWizard1.class);
    protected ImportTemplateWizardPage importTemplatePage;
    protected CreationWizardPageFileName selectFilenamePage;
    protected IWorkbench workbench;
    protected URI newFileURI;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.setWindowTitle(PluginProperties.menu_WE_item);
        this.setDefaultPageImageDescriptor(Plugin.getInstance().getFactoryRegistry().getImageFactory(Views.getInstance().getSelectedView()).createImageDescriptor(PluginProperties.editor_Wizard_icon));
    }

    public void addPages() {
        this.selectFilenamePage = new CreationWizardPageFileName("filename_page1", true);
        this.selectFilenamePage.setTitle(PluginProperties.menu_WE_item);
        this.selectFilenamePage.setDescription(PluginProperties.editor_Wizard_description);
        this.addPage((IWizardPage)this.selectFilenamePage);
        this.importTemplatePage = new ImportTemplateWizardPage("template_page1", this.workbench);
        this.importTemplatePage.setTitle(PluginProperties.wizards_ImportTemplateWizard_title);
        this.importTemplatePage.setDescription(PluginProperties.wizards_ImportSelect_label);
        this.importTemplatePage.setCreationMode(true);
        this.addPage((IWizardPage)this.importTemplatePage);
    }

    public URI getModelURI() {
        return this.selectFilenamePage.getFileURI();
    }

    public String getPackageName() {
        return this.selectFilenamePage.getPackageName();
    }

    public String getActivityName() {
        return this.selectFilenamePage.getActivityName();
    }

    public String getAuthor() {
        return this.selectFilenamePage.getAuthor();
    }

    public String getVersion() {
        return this.selectFilenamePage.getVersion();
    }

    public boolean getStandardPackages() {
        return this.selectFilenamePage.getStandardPackages();
    }

    public ArrayList getTemplates() {
        return this.importTemplatePage.getTemplates();
    }

    public URI getNewFileURI() {
        return this.newFileURI;
    }

    public void setNewFileURI(URI newFileURI) {
        this.newFileURI = newFileURI;
    }

    public boolean performFinish() {
        URI fileWorkflowUri;
        block4: {
            try {
                String filename = this.getModelURI().toFileString();
                if (!filename.endsWith(WEEditor.getWorkflowExtension())) {
                    filename = String.valueOf(filename) + "." + WEEditor.getWorkflowExtension();
                }
                File newfile = new File(filename);
                fileWorkflowUri = URI.createFileURI((String)filename);
                if (!newfile.exists() || MessageDialog.openQuestion((Shell)this.getShell(), (String)PluginProperties.editor_QuestionOverwriteFile_title, (String)PluginProperties.bind((String)PluginProperties.editor_QuestionOverwriteFile_message, (Object)newfile.getAbsolutePath()))) break block4;
                this.selectFilenamePage.selectFileField();
                return false;
            }
            catch (Exception exception) {
                logger.warning(exception);
                return false;
            }
        }
        final URI fileDiagramUri = fileWorkflowUri.trimFileExtension().appendFileExtension(WEEditor.getDiagramExtension());
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor progressMonitor) {
                try {
                    try {
                        ResourceSetImpl resourceSet = new ResourceSetImpl();
                        Resource resourceWorkflow = resourceSet.createResource(fileWorkflowUri);
                        Resource resourceDiagram = resourceSet.createResource(fileDiagramUri);
                        EObject rootObject = WizardHelper.createResources(CreationWizard1.this.getPackageName(), CreationWizard1.this.getActivityName(), CreationWizard1.this.getAuthor(), CreationWizard1.this.getVersion(), CreationWizard1.this.getStandardPackages(), CreationWizard1.this.getTemplates());
                        if (rootObject != null) {
                            resourceWorkflow.getContents().add((Object)rootObject);
                        }
                        Diagram diagramData = ViewFactoryImpl.eINSTANCE.createDiagram();
                        diagramData.setDescribesModel((Model)rootObject);
                        resourceDiagram.getContents().add((Object)diagramData);
                        HashMap<String, String> options = new HashMap<String, String>();
                        options.put("ENCODING", "UTF-8");
                        resourceWorkflow.save(options);
                        resourceDiagram.save(options);
                    }
                    catch (Exception exception) {
                        logger.warning(exception);
                        progressMonitor.done();
                    }
                }
                finally {
                    progressMonitor.done();
                }
            }
        };
        this.getContainer().run(false, false, operation);
        this.setNewFileURI(fileWorkflowUri);
        Plugin.openEditor(PlatformUI.getWorkbench(), this.newFileURI);
        return true;
    }

    public void dispose() {
        super.dispose();
        this.workbench = null;
    }
}

