/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.implclasses.tree;

import org.eclipse.jubula.rc.common.implclasses.tree.AbstractTreeOperationContext;
import org.eclipse.jubula.rc.common.implclasses.tree.INodePath;

public class IndexNodePath
implements INodePath {
    private Integer[] m_treePath;

    public IndexNodePath(Integer[] path) {
        this.m_treePath = path;
    }

    public int getLength() {
        return this.m_treePath.length;
    }

    public Object getObject(int level) {
        return this.m_treePath[level];
    }

    public boolean isInPath(Object node, int level, AbstractTreeOperationContext context) {
        Object parent = context.getParent(node);
        int nodeIndex = context.getIndexOfChild(parent, node);
        return this.m_treePath[level] == nodeIndex;
    }

    public INodePath subPath(int startIndex, int endIndex) {
        if (startIndex < 0 || endIndex > this.getLength() || startIndex > endIndex) {
            throw new IndexOutOfBoundsException("Invalid index");
        }
        Integer[] newTreePath = new Integer[endIndex - startIndex];
        int i = startIndex;
        while (i < endIndex) {
            newTreePath[i] = this.m_treePath[startIndex + i];
            ++i;
        }
        return new IndexNodePath(newTreePath);
    }
}

