/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal.xml;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jst.server.tomcat.core.internal.Trace;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtil {
    private static DocumentBuilder documentBuilder;

    public static DocumentBuilder getDocumentBuilder() {
        if (documentBuilder == null) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                factory.setNamespaceAware(false);
                factory.setExpandEntityReferences(false);
                try {
                    factory.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
                }
                catch (ParserConfigurationException parserConfigurationException) {}
                documentBuilder = factory.newDocumentBuilder();
                documentBuilder.setEntityResolver(new EntityResolver(){

                    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                        return new InputSource(new ByteArrayInputStream(new byte[0]));
                    }
                });
            }
            catch (Exception exception) {
                Trace.trace((byte)2, "Rrror creating document builder");
            }
        }
        return documentBuilder;
    }

    public static Element createChildElement(Document doc, Element element, int index, String nodeName) {
        Element element2 = doc.createElement(nodeName);
        try {
            NodeList childList = element.getElementsByTagName(nodeName);
            Node child = childList.item(index);
            element.insertBefore(element2, child);
        }
        catch (Exception exception) {
            element.appendChild(element2);
        }
        return element2;
    }

    public static Element createChildElement(Document doc, Node node, String nodeName) {
        Element element = doc.createElement(nodeName);
        node.appendChild(element);
        return element;
    }

    public static void createTextChildElement(Document doc, Node node, String name, String value) {
        Element element = XMLUtil.createChildElement(doc, node, name);
        element.appendChild(doc.createTextNode(value));
    }

    public static String getAttributeValue(Element element, String attr) {
        return element.getAttributeNode(attr).getValue();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getContents(Document document) throws IOException {
        byte[] byArray;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            XMLUtil.print(new PrintStream((OutputStream)out, true, "UTF-8"), document);
            byArray = out.toByteArray();
            if (out == null) return byArray;
        }
        catch (Exception ex) {
            try {
                throw new IOException(ex.getLocalizedMessage());
            }
            catch (Throwable throwable) {
                if (out == null) throw throwable;
                try {
                    out.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            out.close();
            return byArray;
        }
        catch (Exception exception) {}
        return byArray;
    }

    protected static String getDocumentTypeData(DocumentType doctype) {
        String data = doctype.getName();
        if (doctype.getPublicId() != null) {
            data = String.valueOf(data) + " PUBLIC \"" + doctype.getPublicId() + "\"";
            String systemId = doctype.getSystemId();
            if (systemId == null) {
                systemId = "";
            }
            data = String.valueOf(data) + " \"" + systemId + "\"";
        } else {
            data = String.valueOf(data) + " SYSTEM \"" + doctype.getSystemId() + "\"";
        }
        return data;
    }

    public static Iterator getNodeIterator(Element element, String name) {
        ArrayList<Node> list = new ArrayList<Node>();
        NodeList nodeList = element.getElementsByTagName(name);
        int length = nodeList.getLength();
        int i = 0;
        while (i < length) {
            list.add(nodeList.item(i));
            ++i;
        }
        return list.iterator();
    }

    public static String getNodeValue(Node node) {
        NodeList nodeList = node.getChildNodes();
        int length = nodeList.getLength();
        int i = 0;
        while (i < length) {
            Node n = nodeList.item(i);
            if (n instanceof Text) {
                Text t = (Text)n;
                return t.getNodeValue();
            }
            ++i;
        }
        return "";
    }

    public static String getSubNodeValue(Element element, String name) {
        NodeList nodeList = element.getElementsByTagName(name);
        return XMLUtil.getNodeValue(nodeList.item(0)).trim();
    }

    public static void insertText(Document doc, Node node, String text) {
        node.appendChild(doc.createCDATASection(text));
    }

    protected static String normalize(String s) {
        StringBuffer stringbuffer = new StringBuffer();
        int i = s == null ? 0 : s.length();
        int j = 0;
        while (j < i) {
            char c = s.charAt(j);
            switch (c) {
                case '<': {
                    stringbuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringbuffer.append("&gt;");
                    break;
                }
                case '&': {
                    stringbuffer.append("&amp;");
                    break;
                }
                case '\"': {
                    stringbuffer.append("&quot;");
                    break;
                }
                default: {
                    stringbuffer.append(c);
                }
            }
            ++j;
        }
        return stringbuffer.toString();
    }

    protected static void print(PrintStream out, Node node) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                NodeList nodelist = node.getChildNodes();
                int size = nodelist.getLength();
                int i = 0;
                while (i < size) {
                    XMLUtil.print(out, nodelist.item(i));
                    ++i;
                }
                break;
            }
            case 10: {
                DocumentType docType = (DocumentType)node;
                out.print("<!DOCTYPE " + XMLUtil.getDocumentTypeData(docType) + ">\n");
                break;
            }
            case 1: {
                out.print('<');
                out.print(node.getNodeName());
                NamedNodeMap map = node.getAttributes();
                if (map != null) {
                    int size = map.getLength();
                    int i = 0;
                    while (i < size) {
                        Attr attr = (Attr)map.item(i);
                        out.print(' ');
                        out.print(attr.getNodeName());
                        out.print("=\"");
                        out.print(XMLUtil.normalize(attr.getNodeValue()));
                        out.print('\"');
                        ++i;
                    }
                }
                if (!node.hasChildNodes()) {
                    out.print("/>");
                    break;
                }
                out.print('>');
                NodeList nodelist = node.getChildNodes();
                int numChildren = nodelist.getLength();
                int i = 0;
                while (i < numChildren) {
                    XMLUtil.print(out, nodelist.item(i));
                    ++i;
                }
                out.print("</");
                out.print(node.getNodeName());
                out.print('>');
                break;
            }
            case 5: {
                NodeList nodelist = node.getChildNodes();
                if (nodelist == null) break;
                int size = nodelist.getLength();
                int i = 0;
                while (i < size) {
                    XMLUtil.print(out, nodelist.item(i));
                    ++i;
                }
                break;
            }
            case 4: {
                out.print(XMLUtil.normalize(node.getNodeValue()));
                break;
            }
            case 3: {
                out.print(XMLUtil.normalize(node.getNodeValue()));
                break;
            }
            case 7: {
                out.print("<?");
                out.print(node.getNodeName());
                String s = node.getNodeValue();
                if (s != null && s.length() > 0) {
                    out.print(' ');
                    out.print(s);
                }
                out.print("?>");
                break;
            }
            case 8: {
                out.print("<!--");
                out.print(node.getNodeValue());
                out.print("-->");
                break;
            }
            default: {
                out.print(XMLUtil.normalize(node.getNodeValue()));
            }
        }
        out.flush();
    }

    public static void save(String filename, Document document) throws IOException {
        PrintStream out = null;
        try {
            try {
                out = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(filename)), true, "UTF-8");
                XMLUtil.print(out, document);
            }
            catch (Exception ex) {
                throw new IOException(ex.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void save(String filename, Node node) throws IOException {
        PrintStream out = null;
        try {
            try {
                out = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(filename)), true, "UTF-8");
                XMLUtil.print(out, node);
            }
            catch (Exception ex) {
                throw new IOException(ex.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void setNodeValue(Node node, String name, String value) {
        String s = node.getNodeValue();
        if (s != null) {
            node.setNodeValue(value);
            return;
        }
        NodeList nodelist = node.getChildNodes();
        int i = 0;
        while (i < nodelist.getLength()) {
            if (nodelist.item(i) instanceof Text) {
                Text text = (Text)nodelist.item(i);
                text.setData(value);
                return;
            }
            ++i;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String toString(Document document) {
        PrintStream out = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        out = new PrintStream(baos);
        XMLUtil.print(out, document);
        String string = new String(baos.toByteArray(), "UTF-8");
        if (out == null) return string;
        try {
            out.close();
            return string;
        }
        catch (Exception exception) {}
        return string;
        catch (Exception exception) {
            try {
                if (out == null) return null;
            }
            catch (Throwable throwable) {
                if (out == null) throw throwable;
                try {
                    out.close();
                    throw throwable;
                }
                catch (Exception exception2) {}
                throw throwable;
            }
            try {
                out.close();
                return null;
            }
            catch (Exception exception3) {}
            return null;
        }
    }
}

