/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.zest.fx.parts;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.util.Pair;
import org.eclipse.gef.graph.Edge;
import org.eclipse.gef.graph.Graph;
import org.eclipse.gef.graph.Node;
import org.eclipse.gef.mvc.fx.parts.AbstractContentPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.zest.fx.ZestProperties;

public class GraphPart
extends AbstractContentPart<Group> {
    private ListChangeListener<Object> graphChildrenObserver = new ListChangeListener<Object>(){

        public void onChanged(ListChangeListener.Change<? extends Object> c) {
            GraphPart.this.refreshContentChildren();
            GraphPart.this.refreshVisual();
        }
    };

    protected void doActivate() {
        super.doActivate();
        this.getContent().getNodes().addListener(this.graphChildrenObserver);
        this.getContent().getEdges().addListener(this.graphChildrenObserver);
    }

    protected void doAddChildVisual(IVisualPart<? extends javafx.scene.Node> child, int index) {
        ((Group)this.getVisual()).getChildren().add(index, (Object)child.getVisual());
    }

    protected Group doCreateVisual() {
        Group visual = new Group();
        visual.setAutoSizeChildren(false);
        return visual;
    }

    protected void doDeactivate() {
        this.getContent().getNodes().removeListener(this.graphChildrenObserver);
        this.getContent().getEdges().removeListener(this.graphChildrenObserver);
        super.doDeactivate();
    }

    protected SetMultimap<? extends Object, String> doGetContentAnchorages() {
        return HashMultimap.create();
    }

    protected List<? extends Object> doGetContentChildren() {
        ArrayList children = new ArrayList();
        ObservableList nodes = this.getContent().getNodes();
        ArrayList<Node> visibleNodes = new ArrayList<Node>();
        for (Node n : nodes) {
            if (Boolean.TRUE.equals(ZestProperties.getInvisible(n))) continue;
            visibleNodes.add(n);
        }
        children.addAll(visibleNodes);
        for (Node n : visibleNodes) {
            if (ZestProperties.getExternalLabel(n) == null) continue;
            children.add(new Pair((Object)n, (Object)"element-external-label"));
        }
        ObservableList edges = this.getContent().getEdges();
        ArrayList<Edge> visibleEdges = new ArrayList<Edge>();
        for (Edge e : edges) {
            if (Boolean.TRUE.equals(ZestProperties.getInvisible(e)) || e.getSource() == null || Boolean.TRUE.equals(ZestProperties.getInvisible(e.getSource())) || e.getTarget() == null || Boolean.TRUE.equals(ZestProperties.getInvisible(e.getTarget()))) continue;
            visibleEdges.add(e);
        }
        children.addAll(visibleEdges);
        for (Edge e : visibleEdges) {
            if (ZestProperties.getLabel(e) != null) {
                children.add(new Pair((Object)e, (Object)"element-label"));
            }
            if (ZestProperties.getExternalLabel(e) != null) {
                children.add(new Pair((Object)e, (Object)"element-external-label"));
            }
            if (ZestProperties.getSourceLabel(e) != null) {
                children.add(new Pair((Object)e, (Object)"edge-source-label"));
            }
            if (ZestProperties.getTargetLabel(e) == null) continue;
            children.add(new Pair((Object)e, (Object)"edge-target-label"));
        }
        return children;
    }

    public void doRefreshVisual(Group visual) {
    }

    protected void doRemoveChildVisual(IVisualPart<? extends javafx.scene.Node> child, int index) {
        ((Group)this.getVisual()).getChildren().remove((Object)child.getVisual());
    }

    public Graph getContent() {
        return (Graph)super.getContent();
    }

    public boolean isSelectable() {
        return false;
    }
}

