/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.language.htmllabel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlAttr;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlContent;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlTag;

public class DotHtmlLabelHelper {
    private static final String ROOT_TAG_KEY = "ROOT";
    private static final Set<String> allTags = new HashSet<String>();
    private static final Set<String> selfClosingTags = new HashSet<String>();
    private static final Set<String> nonSelfClosingTags = new HashSet<String>();
    private static final Map<String, Set<String>> validTags = new HashMap<String, Set<String>>();
    private static final Map<String, Set<String>> allowedParents = new HashMap<String, Set<String>>();
    private static final Map<String, Set<String>> validAttributes = new HashMap<String, Set<String>>();

    static {
        DotHtmlLabelHelper.validTags(ROOT_TAG_KEY, "BR", "FONT", "I", "B", "U", "O", "SUB", "SUP", "S", "TABLE");
        DotHtmlLabelHelper.validTags("FONT", "TABLE", "BR", "FONT", "I", "B", "U", "O", "SUB", "SUP", "S");
        DotHtmlLabelHelper.validTags("I", "TABLE", "BR", "FONT", "I", "B", "U", "O", "SUB", "SUP", "S");
        DotHtmlLabelHelper.validTags("B", "TABLE", "BR", "FONT", "I", "B", "U", "O", "SUB", "SUP", "S");
        DotHtmlLabelHelper.validTags("U", "TABLE", "BR", "FONT", "I", "B", "U", "O", "SUB", "SUP", "S");
        DotHtmlLabelHelper.validTags("O", "TABLE", "BR", "FONT", "I", "B", "U", "O", "SUB", "SUP", "S");
        DotHtmlLabelHelper.validTags("SUB", "BR", "FONT", "I", "B", "U", "O", "SUB", "SUP", "S");
        DotHtmlLabelHelper.validTags("SUP", "BR", "FONT", "I", "B", "U", "O", "SUB", "SUP", "S");
        DotHtmlLabelHelper.validTags("S", "BR", "FONT", "I", "B", "U", "O", "SUB", "SUP", "S");
        DotHtmlLabelHelper.validTags("TABLE", "HR", "TR");
        DotHtmlLabelHelper.validTags("TR", "VR", "TD");
        DotHtmlLabelHelper.validTags("TD", "IMG", "BR", "FONT", "I", "B", "U", "O", "SUB", "SUP", "S", "TABLE");
        for (Set<String> ts : validTags.values()) {
            allTags.addAll(ts);
        }
        for (String tag : allTags) {
            allowedParents.put(tag, new HashSet());
        }
        for (String parent : validTags.keySet()) {
            for (String tag : validTags.get(parent)) {
                allowedParents.get(tag).add(parent);
            }
        }
        String[] stringArray = new String[]{"TABLE", "TD", "FONT", "BR", "IMG"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            validAttributes.put(t, new HashSet());
            ++n2;
        }
        DotHtmlLabelHelper.validAttributes("TABLE", "ALIGN", "BGCOLOR", "BORDER", "CELLBORDER", "CELLPADDING", "CELLSPACING", "COLOR", "COLUMNS", "FIXEDSIZE", "GRADIENTANGLE", "HEIGHT", "HREF", "ID", "PORT", "ROWS", "SIDES", "STYLE", "TARGET", "TITLE", "TOOLTIP", "VALIGN", "WIDTH");
        DotHtmlLabelHelper.validAttributes("TD", "ALIGN", "BALIGN", "BGCOLOR", "BORDER", "CELLPADDING", "CELLSPACING", "COLOR", "COLSPAN", "FIXEDSIZE", "GRADIENTANGLE", "HEIGHT", "HREF", "ID", "PORT", "ROWSPAN", "SIDES", "STYLE", "TARGET", "TITLE", "TOOLTIP", "VALIGN", "WIDTH");
        DotHtmlLabelHelper.validAttributes("FONT", "COLOR", "FACE", "POINT-SIZE");
        DotHtmlLabelHelper.validAttributes("BR", "ALIGN");
        DotHtmlLabelHelper.validAttributes("IMG", "SCALE", "SRC");
        selfClosingTags.addAll(Arrays.asList("BR", "HR", "VR", "IMG"));
        nonSelfClosingTags.addAll(allTags);
        nonSelfClosingTags.removeAll(selfClosingTags);
    }

    private static void validTags(String tag, String ... childTags) {
        validTags.put(tag, new HashSet<String>(Arrays.asList(childTags)));
    }

    private static void validAttributes(String tag, String ... attributes) {
        validAttributes.get(tag).addAll(Arrays.asList(attributes));
    }

    public static String getRootTagKey() {
        return ROOT_TAG_KEY;
    }

    public static Set<String> getAllTags() {
        return allTags;
    }

    public static Set<String> getSelfClosingTags() {
        return selfClosingTags;
    }

    public static Set<String> getNonSelfClosingTags() {
        return nonSelfClosingTags;
    }

    public static Map<String, Set<String>> getValidTags() {
        return validTags;
    }

    public static Map<String, Set<String>> getAllowedParents() {
        return allowedParents;
    }

    public static Map<String, Set<String>> getValidAttributes() {
        return validAttributes;
    }

    public static boolean isValidSiblings(List<HtmlContent> siblings) {
        ArrayList<HtmlTag> htmlTableSiblings = new ArrayList<HtmlTag>();
        ArrayList<HtmlTag> htmlIMGSiblings = new ArrayList<HtmlTag>();
        ArrayList<HtmlContent> htmlTextSiblings = new ArrayList<HtmlContent>();
        for (HtmlContent content : siblings) {
            HtmlTag tag = content.getTag();
            String text = content.getText();
            if (tag != null && "TABLE".equals(tag.getName().toUpperCase())) {
                htmlTableSiblings.add(tag);
                continue;
            }
            if (tag != null && "IMG".equals(tag.getName().toUpperCase())) {
                htmlIMGSiblings.add(tag);
                continue;
            }
            if (tag == null && (text == null || text.trim().isEmpty())) continue;
            htmlTextSiblings.add(content);
        }
        if (htmlTableSiblings.size() + htmlIMGSiblings.size() > 1) {
            return false;
        }
        if (htmlTableSiblings.size() + htmlIMGSiblings.size() == 1) {
            return htmlTextSiblings.size() == 0;
        }
        return true;
    }

    public static String getTagDescription(String tagName) {
        switch (tagName) {
            case "TABLE": {
                return "Table element";
            }
            case "TR": {
                return "Table row";
            }
            case "TD": {
                return "Table cell";
            }
            case "FONT": {
                return "Font specification";
            }
            case "BR": {
                return "Line break";
            }
            case "IMG": {
                return "Image inclusion";
            }
            case "I": {
                return "Italic style";
            }
            case "B": {
                return "Bold style";
            }
            case "U": {
                return "Underline text";
            }
            case "O": {
                return "Overline text";
            }
            case "SUB": {
                return "Subscript text";
            }
            case "SUP": {
                return "Superscript text";
            }
            case "S": {
                return "Strike-through text";
            }
            case "HR": {
                return "Horizontal rule";
            }
            case "VR": {
                return "Vertical rule";
            }
        }
        return "";
    }

    public static HtmlAttr getAttributeForTag(HtmlTag tag, String attributeName) {
        for (HtmlAttr attr : tag.getAttributes()) {
            if (!attr.getName().equalsIgnoreCase(attributeName)) continue;
            return attr;
        }
        return null;
    }

    public static HtmlAttr getAttributeForTags(String attributeName, HtmlTag ... tags) {
        HtmlTag[] htmlTagArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            HtmlTag tag = htmlTagArray[n2];
            if (DotHtmlLabelHelper.getAttributeForTag(tag, attributeName) != null) {
                return DotHtmlLabelHelper.getAttributeForTag(tag, attributeName);
            }
            ++n2;
        }
        return null;
    }
}

