/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.xpath;

import java.util.Collections;
import java.util.List;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.eclipse.bpel.validator.model.IModelQuery;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.xpath.XPathValidator;
import org.eclipse.bpel.xpath10.AllNodeStep;
import org.eclipse.bpel.xpath10.BinaryExpr;
import org.eclipse.bpel.xpath10.CommentNodeStep;
import org.eclipse.bpel.xpath10.EqualityExpr;
import org.eclipse.bpel.xpath10.FilterExpr;
import org.eclipse.bpel.xpath10.FunctionCallExpr;
import org.eclipse.bpel.xpath10.LiteralExpr;
import org.eclipse.bpel.xpath10.LocationPath;
import org.eclipse.bpel.xpath10.LogicalExpr;
import org.eclipse.bpel.xpath10.NameStep;
import org.eclipse.bpel.xpath10.NumberExpr;
import org.eclipse.bpel.xpath10.PathExpr;
import org.eclipse.bpel.xpath10.Predicate;
import org.eclipse.bpel.xpath10.ProcessingInstructionNodeStep;
import org.eclipse.bpel.xpath10.RelationalExpr;
import org.eclipse.bpel.xpath10.TextNodeStep;
import org.eclipse.bpel.xpath10.UnaryExpr;
import org.eclipse.bpel.xpath10.UnionExpr;
import org.eclipse.bpel.xpath10.VariableReferenceExpr;

public class XPathVisitor {
    XPathValidator mValidator;
    IModelQuery mModelQuery;
    INode mContextNode;
    Stack<Object> mContext = new Stack();

    public XPathVisitor(XPathValidator validator) {
        this.mValidator = validator;
        this.mModelQuery = validator.getModelQuery();
        this.mContextNode = this.mValidator.getNode();
    }

    protected void visit(PathExpr expr) {
        this.mValidator.runRules("pathexpr", expr);
        this.visit(expr.getFilterExpr());
        Object last = this.contextPeek();
        XPathVisitor.isSimpleType(last);
        this.visit(expr.getLocationPath());
    }

    protected void visit(LocationPath expr) {
        this.mValidator.runRules("location", expr);
        this.visitList(expr.getSteps());
    }

    protected void visit(FilterExpr expr) {
        this.visit(expr.getExpr());
        this.visitList(expr.getPredicates());
    }

    protected void visit(BinaryExpr expr) {
        this.visit(expr.getLHS());
        this.contextPop();
        this.visit(expr.getRHS());
        this.contextPop();
        if (expr instanceof LogicalExpr || expr instanceof RelationalExpr || expr instanceof EqualityExpr) {
            this.mContext.push(true);
        } else {
            this.mContext.push(0.0);
        }
    }

    protected void visit(UnaryExpr expr) {
        this.visit(expr.getExpr());
        Object obj = this.contextPop();
        if (obj instanceof Number) {
            this.mContext.push(((Number)obj).doubleValue() * -1.0);
        } else {
            this.mContext.push(obj);
        }
    }

    protected void visit(UnionExpr expr) {
        IProblem problem;
        this.visit(expr.getLHS());
        Object lhs = this.contextPop();
        this.visit(expr.getRHS());
        Object rhs = this.contextPop();
        if (XPathVisitor.isSimpleType(rhs)) {
            problem = this.mValidator.createError();
            problem.fill("XPATH_NOT_A_Collections.EMPTY_LIST", 0, expr.getLHS().getText());
        }
        if (XPathVisitor.isSimpleType(lhs)) {
            problem = this.mValidator.createError();
            problem.fill("XPATH_NOT_A_Collections.EMPTY_LIST", 1, expr.getLHS().getText());
        }
        this.mContext.push(Collections.EMPTY_LIST);
    }

    protected void visit(NumberExpr expr) {
        this.mContext.push(expr.getNumber());
    }

    protected void visit(LiteralExpr expr) {
        this.mContext.push(expr.getLiteral());
    }

    protected void visit(VariableReferenceExpr expr) {
        this.mValidator.runRules("variables", expr);
    }

    protected void visit(FunctionCallExpr expr) {
        this.mValidator.runRules("functions", expr);
        this.mContext.push(Collections.EMPTY_LIST);
        this.visitList(expr.getParameters());
    }

    protected void visit(NameStep step) {
        String prefix = step.getPrefix();
        Object last = this.contextPop();
        if (!this.mValidator.checkPrefix(prefix, step.getLocalName())) {
            this.mContext.push(Collections.EMPTY_LIST);
            return;
        }
        if (last instanceof List) {
            this.mContext.push(Collections.EMPTY_LIST);
        } else if (last instanceof INode) {
            INode context = (INode)last;
            int axis = step.getAxis();
            String nsURI = this.mValidator.lookupNamespace(prefix);
            QName qname = new QName(nsURI, step.getLocalName(), prefix != null ? prefix : "");
            boolean notChecked = false;
            INode result = null;
            switch (axis) {
                case 1: {
                    result = this.mModelQuery.lookup(context, 15, qname);
                    break;
                }
                case 9: {
                    result = this.mModelQuery.lookup(context, 17, qname);
                    break;
                }
                case 3: {
                    result = this.mModelQuery.lookup(context, 20, qname);
                    break;
                }
                case 2: {
                    result = this.mModelQuery.lookup(context, 18, qname);
                    break;
                }
                case 12: {
                    result = this.mModelQuery.lookup(context, 19, qname);
                    break;
                }
                case 0: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 13: {
                    notChecked = true;
                }
            }
            if (result != null && result.isResolved()) {
                this.mContext.push(result);
            } else {
                this.mContext.push(Collections.EMPTY_LIST);
                if (notChecked) {
                    IProblem problem = this.mValidator.createWarning();
                    problem.fill("XPATH_AXIS_NOT_CHECKED", step.getText());
                } else {
                    this.mContext.push(Collections.EMPTY_LIST);
                    IProblem problem = this.mValidator.createWarning();
                    problem.fill("XPATH_NAME_STEP", step.getText());
                }
            }
        } else {
            IProblem problem = this.mValidator.createError();
            problem.fill("XPATH_NAME_STEP", step.getText());
            this.mContext.push(Collections.EMPTY_LIST);
        }
        if (this.mContext.size() > 0) {
            this.mContext.push(this.mContext.peek());
        }
        this.visitList(step.getPredicates());
        this.contextPop();
    }

    protected void visit(ProcessingInstructionNodeStep step) {
        this.visitList(step.getPredicates());
    }

    protected void visit(AllNodeStep step) {
        if (this.mContext.size() > 0) {
            this.mContext.pop();
        }
        this.mContext.push(Collections.EMPTY_LIST);
        this.visitList(step.getPredicates());
    }

    protected void visit(TextNodeStep step) {
        this.visitList(step.getPredicates());
        this.contextPop();
        this.mContext.push("text()");
    }

    protected void visit(CommentNodeStep step) {
        this.visitList(step.getPredicates());
        this.contextPop();
        this.mContext.push("comment()");
    }

    protected void visit(Predicate predicate) {
        this.visit(predicate.getExpr());
        Object result = this.contextPop();
        if (!(result instanceof Boolean)) {
            boolean cfr_ignored_0 = result instanceof Number;
        }
    }

    void visitList(List<?> list) {
        for (Object next : list) {
            this.visit(next);
        }
    }

    public void visit(Object obj) {
        if (obj instanceof PathExpr) {
            this.visit((PathExpr)obj);
        } else if (obj instanceof LocationPath) {
            this.visit((LocationPath)obj);
        } else if (obj instanceof BinaryExpr) {
            this.visit((BinaryExpr)obj);
        } else if (obj instanceof FilterExpr) {
            this.visit((FilterExpr)obj);
        } else if (obj instanceof UnaryExpr) {
            this.visit((UnaryExpr)obj);
        } else if (obj instanceof NumberExpr) {
            this.visit((NumberExpr)obj);
        } else if (obj instanceof LiteralExpr) {
            this.visit((LiteralExpr)obj);
        } else if (obj instanceof VariableReferenceExpr) {
            this.visit((VariableReferenceExpr)obj);
        } else if (obj instanceof FunctionCallExpr) {
            this.visit((FunctionCallExpr)obj);
        } else if (obj instanceof List) {
            this.visitList((List)obj);
        } else if (obj instanceof NameStep) {
            this.visit((NameStep)obj);
        } else if (obj instanceof ProcessingInstructionNodeStep) {
            this.visit((ProcessingInstructionNodeStep)obj);
        } else if (obj instanceof AllNodeStep) {
            this.visit((AllNodeStep)obj);
        } else if (obj instanceof TextNodeStep) {
            this.visit((TextNodeStep)obj);
        } else if (obj instanceof CommentNodeStep) {
            this.visit((CommentNodeStep)obj);
        } else if (obj instanceof Predicate) {
            this.visit((Predicate)obj);
        }
    }

    protected Object contextPush(Object obj) {
        return this.mContext.push(obj);
    }

    protected Object contextPeek() {
        return this.mContext.size() > 0 ? this.mContext.peek() : null;
    }

    protected Object contextPop() {
        return this.mContext.size() > 0 ? this.mContext.pop() : null;
    }

    static boolean isSimpleType(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj instanceof Number || obj instanceof String || obj instanceof Boolean;
    }

    static boolean isBPELNS(String namespaceUri) {
        return "http://docs.oasis-open.org/wsbpel/2.0/process/executable".equals(namespaceUri) || "http://schemas.xmlsoap.org/ws/2004/03/business-process/".equals(namespaceUri);
    }

    static boolean isEmptyOrWhitespace(String value) {
        if (value == null || value.length() == 0) {
            return true;
        }
        int i = 0;
        int j = value.length();
        while (i < j) {
            if (!Character.isWhitespace(value.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }
}

