/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.wizards;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.bpel.common.ui.details.viewers.ComboViewer;
import org.eclipse.bpel.model.util.BPELConstants;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.wizards.Messages;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class NewBpelFileFirstPage
extends WizardPage {
    public static final String PAGE_NAME = "bpel-first-page";
    private BpelCreationMode creationMode;
    private String processName;
    private String processNamespace;
    private boolean abstractProcess;
    private final Map<String, Object> processTemplateProperties;
    private Image wsdlImg;
    private Image arrowImg;
    private Image bpelImg;
    private Image tplImg;

    public NewBpelFileFirstPage() {
        super(PAGE_NAME);
        ImageDescriptor desc;
        this.setTitle(Messages.NewFileWizardPage1_2);
        this.setDescription(Messages.NewFileWizardPage1_3);
        this.setImageDescriptor(BPELUIPlugin.INSTANCE.getImageDescriptor("wizban/new_bpel.gif"));
        this.processTemplateProperties = new HashMap<String, Object>();
        try {
            desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.bpel.ui", (String)"icons/misc/wsdl.png");
            this.wsdlImg = desc.createImage();
        }
        catch (Exception e) {
            BPELUIPlugin.log(e, 2);
        }
        try {
            desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.bpel.ui", (String)"icons/misc/bpel-skeleton-2.png");
            this.bpelImg = desc.createImage();
        }
        catch (Exception e) {
            BPELUIPlugin.log(e, 2);
        }
        try {
            desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.bpel.ui", (String)"icons/misc/arrow.png");
            this.arrowImg = desc.createImage();
        }
        catch (Exception e) {
            BPELUIPlugin.log(e, 2);
        }
        try {
            desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.bpel.ui", (String)"icons/misc/templates.png");
            this.tplImg = desc.createImage();
        }
        catch (Exception e) {
            BPELUIPlugin.log(e, 2);
        }
    }

    public void dispose() {
        if (this.wsdlImg != null && !this.wsdlImg.isDisposed()) {
            this.wsdlImg.dispose();
        }
        if (this.arrowImg != null && !this.arrowImg.isDisposed()) {
            this.arrowImg.dispose();
        }
        if (this.bpelImg != null && !this.bpelImg.isDisposed()) {
            this.bpelImg.dispose();
        }
        if (this.tplImg != null && !this.tplImg.isDisposed()) {
            this.tplImg.dispose();
        }
        super.dispose();
    }

    public IWizardPage getNextPage() {
        IWizardPage nextPage = this.creationMode == BpelCreationMode.CREATE_NEW_BPEL ? this.getWizard().getPage("wsdl-creation-page") : this.getWizard().getPage("port-type-page");
        nextPage.setPreviousPage((IWizardPage)this);
        return nextPage;
    }

    public boolean isAbstractProcess() {
        return this.abstractProcess;
    }

    public Map<String, Object> getProcessTemplateProperties() {
        return this.processTemplateProperties;
    }

    public BpelCreationMode getCreationMode() {
        return this.creationMode;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setFont(parent.getFont());
        this.initializeDialogUnits((Control)parent);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)container);
        Label label = new Label(container, 0);
        label.setText("Creation Mode:");
        label.setToolTipText("Select the way to create a new BPEL process");
        final ComboViewer creationViewer = new ComboViewer(container, 2060);
        creationViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        creationViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        creationViewer.setInput((Object)BpelCreationMode.values());
        Label l = new Label(container, 0);
        l.setText(Messages.NewFileWizardPage1_5);
        l.setToolTipText("The name of the BPEL process");
        Text processNameText = new Text(container, 2052);
        processNameText.setLayoutData((Object)new GridData(768));
        if (this.processName != null) {
            processNameText.setText(this.processName);
        }
        processNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewBpelFileFirstPage.this.processName = ((Text)e.widget).getText();
                NewBpelFileFirstPage.this.updateStatus();
            }
        });
        l = new Label(container, 0);
        l.setText(Messages.NewFileWizardPage1_6);
        l.setToolTipText("The target namespace of the BPEL process");
        Combo processNamespaceCombo = new Combo(container, 68);
        processNamespaceCombo.setLayoutData((Object)new GridData(768));
        processNamespaceCombo.setItems(BPELUIPlugin.INSTANCE.getTemplates().getNamespaceNames());
        if (this.processNamespace != null) {
            processNamespaceCombo.setText(this.processNamespace);
        }
        processNamespaceCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewBpelFileFirstPage.this.processNamespace = ((Combo)e.widget).getText();
                NewBpelFileFirstPage.this.updateStatus();
            }
        });
        new Label(container, 0);
        Button abstractProcessButton = new Button(container, 32);
        abstractProcessButton.setText("Abstract Process");
        abstractProcessButton.setToolTipText("Make the created process abstract");
        abstractProcessButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                NewBpelFileFirstPage.this.abstractProcess = ((Button)e.widget).getSelection();
                NewBpelFileFirstPage.this.updateStatus();
            }
        });
        Composite imageContainer = new Composite(container, 2048);
        imageContainer.setBackground(this.getShell().getDisplay().getSystemColor(1));
        GridLayout layout = new GridLayout(3, false);
        layout.horizontalSpacing = 0;
        layout.marginTop = 12;
        imageContainer.setLayout((Layout)layout);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        layoutData.verticalIndent = 21;
        imageContainer.setLayoutData((Object)layoutData);
        final Label imgLeftLabel = new Label(imageContainer, 0);
        imgLeftLabel.setBackground(this.getShell().getDisplay().getSystemColor(1));
        Label imgCenterLabel = new Label(imageContainer, 0);
        imgCenterLabel.setBackground(this.getShell().getDisplay().getSystemColor(1));
        imgCenterLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        imgCenterLabel.setImage(this.arrowImg);
        Label imgRightLabel = new Label(imageContainer, 0);
        imgRightLabel.setBackground(this.getShell().getDisplay().getSystemColor(1));
        imgRightLabel.setImage(this.bpelImg);
        final Text explainationText = new Text(imageContainer, 74);
        explainationText.setBackground(this.getShell().getDisplay().getSystemColor(1));
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 3;
        layoutData.verticalIndent = 21;
        explainationText.setLayoutData((Object)layoutData);
        creationViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewBpelFileFirstPage.this.creationMode = (BpelCreationMode)((Object)((IStructuredSelection)creationViewer.getSelection()).getFirstElement());
                explainationText.setText(NewBpelFileFirstPage.this.creationMode.getDescription());
                if (NewBpelFileFirstPage.this.creationMode == BpelCreationMode.GENERATE_BPEL_FROM_WSDL) {
                    imgLeftLabel.setImage(NewBpelFileFirstPage.this.wsdlImg);
                } else {
                    imgLeftLabel.setImage(NewBpelFileFirstPage.this.tplImg);
                }
                imgLeftLabel.getParent().layout();
                imgLeftLabel.getParent().getParent().layout();
                NewBpelFileFirstPage.this.updateStatus();
            }
        });
        creationViewer.setSelection((ISelection)new StructuredSelection((Object)BpelCreationMode.CREATE_NEW_BPEL));
        creationViewer.getCombo().notifyListeners(13, new Event());
        if (this.getErrorMessage() != null) {
            this.setPageComplete(false);
            this.setErrorMessage(null);
        }
    }

    private void updateStatus() {
        String errorMsg = this.validatePage();
        this.setPageComplete(errorMsg == null);
        this.setErrorMessage(errorMsg);
    }

    private String validatePage() {
        IDialogSettings settings;
        String errorMsg = null;
        if (this.processName == null || this.processName.trim().length() == 0) {
            errorMsg = "You have to specify the process name.";
        } else if (this.processName.matches("\\s")) {
            errorMsg = "The process name cannot contain spaces or white characters.";
        } else {
            IStatus nameStatus = ResourcesPlugin.getWorkspace().validateName(this.processName, 1);
            if (!nameStatus.isOK()) {
                errorMsg = nameStatus.getMessage();
            } else if (this.processNamespace == null || this.processNamespace.trim().length() == 0) {
                errorMsg = "You have to specify the process namespace.";
            }
        }
        if (errorMsg == null && this.creationMode == BpelCreationMode.CREATE_NEW_BPEL) {
            String bpelNamespace = this.abstractProcess ? "http://docs.oasis-open.org/wsbpel/2.0/process/abstract" : BPELConstants.NAMESPACE;
            this.processTemplateProperties.put("processName", this.processName);
            this.processTemplateProperties.put("namespace", this.processNamespace);
            this.processTemplateProperties.put("bpelNamespace", bpelNamespace);
            this.processTemplateProperties.put("date", new Date());
        }
        if ((settings = this.getWizard().getDialogSettings()) != null) {
            settings.put("process-name", this.processName);
        }
        return errorMsg;
    }

    public static enum BpelCreationMode {
        CREATE_NEW_BPEL,
        GENERATE_BPEL_FROM_WSDL;


        public String toString() {
            String result;
            switch (this) {
                case CREATE_NEW_BPEL: {
                    result = "Create a BPEL process from a template";
                    break;
                }
                case GENERATE_BPEL_FROM_WSDL: {
                    result = "Create a BPEL process from a service description";
                    break;
                }
                default: {
                    result = "";
                }
            }
            return result;
        }

        public String getDescription() {
            String result;
            switch (this) {
                case CREATE_NEW_BPEL: {
                    result = "This will generate a skeleton of BPEL process.\nThis skeleton is based on pre-defined templates.";
                    break;
                }
                case GENERATE_BPEL_FROM_WSDL: {
                    result = "This will generate a skeleton of BPEL process to implement a given WSDL contract.\n\t \u2666 \tThe resulting process starts with a pick activity.\n\t \u2666 \tMessage dispatching depends on the invoked operation.";
                    break;
                }
                default: {
                    result = "";
                }
            }
            return result;
        }
    }
}

