/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.bpel.common.extension.model.ExtensionMap;
import org.eclipse.bpel.model.Activity;
import org.eclipse.bpel.model.CorrelationSet;
import org.eclipse.bpel.model.PartnerLink;
import org.eclipse.bpel.model.Source;
import org.eclipse.bpel.model.Sources;
import org.eclipse.bpel.model.Target;
import org.eclipse.bpel.model.Targets;
import org.eclipse.bpel.model.Variable;
import org.eclipse.bpel.model.resource.BPELReader;
import org.eclipse.bpel.model.resource.BPELResource;
import org.eclipse.bpel.model.resource.BPELWriter;
import org.eclipse.bpel.model.util.BPELConstants;
import org.eclipse.bpel.ui.adapters.IContainer;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

public class TransferBuffer {
    protected static final boolean DEBUG = false;
    static final String NL = System.getProperty("line.separator");
    Clipboard fClipboard = null;
    BPELReader fReader = null;
    BPELWriter fWriter = null;
    Contents fContents;
    BPELResource fTargetResource;
    static Pattern anyNamespace = Pattern.compile("(\\:|\\s)xmlns=(\\\"|\\')", 8);
    static Pattern bpel2004DefaultNS = Pattern.compile("\\sxmlns=(\"|')" + Pattern.quote("http://schemas.xmlsoap.org/ws/2004/03/business-process/") + "(\"|')", 8);
    static Pattern bpel2003DefaultNS = Pattern.compile("\\sxmlns=(\"|')" + Pattern.quote("http://schemas.xmlsoap.org/ws/2003/03/business-process/") + "(\"|')", 8);
    static String EMPTY_STRING = "";

    public TransferBuffer(Display display) {
        this.fClipboard = new Clipboard(display);
        this.fWriter = new BPELWriter(){

            public BPELResource getResource() {
                return TransferBuffer.this.fTargetResource;
            }
        };
        this.fReader = new BPELReader(){

            public Resource getResource() {
                return TransferBuffer.this.fTargetResource;
            }
        };
    }

    public Contents getContents() {
        return this.fContents;
    }

    void setContents(Contents aContents) {
        this.fContents = aContents;
    }

    String getClipboardText() {
        return (String)this.fClipboard.getContents((Transfer)TextTransfer.getInstance());
    }

    List<EObject> getOutermostObjects(List<EObject> aList) {
        ArrayList<EObject> trimmedList = new ArrayList<EObject>(aList.size());
        for (EObject next : aList) {
            boolean skipNext = false;
            for (EObject parent : aList) {
                if (next == parent || !ModelHelper.isChildContainedBy(parent, next)) continue;
                skipNext = true;
                break;
            }
            if (skipNext) continue;
            trimmedList.add(next);
        }
        return trimmedList;
    }

    public void copyObjectsToTransferBuffer(List<EObject> sourceObjects, ExtensionMap sourceMap) {
        HashMap<EObject, EObject> targetMap = new HashMap<EObject, EObject>();
        List<EObject> sourceList = this.getOutermostObjects(sourceObjects);
        ArrayList<EObject> targetList = new ArrayList<EObject>();
        for (EObject source : sourceList) {
            EObject target = BPELUtil.cloneSubtree((EObject)source, (Map<EObject, EObject>)sourceMap, targetMap).targetRoot;
            targetList.add(target);
        }
        for (EObject next : targetList) {
            Targets targets;
            if (!(next instanceof Activity)) continue;
            Activity activity = (Activity)next;
            Sources sources = activity.getSources();
            if (sources != null) {
                for (Source source : sources.getChildren()) {
                    if (targetMap.containsValue(source.getLink())) continue;
                    source.setLink(null);
                    sources.getChildren().remove((Object)source);
                }
                if (sources.getChildren().isEmpty()) {
                    activity.setSources(null);
                }
            }
            if ((targets = activity.getTargets()) == null) continue;
            for (Target target : targets.getChildren()) {
                if (targetMap.containsValue(target.getLink())) continue;
                target.setLink(null);
                targets.getChildren().remove((Object)target);
            }
            if (!targets.getChildren().isEmpty()) continue;
            activity.setTargets(null);
        }
        if (this.fTargetResource == null) {
            this.fTargetResource = (BPELResource)ModelHelper.getBPELEditor(sourceList.get(0)).getResource();
        }
        Contents contents = new Contents(targetMap, targetList);
        contents.transferToClipboard();
        this.setContents(contents);
    }

    public List<EObject> copyTransferBuffer(EObject targetObject, ExtensionMap targetMap, boolean bReference) {
        String xml = this.getClipboardText();
        if (this.fContents == null || !xml.equals(this.fContents.fText)) {
            if (!this.couldBeXML(xml)) {
                this.setContents(null);
            } else {
                List result;
                if (this.fTargetResource == null) {
                    this.fTargetResource = (BPELResource)ModelHelper.getBPELEditor(targetObject).getResource();
                }
                if ((result = this.fReader.fromXML(TransferBuffer.adjustXMLSource(xml), "Clipboard", (Resource)this.fTargetResource)).size() > 0) {
                    this.setContents(new Contents(null, result));
                } else {
                    this.setContents(null);
                }
            }
        }
        Anchors anchors = this.getAnchors(targetObject, bReference, this.fContents);
        return this.copyContentsTo(this.fContents, anchors, targetMap);
    }

    List<EObject> copyContentsTo(Contents contents, Anchors anchors, ExtensionMap targetMap) {
        ArrayList<EObject> newObjects = new ArrayList<EObject>();
        if (contents == null) {
            return newObjects;
        }
        for (EObject source : contents.fRootObjects) {
            String uniqueName;
            Activity node;
            BPELUtil.CloneResult cloneResult = BPELUtil.cloneSubtree(source, contents.fExtensionMap, (Map<EObject, EObject>)targetMap);
            anchors.fContainer.addChild(anchors.fTarget, cloneResult.targetRoot, anchors.fRefObject);
            if (source instanceof Activity) {
                node = (Activity)cloneResult.targetRoot;
                uniqueName = BPELUtil.generateUniqueModelName(anchors.fTarget, node.getName(), (EObject)node);
                node.setName(BPELUtil.upperCaseFirstLetter(uniqueName));
            } else if (source instanceof Variable) {
                node = (Variable)cloneResult.targetRoot;
                uniqueName = BPELUtil.generateUniqueModelName(anchors.fTarget, node.getName(), (EObject)node);
                node.setName(uniqueName);
            } else if (source instanceof PartnerLink) {
                node = (PartnerLink)cloneResult.targetRoot;
                uniqueName = BPELUtil.generateUniqueModelName(anchors.fTarget, node.getName(), (EObject)node);
                node.setName(uniqueName);
            } else if (source instanceof CorrelationSet) {
                node = (CorrelationSet)cloneResult.targetRoot;
                uniqueName = BPELUtil.generateUniqueModelName(anchors.fTarget, node.getName(), (EObject)node);
                node.setName(uniqueName);
            }
            newObjects.add(cloneResult.targetRoot);
        }
        return newObjects;
    }

    Anchors getAnchors(EObject targetObject, boolean bReference, Contents contents) {
        Anchors anchors = new Anchors();
        anchors.fTarget = targetObject;
        anchors.fContainer = BPELUtil.adapt((Object)anchors.fTarget, IContainer.class);
        if (anchors.fContainer == null || bReference) {
            anchors.fRefObject = targetObject;
            anchors.fTarget = targetObject.eContainer();
            anchors.fContainer = BPELUtil.adapt((Object)anchors.fTarget, IContainer.class);
        } else {
            if (this.canCopyContents(anchors, contents)) {
                return anchors;
            }
            anchors.fRefObject = targetObject;
            anchors.fTarget = targetObject.eContainer();
            anchors.fContainer = BPELUtil.adapt((Object)anchors.fTarget, IContainer.class);
        }
        return anchors;
    }

    boolean canCopyContents(Anchors anchors, Contents content) {
        if (content == null) {
            return false;
        }
        for (EObject next : content.fRootObjects) {
            if (!anchors.fContainer.canAddObject(anchors.fTarget, next, anchors.fRefObject)) continue;
            return true;
        }
        return false;
    }

    public boolean canCopyTransferBufferTo(EObject targetObject, boolean bReference) {
        if (targetObject == null) {
            return false;
        }
        Anchors anchors = this.getAnchors(targetObject, bReference, this.fContents);
        if (anchors.fContainer == null) {
            return false;
        }
        return this.canCopyContents(anchors, this.fContents) || this.couldBeXML(this.getClipboardText());
    }

    boolean couldBeXML(String xml) {
        if (xml == null || xml.length() < 4) {
            return false;
        }
        int nOpen = 0;
        int nClose = 0;
        int nNonWhitespace = 0;
        char[] cArray = xml.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (!Character.isWhitespace(ch)) {
                if (ch == '<') {
                    if (nOpen == 0 && nNonWhitespace > 0) {
                        return false;
                    }
                    ++nOpen;
                } else if (ch == '>') {
                    ++nClose;
                } else {
                    ++nNonWhitespace;
                }
            }
            ++n2;
        }
        if (nOpen == 0 || nClose == 0) {
            return false;
        }
        float ratio = (float)((double)Math.min(nOpen, nClose) * 1.0 / 1.0 * (double)Math.max(nOpen, nClose));
        return !((double)ratio < 0.95);
    }

    public static String adjustXMLSource(String buffer) {
        Matcher matcher = anyNamespace.matcher(buffer);
        if (!matcher.find()) {
            StringBuilder sb = new StringBuilder(buffer.length() + 128);
            sb.append("<bag xmlns=\"").append(BPELConstants.NAMESPACE).append("\">").append(NL);
            sb.append(buffer);
            sb.append(NL).append("</bag>");
            return sb.toString();
        }
        matcher = bpel2004DefaultNS.matcher(buffer);
        if (matcher.find()) {
            return TransferBuffer.adjustXMLSource(matcher.replaceAll(EMPTY_STRING));
        }
        matcher = bpel2003DefaultNS.matcher(buffer);
        if (matcher.find()) {
            return TransferBuffer.adjustXMLSource(matcher.replaceAll(EMPTY_STRING));
        }
        return buffer;
    }

    public void dispose() {
        this.setContents(null);
        if (this.fClipboard != null) {
            this.fClipboard.dispose();
            this.fClipboard = null;
        }
    }

    class Anchors {
        EObject fTarget;
        EObject fRefObject;
        IContainer<EObject> fContainer;

        Anchors() {
        }
    }

    public class Contents {
        Map<EObject, EObject> fExtensionMap;
        List<EObject> fRootObjects;
        String fText;

        Contents(Map<EObject, EObject> extensionMap, List<EObject> rootList) {
            this.fExtensionMap = extensionMap;
            this.fRootObjects = rootList;
        }

        void transferToClipboard() {
            if (this.fRootObjects.size() == 1) {
                EObject ref = this.fRootObjects.get(0);
                this.fText = TransferBuffer.this.fWriter.toXML(ref);
            } else if (this.fRootObjects.size() > 1) {
                StringBuilder builder = new StringBuilder();
                builder.append("<bag>").append("\n\n");
                for (EObject obj : this.fRootObjects) {
                    builder.append(TransferBuffer.this.fWriter.toXML(obj));
                }
                builder.append("\n</bag>");
                this.fText = builder.toString();
            }
            TransferBuffer.this.fClipboard.setContents(new Object[]{this.fText}, new Transfer[]{TextTransfer.getInstance()});
        }
    }
}

