/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import java.util.Collections;
import org.eclipse.bpel.common.ui.details.viewers.CComboViewer;
import org.eclipse.bpel.common.ui.details.widgets.DecoratedLabel;
import org.eclipse.bpel.common.ui.details.widgets.StatusLabel2;
import org.eclipse.bpel.common.ui.flatui.FlatFormAttachment;
import org.eclipse.bpel.common.ui.flatui.FlatFormData;
import org.eclipse.bpel.common.ui.flatui.FlatFormLayout;
import org.eclipse.bpel.model.Variable;
import org.eclipse.bpel.ui.BPELEditor;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.adapters.ILabeledElement;
import org.eclipse.bpel.ui.details.providers.AddNullFilter;
import org.eclipse.bpel.ui.details.providers.AddSelectedObjectFilter;
import org.eclipse.bpel.ui.details.providers.FaultContentProvider;
import org.eclipse.bpel.ui.details.providers.ModelLabelProvider;
import org.eclipse.bpel.ui.details.providers.ModelTreeLabelProvider;
import org.eclipse.bpel.ui.details.providers.ModelViewerSorter;
import org.eclipse.bpel.ui.details.providers.OperationContentProvider;
import org.eclipse.bpel.ui.details.providers.PortTypeContentProvider;
import org.eclipse.bpel.ui.details.providers.VariableTypeTreeContentProvider;
import org.eclipse.bpel.ui.uiextensionmodel.VariableExtension;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.BrowseUtil;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDTypeDefinition;

public class VariableTypeSelector
extends Composite {
    public static final int KIND_UNKNOWN = 0;
    public static final int KIND_INTERFACE = 3;
    public static final int KIND_DATATYPE = 2;
    protected static final int DATATYPE_RADIO_CONTEXT = 1;
    protected static final int INTERFACE_RADIO_CONTEXT = 2;
    protected static final int OPERATION_INPUTRADIO_CONTEXT = 3;
    protected static final int OPERATION_OUTPUTRADIO_CONTEXT = 4;
    protected static final int OPERATION_FAULTRADIO_CONTEXT = 5;
    protected static final int OPERATION_COMBO_CONTEXT = 6;
    protected static final int INTERFACE_COMBO_CONTEXT = 7;
    protected static final int INTERFACE_BROWSE_CONTEXT = 8;
    protected static final int DATATYPE_BROWSE_CONTEXT = 9;
    protected static final int FAULT_COMBO_CONTEXT = 10;
    protected int lastChangeContext = -1;
    protected boolean inUpdate = false;
    protected int kindHint = 0;
    public static final int STANDARD_LABEL_WIDTH_SM = 125;
    public static final int STANDARD_LABEL_WIDTH_AVG = 156;
    protected EObject variableType;
    protected Variable myVariable;
    protected Button dataTypeRadio;
    protected Button interfaceRadio;
    protected Composite dataTypeComposite;
    protected Composite interfaceComposite;
    protected TabbedPropertySheetWidgetFactory wf;
    protected CComboViewer interfaceViewer;
    protected Button interfaceBrowseButton;
    protected CComboViewer operationViewer;
    protected Button operationInputRadio;
    protected Button operationOutputRadio;
    protected Button operationFaultRadio;
    protected CComboViewer faultViewer;
    protected Label interfaceLabel;
    protected Label operationLabel;
    protected Label faultLabel;
    protected AddSelectedObjectFilter interfaceAddSelectedObjectFilter;
    protected AddSelectedObjectFilter operationAddSelectedObjectFilter;
    protected AddSelectedObjectFilter faultAddSelectedObjectFilter;
    protected Button dataTypeBrowseButton;
    protected Hyperlink dataTypeNameText;
    protected Tree dataTypeTree;
    protected TreeViewer dataTypeTreeViewer;
    protected StatusLabel2 dataTypeLabel;
    protected BPELEditor bpelEditor;
    protected Callback callback;
    protected Shell shell;
    protected boolean nullFilterAdded = false;
    protected int filter = 255;
    protected boolean requireLowerTreeSelection = false;

    public VariableTypeSelector(Composite parent, int style, BPELEditor bpelEditor, TabbedPropertySheetWidgetFactory wf, Callback callback) {
        super(parent, style);
        this.bpelEditor = bpelEditor;
        this.shell = bpelEditor.getSite().getShell();
        this.wf = wf;
        this.callback = callback;
        Composite parentComposite = this.createComposite(this);
        this.setLayout((Layout)new FillLayout(512));
        FlatFormLayout formLayout = new FlatFormLayout();
        formLayout.marginHeight = 0;
        formLayout.marginWidth = 0;
        parentComposite.setLayout((Layout)formLayout);
        this.createDataTypeWidgets(parentComposite);
    }

    public VariableTypeSelector(Composite parent, int style, BPELEditor bpelEditor, TabbedPropertySheetWidgetFactory wf, Callback callback, boolean requireLowerTreeSelection, int filter) {
        this(parent, style, bpelEditor, wf, callback);
        this.filter = filter;
        this.requireLowerTreeSelection = requireLowerTreeSelection;
    }

    protected void refreshCCombo(CComboViewer viewer, Object selectedObject) {
        viewer.refresh();
        if (selectedObject == null) {
            viewer.setSelectionNoNotify((ISelection)new StructuredSelection(Collections.singletonList(null)), false);
        } else {
            viewer.setSelectionNoNotify((ISelection)new StructuredSelection(selectedObject), false);
        }
    }

    protected void selectComposite(int n) {
        this.interfaceRadio.setSelection(n == 3);
        this.interfaceComposite.setVisible(n == 3);
        this.dataTypeRadio.setSelection(n == 2);
        this.dataTypeComposite.setVisible(n == 2);
    }

    public void setVariableType(EObject variableType) {
        this.variableType = variableType;
        this.refresh();
    }

    public void setVariable(Variable variable) {
        this.kindHint = 0;
        this.myVariable = variable;
        if (variable != null) {
            if (variable.getMessageType() != null) {
                this.setVariableType((EObject)variable.getMessageType());
                return;
            }
            if (variable.getType() != null) {
                this.setVariableType((EObject)variable.getType());
                return;
            }
            if (variable.getXSDElement() != null) {
                this.setVariableType((EObject)variable.getXSDElement());
                return;
            }
            VariableExtension varExt = (VariableExtension)ModelHelper.getExtension((EObject)variable);
            if (varExt != null) {
                this.kindHint = varExt.getVariableKind();
            }
        }
        this.setVariableType(null);
    }

    protected void updateDataTypeWidgets() {
        String name = null;
        ILabeledElement label = (ILabeledElement)BPELUtil.adapt(this.variableType, ILabeledElement.class, this.myVariable);
        if (label != null) {
            name = label.getLabel(this.variableType);
        }
        if (name == null) {
            this.dataTypeNameText.setText(Messages.VariableTypeSelector_None_1);
            this.dataTypeNameText.setEnabled(false);
            this.dataTypeTreeViewer.setInput(null);
            this.dataTypeLabel.setText(Messages.VariableTypeSelector_Data_Type_2);
            return;
        }
        this.dataTypeNameText.setText(name);
        if (this.variableType instanceof XSDTypeDefinition) {
            this.dataTypeNameText.setEnabled(true);
            this.dataTypeTreeViewer.setInput((Object)this.variableType);
            this.dataTypeLabel.setText(Messages.VariableTypeSelector_Data_Type_2);
        } else if (this.variableType instanceof XSDElementDeclaration) {
            this.dataTypeNameText.setEnabled(true);
            this.dataTypeTreeViewer.setInput((Object)this.variableType);
            this.dataTypeLabel.setText(Messages.VariableTypeSelector_0);
        } else if (this.variableType instanceof Message) {
            this.dataTypeNameText.setEnabled(true);
            this.dataTypeTreeViewer.setInput((Object)this.variableType);
            this.dataTypeLabel.setText(Messages.VariableTypeSelector_1);
        }
        ScrollBar bar = this.dataTypeTree.getVerticalBar();
        if (bar != null) {
            bar.setSelection(0);
        }
    }

    protected void updateInterfaceWidgets() {
        PortType portType = null;
        Operation operation = null;
        Message message = null;
        if (this.variableType instanceof Message) {
            message = (Message)this.variableType;
        }
        if (message != null) {
            operation = BPELUtil.getOperationFromMessage(message);
        }
        if (operation != null) {
            portType = (PortType)operation.eContainer();
        }
        this.interfaceViewer.setInput((Object)this.bpelEditor.getProcess());
        this.interfaceAddSelectedObjectFilter.setSelectedObject(portType);
        this.inUpdate = true;
        try {
            this.refreshCCombo(this.interfaceViewer, portType);
            if (operation == null) {
                if (!this.nullFilterAdded) {
                    this.operationViewer.addFilter((ViewerFilter)AddNullFilter.getInstance());
                    this.nullFilterAdded = true;
                }
            } else if (this.nullFilterAdded) {
                this.operationViewer.removeFilter((ViewerFilter)AddNullFilter.getInstance());
                this.nullFilterAdded = false;
            }
            this.operationViewer.setInput((Object)portType);
            this.operationAddSelectedObjectFilter.setSelectedObject(operation);
            this.refreshCCombo(this.operationViewer, operation);
        }
        finally {
            this.inUpdate = false;
        }
        this.updateFaultRadio(message, operation);
    }

    protected void updateCompositeSelection() {
        int kind = this.kindHint;
        if (this.variableType instanceof Message) {
            kind = 3;
        } else if (this.variableType instanceof XSDTypeDefinition) {
            kind = 2;
        } else if (this.variableType instanceof XSDElementDeclaration) {
            kind = 2;
        }
        if (kind == 0) {
            kind = 2;
        }
        this.selectComposite(kind);
        this.doChildLayout();
    }

    protected void doChildLayout() {
        this.dataTypeComposite.layout(true);
    }

    public void refresh() {
        this.updateDataTypeWidgets();
    }

    public EObject getVariableType() {
        return this.variableType;
    }

    protected Composite createFlatFormComposite(Composite parent) {
        Composite result = this.createComposite(parent);
        FlatFormLayout formLayout = new FlatFormLayout();
        formLayout.marginHeight = 0;
        formLayout.marginWidth = 0;
        result.setLayout((Layout)formLayout);
        return result;
    }

    protected Message getStoreMessageFromOperation(Operation operation) {
        Message message = null;
        if (operation != null) {
            if (this.operationFaultRadio.getSelection()) {
                StructuredSelection sel = (StructuredSelection)this.faultViewer.getSelection();
                Fault fault = (Fault)sel.getFirstElement();
                if (fault != null) {
                    message = fault.getEMessage();
                }
                return message;
            }
            if (this.operationOutputRadio.getSelection()) {
                Output output = operation.getEOutput();
                if (output != null) {
                    message = output.getEMessage();
                }
                return message;
            }
            Input input = operation.getEInput();
            if (input != null) {
                message = input.getEMessage();
            }
            return message;
        }
        return message;
    }

    protected void createRadioButtonWidgets(Composite composite) {
        this.dataTypeRadio = this.createButton(composite, Messages.VariableTypeSelector_Data_Type_1, 16);
        FlatFormData data = new FlatFormData();
        data.top = new FlatFormAttachment(0, 0);
        data.left = new FlatFormAttachment(0, 0);
        this.dataTypeRadio.setLayoutData((Object)data);
        this.interfaceRadio = this.createButton(composite, Messages.VariableTypeSelector_Interface_1, 16);
        data = new FlatFormData();
        data.top = new FlatFormAttachment(0, 0);
        data.left = new FlatFormAttachment((Control)this.dataTypeRadio, 5);
        this.interfaceRadio.setLayoutData((Object)data);
        this.interfaceRadio.addSelectionListener((SelectionListener)new RadioListener(3));
        this.dataTypeRadio.addSelectionListener((SelectionListener)new RadioListener(2));
    }

    protected void createInterfaceWidgets(Composite parent) {
        Composite composite = this.interfaceComposite = this.createFlatFormComposite(parent);
        FlatFormData data = new FlatFormData();
        data.top = new FlatFormAttachment((Control)this.interfaceRadio, 6);
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment(100, 0);
        data.bottom = new FlatFormAttachment(100, 0);
        this.interfaceComposite.setLayoutData((Object)data);
        this.interfaceBrowseButton = this.createButton(composite, Messages.VariableTypeSelector_Browse_1, 8);
        this.interfaceLabel = this.createLabel(composite, Messages.VariableTypeSelector_Interface_2);
        CCombo interfaceCombo = this.createCCombo(composite);
        this.interfaceViewer = new CComboViewer(interfaceCombo);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment((Control)interfaceCombo, -5);
        data.top = new FlatFormAttachment((Control)interfaceCombo, 0, 0x1000000);
        this.interfaceLabel.setLayoutData((Object)data);
        this.interfaceAddSelectedObjectFilter = new AddSelectedObjectFilter();
        this.interfaceViewer.addFilter((ViewerFilter)AddNullFilter.getInstance());
        this.interfaceViewer.addFilter((ViewerFilter)this.interfaceAddSelectedObjectFilter);
        this.interfaceViewer.setLabelProvider((IBaseLabelProvider)new ModelLabelProvider());
        this.interfaceViewer.setContentProvider((IContentProvider)new PortTypeContentProvider());
        this.interfaceViewer.setSorter((ViewerSorter)ModelViewerSorter.getInstance());
        this.interfaceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                PortType portType = (PortType)selection.getFirstElement();
                Operation operation = null;
                if (portType != null && !portType.getEOperations().isEmpty()) {
                    operation = (Operation)portType.getEOperations().get(0);
                }
                VariableTypeSelector.this.lastChangeContext = 7;
                Message message = VariableTypeSelector.this.computeMessageFromOperation(operation);
                VariableTypeSelector.this.callback.selectMessageType(message);
                VariableTypeSelector.this.updateFaultRadio(message, operation);
            }
        });
        this.interfaceBrowseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PortType portType = BrowseUtil.browseForPortType(VariableTypeSelector.this.bpelEditor.getResourceSet(), VariableTypeSelector.this.shell);
                if (portType != null) {
                    Operation operation = null;
                    if (!portType.getEOperations().isEmpty()) {
                        operation = (Operation)portType.getEOperations().get(0);
                    }
                    VariableTypeSelector.this.lastChangeContext = 8;
                    Message message = VariableTypeSelector.this.computeMessageFromOperation(operation);
                    VariableTypeSelector.this.callback.selectMessageType(message);
                    VariableTypeSelector.this.updateFaultRadio(message, operation);
                }
            }
        });
        this.operationLabel = this.createLabel(composite, Messages.VariableTypeSelector_Operation_1);
        CCombo operationCombo = this.createCCombo(composite);
        this.operationViewer = new CComboViewer(operationCombo);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment((Control)operationCombo, -5);
        data.top = new FlatFormAttachment((Control)operationCombo, 0, 0x1000000);
        this.operationLabel.setLayoutData((Object)data);
        this.operationAddSelectedObjectFilter = new AddSelectedObjectFilter();
        this.operationViewer.addFilter((ViewerFilter)this.operationAddSelectedObjectFilter);
        this.operationViewer.setLabelProvider((IBaseLabelProvider)new ModelLabelProvider());
        this.operationViewer.setContentProvider((IContentProvider)new OperationContentProvider());
        this.operationViewer.setSorter((ViewerSorter)ModelViewerSorter.getInstance());
        this.operationViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                Operation operation = (Operation)selection.getFirstElement();
                VariableTypeSelector.this.lastChangeContext = 6;
                Message message = VariableTypeSelector.this.computeMessageFromOperation(operation);
                VariableTypeSelector.this.callback.selectMessageType(message);
                VariableTypeSelector.this.updateFaultRadio(message, operation);
            }
        });
        Label directionLabel = this.createLabel(composite, Messages.VariableTypeSelector_Direction_1);
        this.operationInputRadio = this.createButton(composite, Messages.VariableTypeSelector_Input_1, 16);
        data = new FlatFormData();
        data.top = new FlatFormAttachment((Control)this.operationViewer.getCCombo(), 4);
        data.left = new FlatFormAttachment(0, BPELUtil.calculateLabelWidth((Widget)directionLabel, 125));
        this.operationInputRadio.setLayoutData((Object)data);
        this.operationInputRadio.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!VariableTypeSelector.this.operationInputRadio.getSelection()) {
                    return;
                }
                StructuredSelection selection = (StructuredSelection)VariableTypeSelector.this.operationViewer.getSelection();
                Operation operation = (Operation)selection.getFirstElement();
                VariableTypeSelector.this.lastChangeContext = 3;
                VariableTypeSelector.this.callback.selectMessageType(VariableTypeSelector.this.getStoreMessageFromOperation(operation));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.operationOutputRadio = this.createButton(composite, Messages.VariableTypeSelector_Output_1, 16);
        data = new FlatFormData();
        data.top = new FlatFormAttachment((Control)this.operationInputRadio, 0, 128);
        data.left = new FlatFormAttachment((Control)this.operationInputRadio, 5);
        this.operationOutputRadio.setLayoutData((Object)data);
        this.operationOutputRadio.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!VariableTypeSelector.this.operationOutputRadio.getSelection()) {
                    return;
                }
                StructuredSelection selection = (StructuredSelection)VariableTypeSelector.this.operationViewer.getSelection();
                Operation operation = (Operation)selection.getFirstElement();
                VariableTypeSelector.this.lastChangeContext = 4;
                VariableTypeSelector.this.callback.selectMessageType(VariableTypeSelector.this.getStoreMessageFromOperation(operation));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.operationFaultRadio = this.createButton(composite, Messages.VariableTypeSelector_Fault_1, 16);
        data = new FlatFormData();
        data.top = new FlatFormAttachment((Control)this.operationOutputRadio, 0, 128);
        data.left = new FlatFormAttachment((Control)this.operationOutputRadio, 5);
        this.operationFaultRadio.setLayoutData((Object)data);
        this.operationFaultRadio.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!VariableTypeSelector.this.operationFaultRadio.getSelection()) {
                    return;
                }
                StructuredSelection selection = (StructuredSelection)VariableTypeSelector.this.operationViewer.getSelection();
                Operation operation = (Operation)selection.getFirstElement();
                VariableTypeSelector.this.lastChangeContext = 5;
                Fault fault = (Fault)operation.getEFaults().get(0);
                Message message = fault.getEMessage();
                VariableTypeSelector.this.callback.selectMessageType(message);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.faultLabel = this.createLabel(composite, Messages.VariableTypeSelector_Fault_2);
        CCombo faultCombo = this.createCCombo(composite);
        this.faultViewer = new CComboViewer(faultCombo);
        data = new FlatFormData();
        data.top = new FlatFormAttachment((Control)faultCombo, 0, 0x1000000);
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment((Control)faultCombo, -5);
        this.faultLabel.setLayoutData((Object)data);
        this.faultAddSelectedObjectFilter = new AddSelectedObjectFilter();
        this.faultViewer.addFilter((ViewerFilter)this.faultAddSelectedObjectFilter);
        this.faultViewer.setLabelProvider((IBaseLabelProvider)new ModelLabelProvider());
        this.faultViewer.setContentProvider((IContentProvider)new FaultContentProvider());
        this.faultViewer.setSorter((ViewerSorter)ModelViewerSorter.getInstance());
        this.faultViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)VariableTypeSelector.this.operationViewer.getSelection();
                Operation operation = (Operation)selection.getFirstElement();
                VariableTypeSelector.this.lastChangeContext = 10;
                VariableTypeSelector.this.callback.selectMessageType(VariableTypeSelector.this.getStoreMessageFromOperation(operation));
            }
        });
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment((Control)operationCombo, -5);
        data.top = new FlatFormAttachment((Control)this.operationInputRadio, 0, 0x1000000);
        directionLabel.setLayoutData((Object)data);
        this.internalSetLayoutData();
    }

    protected void createDataTypeWidgets(Composite parent) {
        Composite composite = this.dataTypeComposite = this.createFlatFormComposite(parent);
        FlatFormData data = new FlatFormData();
        data.top = new FlatFormAttachment(0, 6);
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment(100, 0);
        data.bottom = new FlatFormAttachment(100, 0);
        this.dataTypeComposite.setLayoutData((Object)data);
        this.dataTypeBrowseButton = this.createButton(composite, Messages.VariableTypeSelector_Browse_2, 8);
        DecoratedLabel label = new DecoratedLabel(composite, 16384);
        label.setText(Messages.VariableTypeSelector_Data_Type_2);
        this.wf.adapt((Composite)label);
        this.dataTypeLabel = new StatusLabel2(label);
        this.dataTypeLabel.getLabel().setBackground(this.getBackground());
        this.dataTypeNameText = this.createHyperlink(composite, "", 0);
        this.dataTypeNameText.setToolTipText(Messages.VariableTypeSelector_3);
        this.dataTypeNameText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (VariableTypeSelector.this.getVariableType() != null) {
                    BPELUtil.openEditor(VariableTypeSelector.this.getVariableType(), VariableTypeSelector.this.bpelEditor);
                }
            }
        });
        Label dataTypeTreeLabel = this.createLabel(composite, Messages.VariableTypeSelector_2);
        this.dataTypeTree = this.wf.createTree(composite, 0);
        VariableTypeTreeContentProvider variableContentProvider = new VariableTypeTreeContentProvider(true, true);
        this.dataTypeTreeViewer = new TreeViewer(this.dataTypeTree);
        this.dataTypeTreeViewer.setContentProvider((IContentProvider)variableContentProvider);
        this.dataTypeTreeViewer.setLabelProvider((IBaseLabelProvider)new ModelTreeLabelProvider());
        this.dataTypeTreeViewer.setInput(null);
        this.dataTypeTreeViewer.setAutoExpandLevel(3);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, BPELUtil.calculateLabelWidth((Widget)this.dataTypeLabel.getControl(), 125));
        data.top = new FlatFormAttachment(0, 4);
        data.right = new FlatFormAttachment(60, 0);
        this.dataTypeNameText.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 5);
        data.right = new FlatFormAttachment((Control)this.dataTypeNameText, -5);
        data.top = new FlatFormAttachment((Control)this.dataTypeNameText, -4, 128);
        data.bottom = new FlatFormAttachment((Control)this.dataTypeNameText, 0, 1024);
        this.dataTypeLabel.setLayoutData((Object)data);
        data = new FlatFormData();
        data.top = new FlatFormAttachment((Control)this.dataTypeNameText, -2, 128);
        data.bottom = new FlatFormAttachment((Control)this.dataTypeLabel.getLabel(), 2, 1024);
        data.right = new FlatFormAttachment(100, -5);
        this.dataTypeBrowseButton.setLayoutData((Object)data);
        this.dataTypeBrowseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object[] selection = BrowseUtil.browseForVariableType((EObject)VariableTypeSelector.this.bpelEditor.getProcess(), VariableTypeSelector.this.getShell(), VariableTypeSelector.this.requireLowerTreeSelection, VariableTypeSelector.this.filter);
                if (selection != null) {
                    Object xsdType = selection[0];
                    VariableTypeSelector.this.lastChangeContext = 9;
                    if (xsdType instanceof XSDTypeDefinition) {
                        VariableTypeSelector.this.callback.selectXSDType((XSDTypeDefinition)xsdType);
                    } else if (xsdType instanceof XSDElementDeclaration) {
                        VariableTypeSelector.this.callback.selectXSDElement((XSDElementDeclaration)xsdType);
                    } else if (xsdType instanceof Message) {
                        VariableTypeSelector.this.callback.selectMessageType((Message)xsdType);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 5);
        data.top = new FlatFormAttachment((Control)this.dataTypeLabel.getLabel(), 12, 1024);
        dataTypeTreeLabel.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment((Control)dataTypeTreeLabel, 0, 16384);
        data.top = new FlatFormAttachment((Control)dataTypeTreeLabel, 0, 1024);
        data.right = new FlatFormAttachment(100, -5);
        data.bottom = new FlatFormAttachment((Control)dataTypeTreeLabel, 150, 1024);
        this.dataTypeTree.setLayoutData((Object)data);
    }

    public Object getUserContext() {
        return this.lastChangeContext;
    }

    public void restoreUserContext(Object userContext) {
        switch ((Integer)userContext) {
            case 1: {
                this.dataTypeRadio.setFocus();
                return;
            }
            case 2: {
                this.interfaceRadio.setFocus();
                return;
            }
            case 3: {
                this.operationInputRadio.setFocus();
                return;
            }
            case 4: {
                this.operationOutputRadio.setFocus();
                return;
            }
            case 5: {
                this.operationFaultRadio.setFocus();
                return;
            }
            case 6: {
                this.operationViewer.getCCombo().setFocus();
                return;
            }
            case 7: {
                this.interfaceViewer.getCCombo().setFocus();
                return;
            }
            case 8: {
                this.interfaceBrowseButton.setFocus();
                return;
            }
            case 9: {
                this.dataTypeBrowseButton.setFocus();
                return;
            }
            case 10: {
                this.faultViewer.getCCombo().setFocus();
                return;
            }
        }
        throw new IllegalStateException();
    }

    public void setEnabled(boolean enabled) {
        this.setEnabled(enabled, (Control)this, 0);
    }

    void setEnabled(boolean enabled, Control control, int depth) {
        if (control instanceof Composite) {
            Composite root = (Composite)control;
            Control[] list = root.getChildren();
            int i = 0;
            while (i < list.length) {
                this.setEnabled(enabled, list[i], depth + 1);
                ++i;
            }
        }
        if (depth > 0) {
            control.setEnabled(enabled);
        }
    }

    protected Button createButton(Composite parent, String text, int style) {
        return this.wf.createButton(parent, text, style);
    }

    protected Composite createComposite(Composite parent) {
        return this.wf.createComposite(parent);
    }

    protected Label createLabel(Composite parent, String text) {
        return this.wf.createLabel(parent, text);
    }

    protected Hyperlink createHyperlink(Composite parent, String text, int style) {
        return this.wf.createHyperlink(parent, text, style);
    }

    protected CCombo createCCombo(Composite parent) {
        return this.wf.createCCombo(parent);
    }

    protected void internalSetLayoutData() {
        FlatFormData data = new FlatFormData();
        data.top = new FlatFormAttachment(this.interfaceViewer.getControl(), -1, 128);
        data.bottom = new FlatFormAttachment(this.interfaceViewer.getControl(), 1, 1024);
        data.right = new FlatFormAttachment(100, -5);
        this.interfaceBrowseButton.setLayoutData((Object)data);
        data = new FlatFormData();
        data.top = new FlatFormAttachment(0, 2);
        data.left = new FlatFormAttachment(0, BPELUtil.calculateLabelWidth((Widget)this.interfaceLabel, 125));
        data.right = new FlatFormAttachment((Control)this.interfaceBrowseButton, -5);
        this.interfaceViewer.getControl().setLayoutData((Object)data);
        data = new FlatFormData();
        data.top = new FlatFormAttachment(this.interfaceViewer.getControl(), 4);
        data.left = new FlatFormAttachment(0, BPELUtil.calculateLabelWidth((Widget)this.operationLabel, 125));
        data.right = new FlatFormAttachment((Control)this.interfaceBrowseButton, -5);
        this.operationViewer.getControl().setLayoutData((Object)data);
        data = new FlatFormData();
        data.top = new FlatFormAttachment((Control)this.operationFaultRadio, 4);
        data.left = new FlatFormAttachment(0, BPELUtil.calculateLabelWidth((Widget)this.faultLabel, 125));
        data.right = new FlatFormAttachment((Control)this.interfaceBrowseButton, -5);
        this.faultViewer.getCCombo().setLayoutData((Object)data);
    }

    protected void updateFaultRadio(Message message, Operation operation) {
        boolean isInput = true;
        boolean isOutput = false;
        boolean isFault = false;
        Fault fault = null;
        if (operation != null && message != null) {
            Message outputMessage;
            for (Fault nextFault : operation.getEFaults()) {
                Message faultMessage = nextFault.getEMessage();
                if (faultMessage == null || faultMessage.getQName() == null || !faultMessage.getQName().equals(message.getQName())) continue;
                isFault = true;
                isInput = false;
                isOutput = false;
                fault = nextFault;
            }
            Output output = operation.getEOutput();
            if (output != null && (outputMessage = output.getEMessage()) != null && outputMessage.getQName() != null && outputMessage.getQName().equals(message.getQName())) {
                isOutput = true;
                isInput = false;
                isFault = false;
            }
        }
        this.operationInputRadio.setSelection(isInput);
        this.operationOutputRadio.setSelection(isOutput);
        this.operationFaultRadio.setSelection(isFault);
        this.operationFaultRadio.setVisible(operation != null && !operation.getEFaults().isEmpty());
        this.faultLabel.setVisible(isFault);
        this.faultViewer.getCCombo().setVisible(isFault);
        if (isFault && operation != null) {
            this.faultViewer.setInput((Object)operation);
            this.refreshCCombo(this.faultViewer, fault);
        }
        this.layout(true);
        this.faultViewer.getCCombo().getParent().redraw();
        this.faultViewer.getCCombo().redraw();
        this.interfaceComposite.layout(true);
    }

    protected Message computeMessageFromOperation(Operation operation) {
        Message message = null;
        if (this.operationFaultRadio.getSelection()) {
            if (operation.getEFaults().isEmpty()) {
                this.operationFaultRadio.setSelection(false);
                this.operationOutputRadio.setSelection(true);
                message = this.getStoreMessageFromOperation(operation);
            } else {
                Fault fault = (Fault)operation.getEFaults().get(0);
                message = fault.getEMessage();
            }
        } else {
            message = this.getStoreMessageFromOperation(operation);
        }
        return message;
    }

    public static interface Callback {
        public static final int KIND_DATATYPE = 2;
        public static final int KIND_INTERFACE = 3;

        public void selectRadioButton(int var1);

        public void selectXSDType(XSDTypeDefinition var1);

        public void selectXSDElement(XSDElementDeclaration var1);

        public void selectMessageType(Message var1);
    }

    class RadioListener
    implements SelectionListener {
        int index;

        public RadioListener(int index) {
            this.index = index;
        }

        public void widgetSelected(SelectionEvent e) {
            if (!((Button)e.widget).getSelection()) {
                return;
            }
            VariableTypeSelector.this.lastChangeContext = this.index;
            VariableTypeSelector.this.callback.selectRadioButton(this.index);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

