/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.bpel.common.ui.flatui.FlatFormAttachment;
import org.eclipse.bpel.common.ui.flatui.FlatFormData;
import org.eclipse.bpel.model.BPELFactory;
import org.eclipse.bpel.model.BPELPackage;
import org.eclipse.bpel.model.From;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.To;
import org.eclipse.bpel.model.Variable;
import org.eclipse.bpel.model.util.XSD2XMLGenerator;
import org.eclipse.bpel.ui.BPELEditor;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.commands.SetCommand;
import org.eclipse.bpel.ui.properties.BPELPropertySection;
import org.eclipse.bpel.ui.properties.CategorySection;
import org.eclipse.bpel.ui.properties.EndpointReferenceAssignCategory;
import org.eclipse.bpel.ui.properties.ExpressionAssignCategory;
import org.eclipse.bpel.ui.properties.IAssignCategory;
import org.eclipse.bpel.ui.properties.LiteralAssignCategory;
import org.eclipse.bpel.ui.properties.NullAssignCategory;
import org.eclipse.bpel.ui.properties.OpaqueAssignCategory;
import org.eclipse.bpel.ui.properties.PartnerRoleAssignCategory;
import org.eclipse.bpel.ui.properties.VariablePartAssignCategory;
import org.eclipse.bpel.ui.properties.VariablePropertyAssignCategory;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.MultiObjectAdapter;
import org.eclipse.bpel.validator.EmfModelQuery;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDTypeDefinition;

public class VariableInitializationSection
extends BPELPropertySection {
    CategorySection fFromSection = new CategorySection(this);
    Variable fVariable;
    Composite copySelectComposite;

    public VariableInitializationSection() {
        this.fFromSection.fAllowed = new IAssignCategory[]{new VariablePartAssignCategory(this), new ExpressionAssignCategory(this), new LiteralAssignCategory(this), new VariablePropertyAssignCategory(this), new PartnerRoleAssignCategory(this, true), new EndpointReferenceAssignCategory(this), new OpaqueAssignCategory(this), new NullAssignCategory(this)};
    }

    protected boolean isFromAffected(Notification n) {
        return n.getFeature() == BPELPackage.eINSTANCE.getVariable_From();
    }

    @Override
    protected MultiObjectAdapter[] createAdapters() {
        return new MultiObjectAdapter[]{new MultiObjectAdapter(){

            @Override
            public void notify(Notification n) {
                if (VariableInitializationSection.this.isFromAffected(n)) {
                    VariableInitializationSection.this.selectCategoriesForInput(null);
                }
            }
        }};
    }

    protected void createCategorySectionWidgets(Composite composite, final CategorySection section) {
        section.fLabel = this.fWidgetFactory.createLabel(composite, Messages.AssignImplDetails_From__1);
        section.fCombo = new Combo(composite, 0x800808);
        FlatFormData data = new FlatFormData();
        data.left = new FlatFormAttachment(0, BPELUtil.calculateLabelWidth((Widget)section.fLabel, 105));
        data.right = new FlatFormAttachment(100, 0);
        data.top = new FlatFormAttachment(0, 0);
        section.fCombo.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment((Control)section.fCombo, -10);
        data.top = new FlatFormAttachment((Control)section.fCombo, 0, 0x1000000);
        section.fLabel.setLayoutData((Object)data);
        IAssignCategory[] iAssignCategoryArray = section.fAllowed;
        int n = section.fAllowed.length;
        int n2 = 0;
        while (n2 < n) {
            IAssignCategory category = iAssignCategoryArray[n2];
            section.fCombo.add(category.getName());
            ++n2;
        }
        section.fCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = section.fCombo.getSelectionIndex();
                VariableInitializationSection.this.updateCategorySelection(section, index, true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        section.fOuterComposite = this.createFlatFormComposite(composite);
        data = new FlatFormData();
        data.left = new FlatFormAttachment((Control)section.fLabel, 0, 16384);
        data.right = new FlatFormAttachment((Control)section.fCombo, 0, 131072);
        data.top = new FlatFormAttachment((Control)section.fCombo, 4);
        data.bottom = new FlatFormAttachment(100, 0);
        section.fOuterComposite.setLayoutData((Object)data);
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    @Override
    protected void createClient(Composite parent) {
        Composite composite = this.createFlatFormComposite(parent);
        Composite mainComposite = this.createFlatFormComposite(composite);
        FlatFormData data = new FlatFormData();
        data.left = new FlatFormAttachment((Control)this.copySelectComposite, 5);
        data.top = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment(100, 0);
        data.bottom = new FlatFormAttachment(100, 0);
        mainComposite.setLayoutData((Object)data);
        this.createCategorySectionWidgets(mainComposite, this.fFromSection);
    }

    @Override
    protected void basicSetInput(EObject newInput) {
        super.basicSetInput(newInput);
        this.fVariable = (Variable)this.getModel();
        this.selectCategoriesForInput(this.fVariable);
    }

    protected void selectCategoriesForInput(Variable variable) {
        if (variable != null) {
            this.fVariable = variable;
        }
        IAssignCategory[] iAssignCategoryArray = this.fFromSection.fAllowed;
        int n = this.fFromSection.fAllowed.length;
        int n2 = 0;
        while (n2 < n) {
            IAssignCategory category = iAssignCategoryArray[n2];
            if (category.isCategoryForModel((EObject)this.fVariable.getFrom())) {
                this.updateCategorySelection(this.fFromSection, category, false);
                return;
            }
            ++n2;
        }
        if (this.fFromSection.fCurrent == null) {
            this.updateCategorySelection(this.fFromSection, 0, false);
        }
    }

    @Override
    public void refresh() {
        super.refresh();
    }

    @Override
    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        if (this.fFromSection.fCurrent != null) {
            this.fFromSection.fCurrent.aboutToBeHidden();
        }
    }

    @Override
    public void aboutToBeShown() {
        super.aboutToBeShown();
        if (this.fFromSection.fCurrent != null) {
            this.fFromSection.fCurrent.aboutToBeShown();
        }
    }

    void updateCategorySelection(CategorySection section, int index, boolean bVisual) {
        this.updateCategorySelection(section, section.fAllowed[index], bVisual);
    }

    void updateCategorySelection(CategorySection section, IAssignCategory newCurrent, boolean bVisual) {
        String literal;
        From from;
        if (section.fCurrent != newCurrent) {
            section.hideCurrent();
            section.fCurrent = newCurrent;
            section.ensureCategoryCompositeCreated();
        }
        if (bVisual || this.fVariable.getFrom() == null) {
            SetCommand cmd = !section.fCurrent.isCategoryForModel(null) ? new SetCommand((EObject)this.getInput(), BPELFactory.eINSTANCE.createFrom(), (EStructuralFeature)BPELPackage.eINSTANCE.getVariable_From()) : new SetCommand((EObject)this.getInput(), null, (EStructuralFeature)BPELPackage.eINSTANCE.getVariable_From());
            this.getBPELEditor().getCommandFramework().execute((Command)cmd);
        }
        if (!bVisual) {
            section.updateCombo();
        }
        if (section.fCurrent instanceof LiteralAssignCategory && (from = this.fVariable.getFrom()) != null && ((literal = from.getLiteral()) == null || "".equals(literal.trim()))) {
            literal = VariableInitializationSection.createDefaultInitializer(this.getBPELEditor(), this.fVariable, null);
            from.setLiteral(literal);
        }
        section.fCurrent.setInput((EObject)this.fVariable.getFrom());
        section.showCurrent();
        section.fCurrent.refresh();
    }

    @Override
    public Object getUserContext() {
        return null;
    }

    @Override
    public void restoreUserContext(Object userContext) {
    }

    @Override
    public void gotoMarker(IMarker marker) {
        this.refresh();
    }

    public static String createDefaultInitializer(BPELEditor bpelEditor, From from, To to) {
        String literal = "";
        if (from != null && to != null && ((literal = from.getLiteral()) == null || literal.isEmpty())) {
            literal = VariableInitializationSection.createDefaultInitializer(bpelEditor, to.getVariable(), to.getPart());
            from.setLiteral(literal);
        }
        return literal;
    }

    public static String createDefaultInitializer(BPELEditor bpelEditor, Variable var, Part part) {
        String fromString = "";
        try {
            XSDElementDeclaration element;
            XSDTypeDefinition type;
            String rootElement = null;
            String uriWSDL = null;
            Message msg = var.getMessageType();
            if (msg != null) {
                XSDElementDeclaration declaration;
                Map parts;
                if (msg.eIsProxy()) {
                    msg = (Message)EmfModelQuery.resolveProxy((Process)bpelEditor.getProcess(), (EObject)msg);
                }
                if (part == null && (parts = msg.getParts()) != null && !parts.isEmpty()) {
                    Map.Entry entry = parts.entrySet().iterator().next();
                    part = (Part)entry.getValue();
                }
                if (part != null && (declaration = part.getElementDeclaration()) != null) {
                    uriWSDL = declaration.getSchema().getSchemaLocation();
                    rootElement = declaration.getName();
                }
            }
            if ((type = var.getType()) != null) {
                QName qname = new QName(type.getTargetNamespace(), type.getName());
                rootElement = qname.getLocalPart();
                uriWSDL = type.eResource().getURI().toString();
            }
            if ((element = var.getXSDElement()) != null) {
                QName qname = new QName(element.getTargetNamespace(), element.getName());
                rootElement = qname.getLocalPart();
                uriWSDL = element.eResource().getURI().toString();
            }
            XSD2XMLGenerator generator = new XSD2XMLGenerator(uriWSDL, rootElement);
            fromString = generator.createXML();
        }
        catch (Exception exception) {}
        return fromString;
    }
}

