/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpel.common.ui.assist.FieldAssistAdapter;
import org.eclipse.bpel.common.ui.flatui.FlatFormAttachment;
import org.eclipse.bpel.common.ui.flatui.FlatFormData;
import org.eclipse.bpel.model.BPELFactory;
import org.eclipse.bpel.model.Invoke;
import org.eclipse.bpel.model.OnEvent;
import org.eclipse.bpel.model.OnMessage;
import org.eclipse.bpel.model.PartnerLink;
import org.eclipse.bpel.model.Receive;
import org.eclipse.bpel.model.Reply;
import org.eclipse.bpel.model.Variable;
import org.eclipse.bpel.model.partnerlinktype.PartnerLinkType;
import org.eclipse.bpel.model.partnerlinktype.Role;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.adapters.ILabeledElement;
import org.eclipse.bpel.ui.commands.AddPartnerLinkCommand;
import org.eclipse.bpel.ui.commands.AddVariableCommand;
import org.eclipse.bpel.ui.commands.CompoundCommand;
import org.eclipse.bpel.ui.commands.SetCommand;
import org.eclipse.bpel.ui.commands.SetOnEventVariableTypeCommand;
import org.eclipse.bpel.ui.commands.SetOperationCommand;
import org.eclipse.bpel.ui.commands.SetPartnerLinkCommand;
import org.eclipse.bpel.ui.commands.SetVariableCommand;
import org.eclipse.bpel.ui.commands.SetWSDLFaultCommand;
import org.eclipse.bpel.ui.commands.util.AutoUndoCommand;
import org.eclipse.bpel.ui.details.providers.ModelLabelProvider;
import org.eclipse.bpel.ui.details.providers.ModelTreeLabelProvider;
import org.eclipse.bpel.ui.details.providers.OperationContentProvider;
import org.eclipse.bpel.ui.details.providers.PartnerLinkContentProvider;
import org.eclipse.bpel.ui.details.providers.PartnerLinkTreeContentProvider;
import org.eclipse.bpel.ui.details.providers.PartnerRoleFilter;
import org.eclipse.bpel.ui.details.providers.WSDLFaultContentProvider;
import org.eclipse.bpel.ui.details.tree.ITreeNode;
import org.eclipse.bpel.ui.details.tree.TreeNode;
import org.eclipse.bpel.ui.dialogs.PartnerLinkRoleSelectorDialog;
import org.eclipse.bpel.ui.dialogs.PartnerLinkTypeSelectorDialog;
import org.eclipse.bpel.ui.properties.BPELPropertySection;
import org.eclipse.bpel.ui.proposal.providers.ModelContentProposalProvider;
import org.eclipse.bpel.ui.proposal.providers.RunnableProposal;
import org.eclipse.bpel.ui.proposal.providers.Separator;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.ListMap;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.bpel.ui.util.MultiObjectAdapter;
import org.eclipse.bpel.ui.util.NameDialog;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.WSDLFactory;
import org.eclipse.xsd.XSDElementDeclaration;

public class InvokeImplSection
extends BPELPropertySection {
    static final String NONE = Messages.InvokeImplSection_None_1;
    protected static final int PARTNER_CONTEXT = 0;
    protected static final int OPERATION_CONTEXT = 1;
    protected static final int FAULTNAME_CONTEXT = 4;
    private int lastChangeContext = -1;
    private Composite parentComposite;
    private Label partnerLabel;
    private Text partnerName;
    private Label interfaceLabel;
    private Label operationLabel;
    private Hyperlink interfaceName;
    private Button partnerBrowseButton;
    private Text operationText;
    private Button faultButton;
    private boolean isInvoke;
    private PartnerRoleFilter fPartnerRoleFilter = new PartnerRoleFilter();
    private Label quickPickLabel;
    private Tree quickPickTree;
    private TreeViewer quickPickTreeViewer;
    private Composite faultComposite;
    private Label faultLabel;
    private Text faultText;
    private boolean ignoreQuickPickSelection = false;
    private Label messageOrElementLabel;
    private Text messageOrElementText;
    private IControlContentAdapter fTextContentAdapter = new TextContentAdapter(){

        public void insertControlContents(Control control, String text, int cursorPosition) {
            if (text != null) {
                super.insertControlContents(control, text, cursorPosition);
            }
        }

        public void setControlContents(Control control, String text, int cursorPosition) {
            if (text != null) {
                super.setControlContents(control, text, cursorPosition);
            }
        }
    };
    private Button operationButton;
    private RunnableProposal fWSDLEditRunnableProposal;
    public static final int SPLIT_POINT = 55;
    public static final int SPLIT_POINT_OFFSET = 15;
    private static final PartnerLink IGNORE_PARTNER_LINK = BPELFactory.eINSTANCE.createPartnerLink();
    private static final Operation IGNORE_OPERATION = WSDLFactory.eINSTANCE.createOperation();

    public boolean shouldUseExtraSpace() {
        return true;
    }

    private static List<String> getVariablesNamesInUse(EObject parent) {
        Variable[] variables;
        ArrayList<String> variablesNames = new ArrayList<String>();
        Variable[] variableArray = variables = BPELUtil.getVisibleVariables(parent);
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            Variable var = variableArray[n2];
            variablesNames.add(var.getName());
            ++n2;
        }
        return variablesNames;
    }

    private String plainLabelWordFor(EObject input, int direction) {
        if (this.isInvoke || !(input instanceof Reply)) {
            return direction == 0 || direction == 4 ? Messages.InvokeImplDetails_Request_3_Plain : Messages.InvokeImplDetails_Response_4_Plain;
        }
        return direction == 0 || direction == 4 ? Messages.InvokeImplDetails_Response_4_Plain : Messages.InvokeImplDetails_Request_3_Plain;
    }

    @Override
    protected MultiObjectAdapter[] createAdapters() {
        return new MultiObjectAdapter[]{new MultiObjectAdapter(){

            @Override
            public void notify(Notification n) {
                try {
                    Object input = InvokeImplSection.this.getInput();
                    if (ModelHelper.isPartnerAffected(input, n)) {
                        InvokeImplSection.this.updatePartnerWidgets();
                        InvokeImplSection.this.updatePortTypeWidgets();
                        InvokeImplSection.this.updateOperationWidgets();
                        InvokeImplSection.this.updateMessageOrElementWidgets();
                        InvokeImplSection.this.updateFaultWidgets();
                    } else if (ModelHelper.isOperationAffected(input, n)) {
                        InvokeImplSection.this.updatePortTypeWidgets();
                        InvokeImplSection.this.updateOperationWidgets();
                        InvokeImplSection.this.updateMessageOrElementWidgets();
                        InvokeImplSection.this.updateFaultWidgets();
                    } else {
                        InvokeImplSection.this.updateFaultWidgets();
                    }
                    InvokeImplSection.this.rearrangeWidgets();
                    if (InvokeImplSection.this.replyTypeEnabled() && ModelHelper.isFaultNameAffected(input, n)) {
                        InvokeImplSection.this.updateFaultWidgets();
                    }
                }
                catch (Exception e) {
                    BPELUIPlugin.log(e);
                }
            }
        }};
    }

    protected boolean replyTypeEnabled() {
        return this.getInput() instanceof Reply;
    }

    private void doChildLayout() {
        this.faultComposite.setVisible(this.replyTypeEnabled());
        this.parentComposite.layout(true);
    }

    @Override
    protected void basicSetInput(EObject input) {
        super.basicSetInput(input);
        this.rearrangeWidgets();
        this.updateQuickPickWidgets();
        this.updatePartnerWidgets();
        this.updatePortTypeWidgets();
        this.updateOperationWidgets();
        this.updateMessageOrElementWidgets();
        this.updateFaultWidgets();
    }

    private void rearrangeWidgets() {
        Object input = this.getInput();
        this.isInvoke = input instanceof Invoke;
        this.fPartnerRoleFilter.setRequireMyRole(!this.isInvoke);
        this.fPartnerRoleFilter.setRequirePartnerRole(this.isInvoke);
        this.doChildLayout();
    }

    private Composite createPartnerWidgets(Composite top, Composite parent) {
        Composite composite = this.createFlatFormComposite(parent);
        FlatFormData data = new FlatFormData();
        data.top = top == null ? new FlatFormAttachment(0, 4) : new FlatFormAttachment((Control)top, 4);
        data.left = new FlatFormAttachment(0, 5);
        data.right = new FlatFormAttachment(55, -15);
        composite.setLayoutData((Object)data);
        this.partnerLabel = this.fWidgetFactory.createLabel(composite, Messages.InvokeImplDetails_Partner__10);
        this.partnerName = this.fWidgetFactory.createText(composite, "", 0);
        this.partnerBrowseButton = this.fWidgetFactory.createButton(composite, "", 132100);
        RunnableProposal proposal = new RunnableProposal(){

            @Override
            public String getLabel() {
                return Messages.InvokeImplSection_0;
            }

            @Override
            public void run() {
                InvokeImplSection.this.createPartnerLink((EObject)BPELUtils.getProcess(InvokeImplSection.this.getInput()), null);
            }
        };
        RunnableProposal proposal2 = new RunnableProposal(){

            @Override
            public String getLabel() {
                return Messages.InvokeImplSection_1;
            }

            @Override
            public void run() {
                InvokeImplSection.this.createPartnerLink(ModelHelper.getContainingScope(InvokeImplSection.this.getInput()), null);
            }
        };
        RunnableProposal proposal3 = new RunnableProposal(){

            @Override
            public String getLabel() {
                return Messages.InvokeImplSection_2;
            }

            @Override
            public void run() {
                CompoundCommand cmd = new CompoundCommand();
                cmd.getCommands().addAll(InvokeImplSection.this.basicCommandList(InvokeImplSection.this.getInput(), null, null));
                InvokeImplSection.this.getCommandFramework().execute((Command)cmd);
            }
        };
        PartnerLinkContentProvider provider = new PartnerLinkContentProvider();
        ModelContentProposalProvider proposalProvider = new ModelContentProposalProvider(new ModelContentProposalProvider.ValueProvider(){

            @Override
            public Object value() {
                return InvokeImplSection.this.getInput();
            }
        }, provider, this.fPartnerRoleFilter);
        proposalProvider.addProposalToEnd(new Separator());
        proposalProvider.addProposalToEnd(proposal);
        proposalProvider.addProposalToEnd(proposal2);
        proposalProvider.addProposalToEnd(proposal3);
        proposalProvider.addProposalToEnd(this.getWSDLEdit());
        final FieldAssistAdapter contentAssist = new FieldAssistAdapter((Control)this.partnerName, this.fTextContentAdapter, (IContentProposalProvider)proposalProvider, null, null, true);
        contentAssist.setLabelProvider((ILabelProvider)new ModelLabelProvider());
        contentAssist.setPopupSize(new Point(300, 100));
        contentAssist.setFilterStyle(3);
        contentAssist.setProposalAcceptanceStyle(2);
        contentAssist.addContentProposalListener((IContentProposalListener)proposal);
        contentAssist.addContentProposalListener((IContentProposalListener)proposal2);
        contentAssist.addContentProposalListener((IContentProposalListener)proposal3);
        contentAssist.addContentProposalListener((IContentProposalListener)this.getWSDLEdit());
        contentAssist.addContentProposalListener(new IContentProposalListener(){

            public void proposalAccepted(IContentProposal chosenProposal) {
                if (chosenProposal.getContent() == null) {
                    return;
                }
                PartnerLink pl = null;
                try {
                    pl = (PartnerLink)((Adapter)chosenProposal).getTarget();
                }
                catch (Throwable throwable) {
                    return;
                }
                CompoundCommand cmd = new CompoundCommand();
                cmd.getCommands().addAll(InvokeImplSection.this.basicCommandList(InvokeImplSection.this.getInput(), pl, null));
                InvokeImplSection.this.getCommandFramework().execute((Command)cmd);
            }
        });
        this.partnerBrowseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                contentAssist.openProposals();
            }
        });
        this.partnerName.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 13) {
                    InvokeImplSection.this.findAndSetOrCreatePartnerLink(InvokeImplSection.this.partnerName.getText());
                }
            }
        });
        data = new FlatFormData();
        data.right = new FlatFormAttachment(100, 0);
        data.top = new FlatFormAttachment((Control)this.partnerName, 2, 128);
        data.bottom = new FlatFormAttachment((Control)this.partnerName, -2, 1024);
        this.partnerBrowseButton.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, BPELUtil.calculateLabelWidth((Widget)this.partnerLabel, 105));
        data.right = new FlatFormAttachment((Control)this.partnerBrowseButton, 0);
        this.partnerName.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment((Control)this.partnerName, -5);
        data.top = new FlatFormAttachment((Control)this.partnerName, 0, 0x1000000);
        this.partnerLabel.setLayoutData((Object)data);
        this.partnerBrowseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                contentAssist.openProposals();
            }
        });
        return composite;
    }

    private Composite createPortTypeWidgets(Composite top, Composite parent) {
        return top;
    }

    private Composite createOperationWidgets(Composite top, Composite parent) {
        Composite composite = this.createFlatFormComposite(parent);
        FlatFormData data = new FlatFormData();
        data.top = top == null ? new FlatFormAttachment(0, 4) : new FlatFormAttachment((Control)top, 4);
        data.left = new FlatFormAttachment(0, 5);
        data.right = new FlatFormAttachment(55, -15);
        composite.setLayoutData((Object)data);
        this.operationLabel = this.fWidgetFactory.createLabel(composite, Messages.InvokeImplDetails_Operation__19);
        this.operationText = this.fWidgetFactory.createText(composite, "", 0);
        this.operationButton = this.fWidgetFactory.createButton(composite, "", 0x1000404);
        OperationContentProvider provider = new OperationContentProvider();
        ModelContentProposalProvider proposalProvider = new ModelContentProposalProvider(new ModelContentProposalProvider.ValueProvider(){

            @Override
            public Object value() {
                return InvokeImplSection.this.getInput();
            }
        }, provider);
        proposalProvider.addProposalToEnd(new Separator());
        proposalProvider.addProposalToEnd(this.getWSDLEdit());
        final FieldAssistAdapter contentAssist = new FieldAssistAdapter((Control)this.operationText, this.fTextContentAdapter, (IContentProposalProvider)proposalProvider, null, null, true);
        contentAssist.setLabelProvider((ILabelProvider)new ModelLabelProvider());
        contentAssist.setPopupSize(new Point(300, 100));
        contentAssist.setFilterStyle(3);
        contentAssist.setProposalAcceptanceStyle(2);
        contentAssist.addContentProposalListener((IContentProposalListener)this.getWSDLEdit());
        contentAssist.addContentProposalListener(new IContentProposalListener(){

            public void proposalAccepted(IContentProposal chosenProposal) {
                if (chosenProposal.getContent() == null) {
                    return;
                }
                Operation oper = null;
                try {
                    oper = (Operation)((Adapter)chosenProposal).getTarget();
                }
                catch (Throwable throwable) {
                    return;
                }
                List list = InvokeImplSection.this.basicCommandList(InvokeImplSection.this.getInput(), IGNORE_PARTNER_LINK, oper);
                CompoundCommand cmd = new CompoundCommand();
                cmd.getCommands().addAll(list);
                InvokeImplSection.this.getCommandFramework().execute((Command)cmd);
            }
        });
        this.operationButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                contentAssist.openProposals();
            }
        });
        this.operationText.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 13) {
                    InvokeImplSection.this.findAndSetOperation(InvokeImplSection.this.operationText.getText());
                }
            }
        });
        data = new FlatFormData();
        data.right = new FlatFormAttachment(100, 0);
        data.top = new FlatFormAttachment((Control)this.operationText, 2, 128);
        data.bottom = new FlatFormAttachment((Control)this.operationText, -2, 1024);
        this.operationButton.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, BPELUtil.calculateLabelWidth((Widget)this.operationLabel, 105));
        data.right = new FlatFormAttachment((Control)this.operationButton, 0);
        this.operationText.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment((Control)this.operationText, -5);
        data.top = new FlatFormAttachment((Control)this.operationText, 0, 0x1000000);
        this.operationLabel.setLayoutData((Object)data);
        return composite;
    }

    private Composite createMessageOrElementWidgets(Composite top, Composite parent) {
        Composite composite = this.createFlatFormComposite(parent);
        FlatFormData data = new FlatFormData();
        data.top = top == null ? new FlatFormAttachment(0, 4) : new FlatFormAttachment((Control)top, 4);
        data.left = new FlatFormAttachment(0, 5);
        data.right = new FlatFormAttachment(55, -15);
        composite.setLayoutData((Object)data);
        this.messageOrElementLabel = this.fWidgetFactory.createLabel(composite, Messages.InvokeImplDetails_MessageTypeOrElement);
        this.messageOrElementText = this.fWidgetFactory.createText(composite, "", 0);
        this.messageOrElementText.setEditable(false);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, BPELUtil.calculateLabelWidth((Widget)this.messageOrElementLabel, 105));
        data.right = new FlatFormAttachment((Control)this.operationButton, 0);
        this.messageOrElementText.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment((Control)this.messageOrElementText, -5);
        data.top = new FlatFormAttachment((Control)this.messageOrElementText, 0, 0x1000000);
        this.messageOrElementLabel.setLayoutData((Object)data);
        return composite;
    }

    private Composite createFaultComposite(Composite top, Composite parent) {
        Composite composite = this.faultComposite = this.createFlatFormComposite(parent);
        FlatFormData data = new FlatFormData();
        data.top = top == null ? new FlatFormAttachment(0, 4) : new FlatFormAttachment((Control)top, 4);
        data.left = new FlatFormAttachment(0, 5);
        data.right = new FlatFormAttachment(55, -15);
        composite.setLayoutData((Object)data);
        this.faultLabel = this.fWidgetFactory.createLabel(composite, Messages.InvokeImplDetails_Fault_Name__25);
        this.faultText = this.fWidgetFactory.createText(composite, "");
        this.faultButton = this.fWidgetFactory.createButton(composite, "", 0x1000404);
        WSDLFaultContentProvider provider = new WSDLFaultContentProvider();
        ModelContentProposalProvider proposalProvider = new ModelContentProposalProvider(new ModelContentProposalProvider.ValueProvider(){

            @Override
            public Object value() {
                return ModelHelper.getOperation(InvokeImplSection.this.getInput());
            }
        }, provider);
        RunnableProposal proposalClearFault = new RunnableProposal(){

            @Override
            public String getLabel() {
                return Messages.InvokeImplSection_25;
            }

            @Override
            public void run() {
                CompoundCommand cmd = new CompoundCommand();
                cmd.add((Command)new SetWSDLFaultCommand(InvokeImplSection.this.getInput(), null));
                InvokeImplSection.this.getCommandFramework().execute((Command)cmd);
            }
        };
        proposalProvider.addProposalToEnd(new Separator());
        proposalProvider.addProposalToEnd(proposalClearFault);
        final FieldAssistAdapter contentAssist = new FieldAssistAdapter((Control)this.faultText, this.fTextContentAdapter, (IContentProposalProvider)proposalProvider, null, null, true);
        contentAssist.setLabelProvider((ILabelProvider)new ModelLabelProvider());
        contentAssist.setPopupSize(new Point(300, 100));
        contentAssist.setFilterStyle(3);
        contentAssist.setProposalAcceptanceStyle(2);
        contentAssist.addContentProposalListener(new IContentProposalListener(){

            public void proposalAccepted(IContentProposal chosenProposal) {
                if (chosenProposal.getContent() == null) {
                    return;
                }
                Fault fault = null;
                try {
                    fault = (Fault)((Adapter)chosenProposal).getTarget();
                }
                catch (Throwable throwable) {
                    return;
                }
                CompoundCommand cmd = new CompoundCommand();
                cmd.add((Command)new SetWSDLFaultCommand(InvokeImplSection.this.getInput(), fault));
                InvokeImplSection.this.getCommandFramework().execute((Command)cmd);
            }
        });
        contentAssist.addContentProposalListener((IContentProposalListener)proposalClearFault);
        this.faultButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                contentAssist.openProposals();
            }
        });
        data = new FlatFormData();
        data.right = new FlatFormAttachment(100, 0);
        data.top = new FlatFormAttachment((Control)this.faultText, 2, 128);
        data.bottom = new FlatFormAttachment((Control)this.faultText, -2, 1024);
        this.faultButton.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, BPELUtil.calculateLabelWidth((Widget)this.operationLabel, 105));
        data.right = new FlatFormAttachment((Control)this.faultButton, 0);
        this.faultText.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment((Control)this.faultText, -5);
        data.top = new FlatFormAttachment((Control)this.faultText, 0, 0x1000000);
        this.faultLabel.setLayoutData((Object)data);
        return composite;
    }

    private Composite createQuickPick(Composite top, Composite parent) {
        Composite composite = this.createFlatFormComposite(parent);
        FlatFormData data = new FlatFormData();
        data.top = top == null ? new FlatFormAttachment(0, 4) : new FlatFormAttachment((Control)top, 4);
        data.left = new FlatFormAttachment(55, 15);
        data.right = new FlatFormAttachment(100, -5);
        data.bottom = new FlatFormAttachment(100, -4);
        composite.setLayoutData((Object)data);
        this.quickPickLabel = this.fWidgetFactory.createLabel(composite, "Quick Pick:");
        this.quickPickTree = this.fWidgetFactory.createTree(composite, 0);
        PartnerLinkTreeContentProvider treeContentProvider = new PartnerLinkTreeContentProvider(true);
        this.quickPickTreeViewer = new TreeViewer(this.quickPickTree);
        this.quickPickTreeViewer.setContentProvider((IContentProvider)treeContentProvider);
        this.quickPickTreeViewer.setLabelProvider((IBaseLabelProvider)new ModelTreeLabelProvider());
        this.quickPickTreeViewer.addFilter((ViewerFilter)this.fPartnerRoleFilter);
        this.quickPickTreeViewer.setInput(null);
        this.quickPickTreeViewer.setAutoExpandLevel(5);
        data = new FlatFormData();
        data.top = new FlatFormAttachment(0, 0);
        data.left = new FlatFormAttachment(0, 0);
        this.quickPickLabel.setLayoutData((Object)data);
        data = new FlatFormData();
        data.top = new FlatFormAttachment((Control)this.quickPickLabel, 4);
        data.left = new FlatFormAttachment(0, 5);
        data.right = new FlatFormAttachment(100, -5);
        data.bottom = new FlatFormAttachment(100, -5);
        this.quickPickTree.setLayoutData((Object)data);
        this.quickPickTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (InvokeImplSection.this.ignoreQuickPickSelection) {
                    InvokeImplSection.this.ignoreQuickPickSelection = false;
                } else {
                    InvokeImplSection.this.quickPickSelectionChanged(event.getSelection());
                }
            }
        });
        return composite;
    }

    @Override
    protected void createClient(Composite parent) {
        Composite composite = this.parentComposite = this.createFlatFormComposite(parent);
        Composite ref = this.createPartnerWidgets(null, composite);
        ref = this.createPortTypeWidgets(ref, composite);
        ref = this.createOperationWidgets(ref, composite);
        ref = this.createMessageOrElementWidgets(ref, composite);
        ref = this.createFaultComposite(ref, composite);
        ref = this.createQuickPick(null, composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.parentComposite, "org.eclipse.bpel.ui.property_invoke");
    }

    private void updatePartnerWidgets() {
        PartnerLink partnerLink = ModelHelper.getPartnerLink(this.getInput());
        if (partnerLink == null) {
            this.partnerName.setText("");
        } else {
            ILabeledElement labeledElement = BPELUtil.adapt((Object)partnerLink, ILabeledElement.class);
            this.partnerName.setText(labeledElement.getLabel(partnerLink));
            this.updateQuickPickSelection(partnerLink);
        }
    }

    private PortType getEffectivePortType(PartnerLink partnerLink) {
        if (partnerLink != null) {
            Role role = this.isInvoke ? partnerLink.getPartnerRole() : partnerLink.getMyRole();
            return ModelHelper.getRolePortType(role);
        }
        return null;
    }

    private void updateQuickPickWidgets() {
        this.fPartnerRoleFilter.setRequireMyRole(!this.isInvoke);
        this.fPartnerRoleFilter.setRequirePartnerRole(this.isInvoke);
        Object myInput = this.getInput();
        if (myInput != this.quickPickTreeViewer.getInput()) {
            this.quickPickTreeViewer.setInput(myInput);
            if (myInput != null) {
                this.quickPickTree.getVerticalBar().setSelection(0);
            }
        }
    }

    private void updateQuickPickSelection(Object model) {
        this.ignoreQuickPickSelection = true;
        TreeItem[] items = this.quickPickTree.getItems();
        int i = 0;
        while (i < items.length) {
            if (this.updateQuickPickSelection(model, items[i])) break;
            ++i;
        }
    }

    private boolean updateQuickPickSelection(Object model, TreeItem item) {
        Object data = item.getData();
        if (data instanceof TreeNode) {
            Object obj = ((TreeNode)data).getModelObject();
            if (obj instanceof PartnerLink) {
                PartnerLink partnerLink = ModelHelper.getPartnerLink(this.getInput());
                if (obj != partnerLink) {
                    return false;
                }
            } else if (obj instanceof Input) {
                obj = ModelHelper.getMessageType(obj);
            } else if (obj instanceof Part) {
                obj = ModelHelper.getVariableTypeFrom(obj);
            }
            if (model == obj) {
                this.quickPickTree.setSelection(item);
                return true;
            }
            TreeItem[] items = item.getItems();
            int i = 0;
            while (i < items.length) {
                if (this.updateQuickPickSelection(model, items[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void updatePortTypeWidgets() {
        if (this.interfaceName == null) {
            return;
        }
        PartnerLink partnerLink = ModelHelper.getPartnerLink(this.getInput());
        PortType portType = this.getEffectivePortType(partnerLink);
        if (portType == null) {
            this.interfaceName.setText(Messages.InvokeImplSection_None_1);
            this.interfaceName.setEnabled(false);
        } else {
            ILabeledElement labeledElement = BPELUtil.adapt((Object)portType, ILabeledElement.class);
            this.interfaceName.setText(labeledElement.getLabel(portType));
            this.interfaceName.setEnabled(true);
        }
    }

    private void updateOperationWidgets() {
        Operation operation = ModelHelper.getOperation(this.getInput());
        if (operation != null) {
            this.operationText.setText(operation.getName());
            this.updateQuickPickSelection(operation);
        } else {
            this.operationText.setText("");
        }
        if (this.getInput() instanceof OnEvent) {
            OnEvent onEvent = (OnEvent)this.getInput();
            Message message = onEvent.getMessageType();
            if (message != null) {
                this.updateQuickPickSelection(message);
            } else {
                XSDElementDeclaration element = onEvent.getXSDElement();
                if (element != null) {
                    this.updateQuickPickSelection(element);
                }
            }
        }
    }

    private void updateMessageOrElementWidgets() {
        boolean visible = this.getInput() instanceof OnEvent;
        if (visible) {
            OnEvent onEvent = (OnEvent)this.getInput();
            String text = "";
            String label = Messages.InvokeImplDetails_MessageTypeOrElement;
            if (onEvent.getVariable() != null) {
                Message message = onEvent.getMessageType();
                if (message != null) {
                    text = message.getQName().getLocalPart();
                    label = Messages.InvokeImplDetails_MessageType;
                } else {
                    XSDElementDeclaration element = onEvent.getXSDElement();
                    if (element != null) {
                        text = element.getName();
                        label = Messages.InvokeImplDetails_Element;
                    }
                }
            }
            this.messageOrElementText.setText(text);
            this.messageOrElementLabel.setText(label);
        }
        this.messageOrElementLabel.setVisible(visible);
        this.messageOrElementText.setVisible(visible);
    }

    protected boolean replyFaultEnabled() {
        if (this.isInvoke) {
            return false;
        }
        if (!(this.getInput() instanceof Reply)) {
            return false;
        }
        boolean faultEnabled = ModelHelper.getFaultName(this.getInput()) != null;
        return faultEnabled;
    }

    protected void updateFaultWidgets() {
        boolean faultEnabled = this.replyFaultEnabled();
        if (faultEnabled) {
            Fault fault = ModelHelper.getWSDLFault(this.getInput());
            if (fault != null) {
                this.faultText.setText(fault.getName());
            } else {
                this.faultText.setText("");
            }
        } else {
            this.faultText.setText("");
        }
    }

    @Override
    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.doChildLayout();
    }

    @Override
    public Object getUserContext() {
        return this.lastChangeContext;
    }

    @Override
    public void restoreUserContext(Object userContext) {
        int i = (Integer)userContext;
        switch (i) {
            case 0: {
                this.partnerName.setFocus();
                return;
            }
            case 1: {
                this.operationText.setFocus();
                return;
            }
            case 4: {
                this.faultText.setFocus();
                return;
            }
        }
        throw new IllegalStateException();
    }

    private void findAndSetOperation(String text) {
        AutoUndoCommand cmd;
        text = text.trim();
        Object model = this.getInput();
        PortType portType = ModelHelper.getPortType(model);
        List<Command> cmdList = this.basicCommandList((EObject)model, IGNORE_PARTNER_LINK, null);
        Operation op = null;
        if (text.length() > 0 && (op = (Operation)ModelHelper.findElementByName((EObject)portType, text, Operation.class)) != null) {
            cmd = (SetOperationCommand)((Object)ListMap.Find(cmdList, new ListMap.Visitor(){

                @Override
                public Object visit(Object obj) {
                    return obj instanceof SetOperationCommand ? obj : ListMap.IGNORE;
                }
            }));
            ((SetCommand)cmd).setNewValue((EObject)op);
            int i = 0;
            while (i < cmdList.size()) {
                if (cmdList.get(i) instanceof SetOperationCommand) {
                    cmdList.set(i, (Command)cmd);
                    break;
                }
                ++i;
            }
        }
        cmd = new CompoundCommand();
        ((CompoundCommand)cmd).getCommands().addAll(cmdList);
        this.getCommandFramework().execute((Command)cmd);
        if (op != null) {
            this.updateQuickPickSelection(op);
        }
    }

    void findAndSetOrCreatePartnerLink(String name) {
        name = name.trim();
        Object model = this.getInput();
        PartnerLink pl = null;
        if (name.length() > 0 && (pl = (PartnerLink)ModelHelper.findElementByName(ModelHelper.getContainingScope(model), name, PartnerLink.class)) == null) {
            pl = this.createPartnerLink(ModelHelper.getContainingScope(model), name);
            if (pl != null) {
                this.updateQuickPickSelection(pl);
            }
            return;
        }
        CompoundCommand cmd = new CompoundCommand();
        cmd.getCommands().addAll(this.basicCommandList((EObject)model, pl, null));
        this.getCommandFramework().execute((Command)cmd);
        if (pl != null) {
            this.updateQuickPickSelection(pl);
        }
    }

    private PartnerLink createPartnerLink(EObject ref, String name) {
        EList list;
        NameDialog nameDialog;
        PartnerLink pl = BPELFactory.eINSTANCE.createPartnerLink();
        if (name == null) {
            name = "";
        }
        if ((nameDialog = new NameDialog(this.parentComposite.getShell(), Messages.PartnerLinkSelectorDialog_5, Messages.PartnerLinkSelectorDialog_6, name, BPELUtil.getNCNameValidator())).open() == 1) {
            return null;
        }
        PartnerLinkTypeSelectorDialog dialog = new PartnerLinkTypeSelectorDialog(this.partnerName.getShell(), (EObject)this.getInput());
        if (dialog.open() == 1) {
            return null;
        }
        Object result = dialog.getFirstResult();
        PartnerLinkType plt = null;
        if (result != null && result instanceof PartnerLinkType) {
            plt = (PartnerLinkType)result;
        }
        if ((list = plt.getRole()).size() > 1) {
            PartnerLinkRoleSelectorDialog roleDialog = new PartnerLinkRoleSelectorDialog(this.parentComposite.getShell(), (EList<Role>)list, plt);
            if (this.isInvoke) {
                roleDialog.setTitle(Messages.PartnerRoleSelectorDialog_Title_PartnerRole);
            } else {
                roleDialog.setTitle(Messages.PartnerRoleSelectorDialog_Title_MyRole);
            }
            if (roleDialog.open() == 1) {
                return null;
            }
            if (this.isInvoke) {
                pl.setPartnerRole((Role)list.get(roleDialog.getSelectedRole()));
            } else {
                pl.setMyRole((Role)list.get(roleDialog.getSelectedRole()));
            }
        } else if (this.isInvoke) {
            pl.setPartnerRole((Role)list.get(0));
        } else {
            pl.setMyRole((Role)list.get(0));
        }
        pl.setName(nameDialog.getValue());
        pl.setPartnerLinkType(plt);
        List<Command> cmds = this.basicCommandList((EObject)this.getInput(), pl, null);
        cmds.add(0, (Command)new AddPartnerLinkCommand(ref, pl));
        CompoundCommand cmd = new CompoundCommand();
        cmd.getCommands().addAll(cmds);
        this.getCommandFramework().execute((Command)cmd);
        this.quickPickTreeViewer.setInput(null);
        this.updateQuickPickWidgets();
        return pl;
    }

    private void quickPickSelectionChanged(ISelection selection) {
        if (selection.isEmpty()) {
            return;
        }
        ITreeSelection treeSelection = (ITreeSelection)selection;
        this.quickPickSelectionChanged(treeSelection.getPaths());
    }

    private void quickPickSelectionChanged(TreePath[] paths) {
        if (paths.length > 0) {
            this.quickPickSelectionChanged(paths[0]);
        }
    }

    private void quickPickSelectionChanged(TreePath path) {
        if (this.ignoreQuickPickSelection) {
            return;
        }
        Object input = this.getInput();
        List<Command> cmdList = this.basicCommandList((EObject)input, null, null);
        PartnerLink pl = null;
        Operation op = null;
        Part part = null;
        SetCommand setCommand = null;
        int i = 0;
        int j = path.getSegmentCount();
        while (i < j) {
            Object model = null;
            try {
                model = ((ITreeNode)path.getSegment(i)).getModelObject();
            }
            catch (Exception ex) {
                BPELUIPlugin.log(ex);
                break;
            }
            if (model instanceof PartnerLink) {
                pl = (PartnerLink)model;
                setCommand = (SetCommand)((Object)ListMap.Find(cmdList, new ListMap.Visitor(){

                    @Override
                    public Object visit(Object obj) {
                        return obj instanceof SetPartnerLinkCommand ? obj : ListMap.IGNORE;
                    }
                }));
                setCommand.setNewValue((EObject)pl);
            } else if (!(model instanceof PortType)) {
                if (model instanceof Operation) {
                    op = (Operation)model;
                    setCommand = (SetCommand)((Object)ListMap.Find(cmdList, new ListMap.Visitor(){

                        @Override
                        public Object visit(Object obj) {
                            return obj instanceof SetOperationCommand ? obj : ListMap.IGNORE;
                        }
                    }));
                    setCommand.setNewValue((EObject)op);
                    this.alterCommands(cmdList, (EObject)input, pl, op, (Input)op.getInput());
                    this.alterCommands(cmdList, (EObject)input, pl, op, (Output)op.getOutput());
                } else if (model instanceof Part) {
                    part = (Part)model;
                    setCommand = (SetCommand)((Object)ListMap.Find(cmdList, new ListMap.Visitor(){

                        @Override
                        public Object visit(Object obj) {
                            return obj instanceof SetOnEventVariableTypeCommand ? obj : ListMap.IGNORE;
                        }
                    }));
                    if (setCommand != null) {
                        setCommand.setNewValue((EObject)part.getElementDeclaration());
                    }
                }
            }
            ++i;
        }
        CompoundCommand cmd = new CompoundCommand();
        cmd.getCommands().addAll(cmdList);
        this.getCommandFramework().execute((Command)cmd);
    }

    private void alterCommands(List<Command> list, EObject input, PartnerLink pl, Operation op, Input msg) {
        if (input instanceof Receive || input instanceof OnMessage || input instanceof OnEvent) {
            if (pl.getMyRole() == null || msg == null) {
                return;
            }
            this.alterCommands(list, input, msg.getEMessage(), pl);
        }
        if (input instanceof Invoke) {
            if (pl.getPartnerRole() == null || msg == null) {
                return;
            }
            this.alterCommands(list, input, msg.getEMessage(), pl);
        }
    }

    private void alterCommands(List<Command> cmds, EObject input, PartnerLink pl, Operation op, Output msg) {
        if (input instanceof Reply) {
            if (pl.getMyRole() == null || msg == null) {
                return;
            }
            this.alterCommands(cmds, input, msg.getEMessage(), pl);
        }
        if (input instanceof Invoke) {
            if (pl.getPartnerRole() == null || msg == null) {
                return;
            }
            this.alterCommands(cmds, input, msg.getEMessage(), pl, 1);
        }
    }

    private void alterCommands(List<Command> cmds, EObject input, Message msg, PartnerLink pl) {
        this.alterCommands(cmds, input, msg, pl, 4);
    }

    private void alterCommands(List<Command> cmds, EObject input, Message msg, PartnerLink pl, final int direction) {
        Variable variable = this.findVariable(input, msg, pl);
        if (variable == null) {
            variable = BPELFactory.eINSTANCE.createVariable();
            String name = String.valueOf(pl.getName()) + this.plainLabelWordFor(input, direction);
            List<String> variablesNamesInUse = InvokeImplSection.getVariablesNamesInUse(input);
            if (variablesNamesInUse.contains(name)) {
                int index = 1;
                while (variablesNamesInUse.contains(String.valueOf(name) + index)) {
                    ++index;
                }
                name = String.valueOf(name) + index;
            }
            variable.setName(name);
            variable.setMessageType(msg);
            if (!(input instanceof OnEvent)) {
                cmds.add(0, (Command)new AddVariableCommand(input, variable));
            }
        }
        SetVariableCommand cmd = (SetVariableCommand)((Object)ListMap.Find(cmds, new ListMap.Visitor(){

            @Override
            public Object visit(Object obj) {
                SetVariableCommand svc;
                if (obj instanceof SetVariableCommand && (svc = (SetVariableCommand)((Object)obj)).getDirection() == direction) {
                    return svc;
                }
                return ListMap.IGNORE;
            }
        }));
        cmd.setNewValue((EObject)variable);
    }

    private Variable findVariable(EObject input, Message msg, PartnerLink pl) {
        Variable[] list = null;
        if (input instanceof OnEvent) {
            OnEvent oe = (OnEvent)input;
            list = new Variable[]{oe.getVariable()};
        } else {
            list = ModelHelper.getVariablesOfType(input, msg);
        }
        if (list.length == 1) {
            return list[0];
        }
        if (list.length > 0) {
            if (pl == null) {
                return list[0];
            }
            String plName = pl.getName();
            int i = 0;
            while (i < list.length) {
                if (list[i].getName().indexOf(plName) >= 0) {
                    return list[i];
                }
                ++i;
            }
            return list[0];
        }
        return null;
    }

    private List<Command> basicCommandList(EObject input, PartnerLink pl, Operation op) {
        ArrayList<Command> list = new ArrayList<Command>(8);
        if (pl != IGNORE_PARTNER_LINK) {
            list.add((Command)new SetPartnerLinkCommand(input, pl));
        }
        if (op != IGNORE_OPERATION) {
            list.add((Command)new SetOperationCommand(input, op));
        }
        list.add((Command)new SetVariableCommand(input, null));
        if (input instanceof OnEvent) {
            list.add((Command)new SetOnEventVariableTypeCommand((OnEvent)input));
        } else if (input instanceof Reply) {
            list.add((Command)new SetWSDLFaultCommand((Object)input, null));
        } else if (input instanceof Invoke) {
            list.add((Command)new SetVariableCommand(input, null, 1));
        }
        return list;
    }

    private RunnableProposal getWSDLEdit() {
        if (this.fWSDLEditRunnableProposal == null) {
            this.fWSDLEditRunnableProposal = new RunnableProposal(){

                @Override
                public String getLabel() {
                    return Messages.InvokeImplSection_24;
                }

                @Override
                public void run() {
                    PortType pt = ModelHelper.getPortType(InvokeImplSection.this.getInput());
                    if (pt != null) {
                        BPELUtil.openEditor((EObject)pt, InvokeImplSection.this.getBPELEditor());
                    }
                }
            };
        }
        return this.fWSDLEditRunnableProposal;
    }
}

