/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import org.eclipse.bpel.common.ui.command.ICommandFramework;
import org.eclipse.bpel.common.ui.details.IOngoingChange;
import org.eclipse.bpel.common.ui.details.IValue;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.commands.util.UpdateModelCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class EditController
implements IOngoingChange,
Listener,
Adapter {
    ICommandFramework fCommandFramework;
    boolean fbViewUpdate = false;
    EObject fInput;
    EStructuralFeature fFeature;
    String fLabel;
    IValue fViewValue;
    IValue fModelValue;

    public EditController(ICommandFramework commandFramework) {
        this.fCommandFramework = commandFramework;
    }

    public void setInput(EObject target) {
        if (this.fInput != null) {
            this.fInput.eAdapters().remove((Object)this);
        }
        this.fInput = target;
        if (this.fInput != null) {
            this.fInput.eAdapters().add((Object)this);
        }
    }

    public EObject getInput() {
        return this.fInput;
    }

    public void setFeature(EStructuralFeature feature) {
        if (this.fFeature == feature) {
            return;
        }
        this.fFeature = feature;
        this.fModelValue = new IValue(){

            public Object get() {
                return EditController.this.fInput.eGet(EditController.this.fFeature);
            }

            public void set(Object object) {
                EditController.this.fInput.eSet(EditController.this.fFeature, object);
            }
        };
    }

    public void setModeIValue(IValue value) {
        this.fModelValue = value;
    }

    public IValue getModelIValue() {
        return this.fModelValue;
    }

    public void setViewIValue(IValue value) {
        this.fViewValue = value;
    }

    public IValue getViewIValue() {
        return this.fViewValue;
    }

    public void setLabel(String label) {
        this.fLabel = label;
    }

    public void handleEvent(Event event) {
        if (this.fbViewUpdate) {
            return;
        }
        switch (event.type) {
            case 1: {
                if (event.character != '\r') break;
                this.finish();
                break;
            }
            case 16: {
                this.finish();
                break;
            }
            case 13: 
            case 14: 
            case 24: {
                this.modify();
                break;
            }
            case 12: {
                this.abort();
                this.setInput(null);
            }
        }
    }

    void finish() {
        this.fCommandFramework.notifyChangeDone((IOngoingChange)this);
    }

    void modify() {
        this.fCommandFramework.notifyChangeInProgress((IOngoingChange)this);
    }

    void abort() {
        this.fCommandFramework.abortCurrentChange();
    }

    protected boolean isModifyBasedControl(Control c) {
        if (c instanceof CCombo) {
            return (c.getStyle() & 8) == 0;
        }
        return c instanceof Text;
    }

    protected boolean isSelectionBasedControl(Control c) {
        return !(c instanceof Text);
    }

    void registerListener(Control control, int eventType) {
        control.addListener(eventType, (Listener)this);
    }

    public void startListeningTo(Control ... controls) {
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            this.registerListener(control, 16);
            this.registerListener(control, 12);
            if (this.isModifyBasedControl(control)) {
                this.registerListener(control, 24);
            }
            if (this.isSelectionBasedControl(control)) {
                this.registerListener(control, 13);
                this.registerListener(control, 14);
            }
            ++n2;
        }
    }

    public void startListeningForEnter(Control ... controls) {
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            this.registerListener(control, 1);
            ++n2;
        }
    }

    public void stopListeningTo(Control ... controls) {
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.removeListener(16, (Listener)this);
            if (this.isModifyBasedControl(control)) {
                control.removeListener(24, (Listener)this);
            }
            if (this.isSelectionBasedControl(control)) {
                control.removeListener(13, (Listener)this);
                control.removeListener(14, (Listener)this);
            }
            control.removeListener(1, (Listener)this);
            ++n2;
        }
    }

    public Command createApplyCommand() {
        return new UpdateModelCommand(this.fInput, this.getLabel()){

            @Override
            public void doExecute() {
                EditController.this.fModelValue.set(EditController.this.fViewValue.get());
            }
        };
    }

    public String getLabel() {
        if (this.fLabel != null) {
            return NLS.bind((String)Messages.SetCommand_Change_2, (Object)this.fLabel);
        }
        if (this.fFeature != null) {
            return NLS.bind((String)Messages.SetCommand_Change_2, (Object)this.fFeature.getName());
        }
        return NLS.bind((String)Messages.SetCommand_Change_2, (Object)"...");
    }

    public void restoreOldState() {
    }

    public Notifier getTarget() {
        return this.fInput;
    }

    public boolean isAdapterForType(Object type) {
        Class clazz = null;
        if (type instanceof Class) {
            clazz = (Class)type;
            return clazz.isInstance(this);
        }
        return false;
    }

    public void notifyChanged(Notification notification) {
        if (notification.getEventType() == 1 || notification.getEventType() == 2) {
            if (notification.getFeature() == this.fFeature || this.checkNotification(notification)) {
                this.updateView(this.fModelValue.get());
            }
        } else if (notification.getEventType() == 8 && notification.getOldValue() == this) {
            this.updateView(null);
        }
    }

    public boolean checkNotification(Notification notification) {
        return false;
    }

    void updateView(Object value) {
        this.fbViewUpdate = true;
        try {
            this.fViewValue.set(value);
        }
        finally {
            this.fbViewUpdate = false;
        }
    }

    public void setTarget(Notifier newTarget) {
        if (newTarget == null) {
            this.updateView(null);
        } else {
            this.updateView(this.fModelValue.get());
        }
    }
}

