/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editparts.borders;

import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.editparts.borders.GradientBorder;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class LeafBorder
extends GradientBorder {
    private static final int leftMargin = 6;
    private static final int rightMargin = 13;
    private static final int topMargin = 4;
    private static final int bottomMargin = 3;
    private static final int borderWidth = 1;
    private static final int yHandlerIconOffset = 5;
    private int faultImageWidth;
    private int faultImageHeight;
    private int compensationImageWidth;
    private int compensationImageHeight;
    private int eventImageWidth;
    private int eventImageHeight;
    private Image compensationImage;
    private Image faultImage;
    private Image eventImage;
    private boolean showFault;
    private boolean showCompensation;
    private boolean showEvent;
    private org.eclipse.draw2d.geometry.Rectangle rectFault;
    private org.eclipse.draw2d.geometry.Rectangle rectCompensation;
    private org.eclipse.draw2d.geometry.Rectangle rectEvent;
    private org.eclipse.draw2d.geometry.Rectangle bounds;
    private IFigure parentFigure;
    private org.eclipse.draw2d.geometry.Rectangle rectBounds;
    private IFigure faultImageFigure;
    private IFigure compensationImageFigure;
    private IFigure eventImageFigure;

    public LeafBorder(IFigure parentFigure) {
        super(false, 7);
        this.parentFigure = parentFigure;
        this.faultImage = BPELUIPlugin.INSTANCE.getImage("ovr16/faulthandler.gif");
        Rectangle r = this.faultImage.getBounds();
        this.faultImageWidth = r.width;
        this.faultImageHeight = r.height;
        this.compensationImage = BPELUIPlugin.INSTANCE.getImage("ovr16/compensationhandler.gif");
        r = this.compensationImage.getBounds();
        this.compensationImageWidth = r.width;
        this.compensationImageHeight = r.height;
        this.eventImage = BPELUIPlugin.INSTANCE.getImage("ovr16/eventhandler.gif");
        r = this.eventImage.getBounds();
        this.eventImageWidth = r.width;
        this.eventImageHeight = r.height;
        this.faultImageFigure = new ImageFigure(this.faultImage);
        this.faultImageFigure.setParent(parentFigure);
        this.compensationImageFigure = new ImageFigure(this.compensationImage);
        this.compensationImageFigure.setParent(parentFigure);
        this.eventImageFigure = new ImageFigure(this.eventImage);
        this.eventImageFigure.setParent(parentFigure);
    }

    @Override
    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        Image bottomImage;
        Image topImage;
        this.bounds = figure.getBounds();
        ColorRegistry registry = BPELUIPlugin.INSTANCE.getColorRegistry();
        graphics.setForegroundColor(registry.get("activityBorder"));
        int arcSize = 7;
        org.eclipse.draw2d.geometry.Rectangle oldClip = new org.eclipse.draw2d.geometry.Rectangle();
        oldClip = graphics.getClip(oldClip);
        IMarker topMarker = this.getTopMarker();
        IMarker bottomMarker = this.getBottomMarker();
        if (topMarker != null || bottomMarker != null) {
            org.eclipse.draw2d.geometry.Rectangle clippingRect = bottomMarker == null ? new org.eclipse.draw2d.geometry.Rectangle(this.bounds.x, this.bounds.y, 16, 13) : (topMarker == null ? new org.eclipse.draw2d.geometry.Rectangle(this.bounds.x, this.bounds.y + 12, 16, 13) : new org.eclipse.draw2d.geometry.Rectangle(this.bounds.x, this.bounds.y, 16, 26));
            graphics.setClip(clippingRect);
            graphics.drawRoundRectangle(new org.eclipse.draw2d.geometry.Rectangle(this.bounds.x + 30, this.bounds.y, 32, 24), 7, 7);
            graphics.setClip(oldClip);
            if (bottomMarker == null || topMarker == null) {
                graphics.drawLine(this.bounds.x + 30, this.bounds.y + 12, this.bounds.x + 16, this.bounds.y + 12);
            }
        }
        if ((topImage = this.getTopImage()) != null) {
            int x = this.bounds.x + 30;
            int y = this.bounds.y + 30;
            graphics.drawImage(topImage, x, y);
        }
        if ((bottomImage = this.getBottomImage()) != null) {
            int x = this.bounds.x + 30;
            int y = this.bounds.y + 30 + 12;
            graphics.drawImage(bottomImage, x, y);
        }
        boolean needSquareCorners = topImage != null || bottomImage != null;
        this.rectBounds = new org.eclipse.draw2d.geometry.Rectangle();
        this.rectBounds.x = this.bounds.x + 16;
        this.rectBounds.y = this.bounds.y;
        this.rectBounds.width = this.bounds.width - 32;
        this.rectBounds.height = this.bounds.height - 1;
        if (needSquareCorners) {
            org.eclipse.draw2d.geometry.Rectangle clippingRect = new org.eclipse.draw2d.geometry.Rectangle(this.rectBounds.x + this.rectBounds.width / 2, this.rectBounds.y, this.rectBounds.width / 2 + 2, this.rectBounds.height + 1);
            graphics.setClip(clippingRect);
            graphics.drawRoundRectangle(this.rectBounds, arcSize, arcSize);
            clippingRect = new org.eclipse.draw2d.geometry.Rectangle(this.rectBounds.x, this.rectBounds.y, this.rectBounds.width / 2 + 1, this.rectBounds.height + 1);
            graphics.setClip(clippingRect);
            graphics.drawRectangle(this.rectBounds);
            graphics.setClip(oldClip);
        } else {
            graphics.drawRoundRectangle(this.rectBounds, arcSize, arcSize);
        }
        this.computeHandlerIconPositions(ModelHelper.isHorizontalLayout(this.getEditPart().getModel()));
        if (this.showFault) {
            graphics.setClip(this.faultImageFigure.getBounds().getCopy());
            this.faultImageFigure.paint(graphics);
            graphics.setClip(oldClip);
        }
        if (this.showCompensation) {
            graphics.setClip(this.compensationImageFigure.getBounds().getCopy());
            this.compensationImageFigure.paint(graphics);
            graphics.setClip(oldClip);
        }
        if (this.showEvent) {
            graphics.setClip(this.eventImageFigure.getBounds().getCopy());
            this.eventImageFigure.paint(graphics);
            graphics.setClip(oldClip);
        }
    }

    @Override
    public Insets getInsets(IFigure figure) {
        return new Insets(5, 23, 4, 30);
    }

    public void setFaultImage(Image faultImage) {
        this.faultImage = faultImage;
        Rectangle r = faultImage.getBounds();
        this.faultImageWidth = r.width;
        this.faultImageHeight = r.height;
    }

    public boolean isPointInFaultImage(int x, int y) {
        if (this.showFault) {
            Point p = new Point(x, y);
            this.parentFigure.translateToRelative((Translatable)p);
            return this.rectFault.contains(p);
        }
        return false;
    }

    public void setShowFault(boolean showFault) {
        this.showFault = showFault;
    }

    public void setCompensationImage(Image compensationImage) {
        this.compensationImage = compensationImage;
        Rectangle r = compensationImage.getBounds();
        this.compensationImageWidth = r.width;
        this.compensationImageHeight = r.height;
    }

    public boolean isPointInCompensationImage(int x, int y) {
        if (this.showCompensation) {
            Point p = new Point(x, y);
            this.parentFigure.translateToRelative((Translatable)p);
            return this.rectCompensation.contains(p);
        }
        return false;
    }

    public void setShowCompensation(boolean showCompensation) {
        this.showCompensation = showCompensation;
    }

    public void setEventImage(Image eventImage) {
        this.eventImage = eventImage;
        Rectangle r = eventImage.getBounds();
        this.eventImageWidth = r.width;
        this.eventImageHeight = r.height;
    }

    public boolean isPointInEventImage(int x, int y) {
        if (this.showEvent) {
            Point p = new Point(x, y);
            this.parentFigure.translateToRelative((Translatable)p);
            return this.rectEvent.contains(p);
        }
        return false;
    }

    public void setShowEvent(boolean showEvent) {
        this.showEvent = showEvent;
    }

    @Override
    protected org.eclipse.draw2d.geometry.Rectangle getGradientRect() {
        org.eclipse.draw2d.geometry.Rectangle bounds = this.parentFigure.getBounds();
        this.rectBounds = new org.eclipse.draw2d.geometry.Rectangle();
        this.rectBounds.x = bounds.x + 16;
        this.rectBounds.y = bounds.y;
        this.rectBounds.width = bounds.width - 32;
        this.rectBounds.height = bounds.height;
        if (Platform.getWS().equals("gtk")) {
            --this.rectBounds.height;
        }
        return this.rectBounds;
    }

    @Override
    public boolean isPointInTopDrawer(int x, int y) {
        if (this.getTopMarker() == null) {
            return false;
        }
        if (this.bounds == null) {
            return false;
        }
        Point p = new Point(x, y);
        this.parentFigure.translateToRelative((Translatable)p);
        Image image = this.getTopImage();
        Rectangle imageSize = image.getBounds();
        int imageX = this.bounds.x + 30;
        int imageY = this.bounds.y + 30 + 2;
        org.eclipse.draw2d.geometry.Rectangle imageBounds = new org.eclipse.draw2d.geometry.Rectangle(imageX, imageY, imageSize.width, imageSize.height);
        return imageBounds.contains(p);
    }

    @Override
    public boolean isPointInBottomDrawer(int x, int y) {
        if (this.getBottomMarker() == null) {
            return false;
        }
        if (this.bounds == null) {
            return false;
        }
        Point p = new Point(x, y);
        this.parentFigure.translateToRelative((Translatable)p);
        Image image = this.getBottomImage();
        Rectangle imageSize = image.getBounds();
        int imageX = this.bounds.x + 30;
        int imageY = this.bounds.y + 30 + 2 + 12;
        org.eclipse.draw2d.geometry.Rectangle imageBounds = new org.eclipse.draw2d.geometry.Rectangle(imageX, imageY, imageSize.width, imageSize.height);
        return imageBounds.contains(p);
    }

    private void computeHandlerIconPositions(boolean horizontal) {
        if (horizontal) {
            int x;
            if (this.showFault) {
                x = this.bounds.x + this.bounds.width - this.faultImageWidth - 16 + 1;
                if (this.showCompensation) {
                    x -= this.compensationImageWidth;
                }
                if (this.showEvent) {
                    x -= this.eventImageWidth;
                }
                this.rectFault = new org.eclipse.draw2d.geometry.Rectangle(x, this.getGradientRect().y + this.getGradientRect().height - this.faultImageHeight + 5, this.faultImageWidth, this.faultImageHeight);
            }
            if (this.showCompensation) {
                x = this.bounds.x + this.bounds.width - this.compensationImageWidth - 16 + 1;
                if (this.showEvent) {
                    x -= this.eventImageWidth;
                }
                this.rectCompensation = new org.eclipse.draw2d.geometry.Rectangle(x, this.getGradientRect().y + this.getGradientRect().height - this.compensationImageHeight + 5, this.compensationImageWidth, this.compensationImageHeight);
            }
            if (this.showEvent) {
                x = this.bounds.x + this.bounds.width - this.eventImageWidth - 16 + 1;
                this.rectEvent = new org.eclipse.draw2d.geometry.Rectangle(x, this.getGradientRect().y + this.getGradientRect().height - this.eventImageHeight + 5, this.eventImageWidth, this.eventImageHeight);
            }
        } else {
            if (this.showFault) {
                this.rectFault = new org.eclipse.draw2d.geometry.Rectangle(this.bounds.x + this.bounds.width - this.faultImageWidth - 16 + 1, this.bounds.y, this.faultImageWidth, this.faultImageHeight);
            }
            if (this.showCompensation) {
                int compensationImageOffset = this.bounds.y;
                if (this.showFault) {
                    compensationImageOffset += this.faultImageHeight;
                }
                this.rectCompensation = new org.eclipse.draw2d.geometry.Rectangle(this.bounds.x + this.bounds.width - this.compensationImageWidth - 16 + 1, compensationImageOffset, this.compensationImageWidth, this.compensationImageHeight);
            }
            if (this.showEvent) {
                int eventImageOffset = this.bounds.y;
                if (this.showFault) {
                    eventImageOffset += this.faultImageHeight;
                }
                if (this.showCompensation) {
                    eventImageOffset += this.compensationImageHeight;
                }
                this.rectEvent = new org.eclipse.draw2d.geometry.Rectangle(this.bounds.x + this.bounds.width - this.eventImageWidth - 16 + 1, eventImageOffset, this.eventImageWidth, this.eventImageHeight);
            }
        }
        if (this.showFault) {
            this.faultImageFigure.setBounds(this.rectFault);
        }
        if (this.showCompensation) {
            this.compensationImageFigure.setBounds(this.rectCompensation);
        }
        if (this.showEvent) {
            this.eventImageFigure.setBounds(this.rectEvent);
        }
    }

    public IFigure getFaultImageFigure() {
        return this.faultImageFigure;
    }

    public IFigure getCompensationImageFigure() {
        return this.compensationImageFigure;
    }

    public IFigure getEventImageFigure() {
        return this.eventImageFigure;
    }
}

