/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editparts.borders;

import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.editparts.BPELEditPart;
import org.eclipse.bpel.ui.editparts.borders.DrawerBorder;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Color;

public abstract class GradientBorder
extends DrawerBorder {
    private BPELEditPart editPart = null;
    private boolean isVertical = false;
    private int arcWidth = -1;

    public GradientBorder(boolean isVertical) {
        this.isVertical = isVertical;
    }

    public GradientBorder(boolean isVertical, int arcWidth) {
        this(isVertical);
        this.arcWidth = arcWidth;
    }

    public BPELEditPart getEditPart() {
        return this.editPart;
    }

    public Insets getInsets(IFigure arg0) {
        return null;
    }

    public void paint(IFigure arg0, Graphics arg1, Insets arg2) {
    }

    protected Rectangle getGradientRect() {
        return null;
    }

    public void paintGradient(Graphics graphics) {
        Rectangle rect = this.getGradientRect();
        if (rect == null) {
            return;
        }
        int fill = 0;
        if (this.editPart != null && this.editPart.getContentPane() != null) {
            fill = BPELUtil.getRepaintFillType(this.editPart.getContentPane());
        }
        Color oldBack = graphics.getBackgroundColor();
        Color oldFore = graphics.getForegroundColor();
        ColorRegistry registry = BPELUIPlugin.INSTANCE.getColorRegistry();
        Color from = registry.get("gradientFrom");
        Color to = registry.get("gradientTo");
        if (this.arcWidth == -1) {
            if (fill == 0 || fill == 2) {
                graphics.setForegroundColor(from);
                graphics.setBackgroundColor(to);
            } else {
                graphics.setBackgroundColor(from);
                graphics.setForegroundColor(from);
            }
            graphics.fillGradient(rect, this.isVertical());
        } else if (fill == 0 || fill == 2) {
            if (this.isVertical()) {
                graphics.setForegroundColor(from);
                graphics.setBackgroundColor(from);
                graphics.fillRoundRectangle(new Rectangle(rect.x, rect.y, rect.width, this.arcWidth * 2), this.arcWidth, this.arcWidth);
                graphics.setForegroundColor(to);
                graphics.setBackgroundColor(to);
                graphics.fillRoundRectangle(new Rectangle(rect.x, rect.y + rect.height - this.arcWidth * 2, rect.width, this.arcWidth * 2), this.arcWidth, this.arcWidth);
                graphics.setForegroundColor(from);
                graphics.setBackgroundColor(to);
                graphics.fillGradient(new Rectangle(rect.x, rect.y + this.arcWidth, rect.width, rect.height - this.arcWidth * 2), true);
            } else {
                graphics.setForegroundColor(from);
                graphics.setBackgroundColor(from);
                graphics.fillRoundRectangle(new Rectangle(rect.x, rect.y, this.arcWidth * 2, rect.height), this.arcWidth, this.arcWidth);
                graphics.setForegroundColor(to);
                graphics.setBackgroundColor(to);
                graphics.fillRoundRectangle(new Rectangle(rect.x + rect.width - this.arcWidth * 2, rect.y, this.arcWidth * 2, rect.height), this.arcWidth, this.arcWidth);
                graphics.setForegroundColor(from);
                graphics.setBackgroundColor(to);
                graphics.fillGradient(new Rectangle(rect.x + this.arcWidth, rect.y, rect.width - this.arcWidth * 2, rect.height), false);
            }
        } else {
            graphics.setBackgroundColor(from);
            graphics.setForegroundColor(from);
            graphics.fillGradient(rect, this.isVertical());
        }
        graphics.setBackgroundColor(oldBack);
        graphics.setForegroundColor(oldFore);
    }

    public void setEditPart(BPELEditPart editpart) {
        this.editPart = editpart;
    }

    protected boolean isVertical() {
        return this.isVertical;
    }
}

