/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editparts;

import java.util.List;
import org.eclipse.bpel.model.Activity;
import org.eclipse.bpel.model.Sequence;
import org.eclipse.bpel.ui.adapters.IContainer;
import org.eclipse.bpel.ui.adapters.ILabeledElement;
import org.eclipse.bpel.ui.editparts.policies.BPELComponentEditPolicy;
import org.eclipse.bpel.ui.editparts.policies.BPELContainerEditPolicy;
import org.eclipse.bpel.ui.editparts.policies.BPELDirectEditPolicy;
import org.eclipse.bpel.ui.editparts.policies.BPELOrderedLayoutEditPolicy;
import org.eclipse.bpel.ui.editparts.policies.OutlineTreeEditPolicy;
import org.eclipse.bpel.ui.editparts.util.OutlineTreePartFactory;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.BatchedMultiObjectAdapter;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.bpel.ui.util.MultiObjectAdapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.TreeEditPart;
import org.eclipse.gef.editparts.AbstractTreeEditPart;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class OutlineTreeEditPart
extends AbstractTreeEditPart {
    protected MultiObjectAdapter adapter = new BatchedMultiObjectAdapter(){
        boolean needRefresh = false;

        @Override
        public void notify(Notification notification) {
            this.needRefresh = true;
            OutlineTreeEditPart.this.refreshAdapters();
        }

        @Override
        public void finish() {
            if (OutlineTreeEditPart.this.isActive() && this.needRefresh) {
                OutlineTreeEditPart.this.handleModelChanged();
            }
            this.needRefresh = false;
        }
    };
    protected Image outlineImage = null;

    protected void addAllAdapters() {
        EObject modelObject = (EObject)this.getModel();
        this.adapter.addToObject((Notifier)modelObject);
        EObject extension = ModelHelper.getExtension(modelObject);
        if (extension != null) {
            this.adapter.addToObject((Notifier)extension);
        }
        try {
            Activity activity = ModelHelper.getActivity(modelObject);
            if (activity instanceof Sequence) {
                this.adapter.addToObject((Notifier)activity);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    protected void removeAllAdapters() {
        this.adapter.removeFromAll();
    }

    protected void refreshAdapters() {
        this.removeAllAdapters();
        this.addAllAdapters();
    }

    public void activate() {
        if (this.isActive()) {
            return;
        }
        super.activate();
        this.addAllAdapters();
    }

    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        this.removeAllAdapters();
        super.deactivate();
    }

    protected void unregisterVisuals() {
        if (this.outlineImage != null) {
            this.outlineImage = null;
        }
        super.unregisterVisuals();
    }

    protected void refreshVisuals() {
        if (this.getWidget() instanceof Tree) {
            return;
        }
        super.refreshVisuals();
        Image is = this.getSmallImg();
        if (is != null) {
            if (this.outlineImage != null) {
                this.outlineImage = null;
            }
            this.outlineImage = is;
            TreeItem item = (TreeItem)this.getWidget();
            if (this.outlineImage != null) {
                this.outlineImage.setBackground(item.getParent().getBackground());
            }
            this.setWidgetImage(this.outlineImage);
        }
        String name = this.getLabel();
        this.setWidgetText(name);
    }

    private Image getSmallImg() {
        Object model = this.getModel();
        ILabeledElement element = BPELUtil.adapt(model, ILabeledElement.class);
        if (element != null) {
            return element.getSmallImage(model);
        }
        return null;
    }

    private String getLabel() {
        Object model = this.getModel();
        ILabeledElement element = BPELUtil.adapt(model, ILabeledElement.class);
        if (element != null) {
            return element.getLabel(model);
        }
        return null;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new BPELComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new BPELOrderedLayoutEditPolicy());
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new OutlineTreeEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new BPELDirectEditPolicy());
        if (BPELUtil.adapt(this.getModel(), IContainer.class) != null) {
            this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new BPELContainerEditPolicy());
        }
    }

    protected List getModelChildren() {
        return OutlineTreePartFactory.getModelChildren(this.getModel());
    }

    public void handleModelChanged() {
        this.refreshChildren();
        this.refreshVisuals();
    }

    protected void reorderChild(EditPart editpart, int index) {
        TreeItem ti;
        boolean expanded = false;
        boolean resetState = false;
        TreeEditPart treeEditPart = (TreeEditPart)editpart;
        Widget wid = treeEditPart.getWidget();
        if (wid != null && wid instanceof TreeItem) {
            TreeItem ti2 = (TreeItem)wid;
            expanded = ti2.getExpanded();
            resetState = true;
        }
        this.removeChildVisual(editpart);
        List children = this.getChildren();
        children.remove(editpart);
        children.add(index, editpart);
        this.addChildVisual(editpart, index);
        if (resetState && (ti = (TreeItem)treeEditPart.getWidget()) != null) {
            ti.setExpanded(expanded);
        }
        editpart.refresh();
    }
}

