/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editors.xpath;

import org.eclipse.bpel.ui.contentassist.ExpressionSourceViewerConfiguration;
import org.eclipse.bpel.ui.editors.xpath.ColorManager;
import org.eclipse.bpel.ui.editors.xpath.XPathSourceDoubleClickStrategy;
import org.eclipse.bpel.ui.editors.xpath.XPathSourceScanner;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;

public class XPathSourceViewerConfiguration
extends ExpressionSourceViewerConfiguration {
    private XPathSourceDoubleClickStrategy doubleClickStrategy;
    private XPathSourceScanner scanner;
    private ColorManager colorManager;

    public XPathSourceViewerConfiguration(ColorManager manager) {
        this.colorManager = manager;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type"};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new XPathSourceDoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    protected XPathSourceScanner getXPathSourceScanner() {
        if (this.scanner == null) {
            this.scanner = new XPathSourceScanner(this.colorManager);
        }
        return this.scanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getXPathSourceScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        return reconciler;
    }
}

