/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.details.tree;

import org.eclipse.bpel.model.messageproperties.Property;
import org.eclipse.bpel.ui.details.tree.TreeNode;
import org.eclipse.bpel.ui.details.tree.XSDTypeDefinitionTreeNode;
import org.eclipse.xsd.XSDTypeDefinition;

public class PropertyTreeNode
extends TreeNode {
    XSDTypeDefinitionTreeNode xsdType;

    public PropertyTreeNode(Property property, boolean isCondensed) {
        super(property, isCondensed);
        if (isCondensed && property.getType() != null) {
            this.xsdType = new XSDTypeDefinitionTreeNode((XSDTypeDefinition)property.getType(), isCondensed);
        }
    }

    @Override
    public String getLabelSuffix() {
        if (this.isCondensed && this.xsdType != null) {
            return this.xsdType.getLabel();
        }
        return null;
    }

    @Override
    public Object[] getChildren() {
        if (this.isCondensed) {
            if (this.xsdType != null) {
                return this.xsdType.getChildren();
            }
            return EMPTY_ARRAY;
        }
        Property property = (Property)this.modelObject;
        if (property.getType() != null) {
            Object[] result = new Object[]{new XSDTypeDefinitionTreeNode((XSDTypeDefinition)property.getType(), this.isCondensed)};
            return result;
        }
        return EMPTY_ARRAY;
    }

    @Override
    public boolean hasChildren() {
        if (this.isCondensed) {
            if (this.xsdType != null) {
                return this.xsdType.hasChildren();
            }
            return false;
        }
        Property property = (Property)this.modelObject;
        return property.getType() != null;
    }
}

