/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.details.providers;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.bpel.ui.details.providers.AbstractContentProvider;
import org.eclipse.bpel.ui.util.XSDUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Types;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;

public class XSDTypeOrElementContentProvider
extends AbstractContentProvider {
    protected static final List xsdPrimitiveTypes = XSDUtils.getAdvancedPrimitives();
    protected static final HashSet xsdPrimitiveTypesNames = new HashSet(xsdPrimitiveTypes.size() + 1);
    public static final int INCLUDE_SIMPLE_TYPES = 1;
    public static final int INCLUDE_COMPLEX_TYPES = 2;
    public static final int INCLUDE_TYPES = 3;
    public static final int INCLUDE_ELEMENT_DECLARATIONS = 4;
    public static final int INCLUDE_PRIMITIVES = 8;
    public static final int INCLUDE_ALL = 255;
    private int fFilter = 255;

    static {
        for (XSDNamedComponent component : xsdPrimitiveTypes) {
            xsdPrimitiveTypesNames.add(component.getName());
        }
    }

    public void setFilter(int filter) {
        this.fFilter = filter;
    }

    public int getFilter() {
        return this.fFilter;
    }

    public void collectElements(Object input, List list) {
        if (input == null) {
            return;
        }
        if (input instanceof Definition) {
            Types types = ((Definition)input).getETypes();
            if (types == null) {
                return;
            }
            this.collectElements((Object)types.getSchemas(), list);
            return;
        }
        if (input instanceof XSDSchema) {
            XSDSchema schema = (XSDSchema)input;
            this.addSchemaElements(list, schema);
            return;
        }
        this.collectComplex(input, list);
    }

    protected void addSchemaElements(List list, XSDSchema schema) {
        boolean builtInTypesSchema = "http://www.w3.org/2001/XMLSchema".equals(schema.getTargetNamespace());
        if (builtInTypesSchema && (this.fFilter & 8) > 0) {
            list.addAll(XSDUtils.getAdvancedPrimitives());
            return;
        }
        if ((this.fFilter & 4) > 0) {
            list.addAll(schema.getElementDeclarations());
        }
        if ((this.fFilter & 3) == 0) {
            return;
        }
        EList types = schema.getTypeDefinitions();
        Iterator i = types.iterator();
        boolean bAdd = false;
        while (i.hasNext()) {
            XSDTypeDefinition defn = (XSDTypeDefinition)i.next();
            boolean bl = bAdd = (this.fFilter & 2) > 0 && defn instanceof XSDComplexTypeDefinition || (this.fFilter & 1) > 0 && defn instanceof XSDSimpleTypeDefinition;
            if (!bAdd) continue;
            list.add(defn);
        }
    }

    public static boolean isBuiltInType(XSDTypeDefinition target) {
        XSDSchema schema = (XSDSchema)target.eContainer();
        if (!"http://www.w3.org/2001/XMLSchema".equals(schema.getTargetNamespace())) {
            return false;
        }
        return xsdPrimitiveTypesNames.contains(target.getName());
    }
}

