/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.commands;

import org.eclipse.bpel.common.ui.editmodel.AbstractEditModelCommand;
import org.eclipse.bpel.model.adapters.INamespaceMap;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class SetNamespaceMappingCommand
extends AbstractEditModelCommand {
    protected EObject fTarget;
    String fNamespace;
    String fPrefix;
    String fPreviousNS;

    public SetNamespaceMappingCommand(EObject aTarget, String ns, String prefix) {
        this.fTarget = aTarget;
        this.fNamespace = ns;
        this.fPrefix = prefix;
    }

    public boolean canExecute() {
        return BPELUtils.isValidPrefixName((String)this.fPrefix);
    }

    public void dispose() {
        this.fTarget = null;
        this.fPrefix = null;
        this.fNamespace = null;
        super.dispose();
    }

    public void execute() {
        INamespaceMap nsMap = BPELUtils.getNamespaceMap((EObject)this.fTarget);
        this.fPreviousNS = (String)nsMap.put((Object)this.fPrefix, (Object)this.fNamespace);
    }

    public void undo() {
        INamespaceMap nsMap = BPELUtils.getNamespaceMap((EObject)this.fTarget);
        if (this.fPreviousNS == null) {
            nsMap.remove((Object)this.fPrefix);
        } else {
            nsMap.put((Object)this.fPrefix, (Object)this.fPreviousNS);
        }
    }

    public Resource[] getModifiedResources() {
        Resource resource = this.fTarget.eResource();
        if (resource != null) {
            return new Resource[]{resource};
        }
        return EMPTY_RESOURCE_ARRAY;
    }
}

