/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.commands;

import org.eclipse.bpel.ui.commands.SetCommand;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.wst.wsdl.ExtensibilityElement;
import org.eclipse.wst.wsdl.ExtensibleElement;

public abstract class SetExtensionCommand
extends SetCommand {
    protected ExtensibilityElement oldExt;
    protected ExtensibilityElement newExt;
    protected ExtensibilityElement targetExt;
    protected EClass extClass;

    public SetExtensionCommand(EObject target, EClass extClass, Object newValue) {
        super(target, newValue);
        this.extClass = extClass;
    }

    public ExtensibilityElement createExtension() {
        return (ExtensibilityElement)this.extClass.getEPackage().getEFactoryInstance().create(this.extClass);
    }

    public boolean isTargetExtensionUnused() {
        for (EStructuralFeature feature : this.targetExt.eClass().getEAllStructuralFeatures()) {
            Object defaultValue;
            if (feature.isTransient() && "elementType".equals(feature.getName()) || !((defaultValue = feature.getDefaultValue()) == null ? this.targetExt.eGet(feature) != null : !defaultValue.equals(this.targetExt.eGet(feature)))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void doExecute() {
        this.targetExt = this.oldExt = ModelHelper.getExtensibilityElement((Object)this.fTarget, this.extClass);
        if (this.targetExt != null) {
            this.fOldValue = this.get();
        }
        this.newExt = this.oldExt == null ? this.createExtension() : this.oldExt;
        this.targetExt = this.newExt;
        EList eeList = ((ExtensibleElement)this.fTarget).getEExtensibilityElements();
        if (this.newExt == this.oldExt && this.oldExt != null) {
            eeList.set(eeList.indexOf(this.oldExt), this.newExt);
        }
        if (this.targetExt != null) {
            this.set(this.fNewValue);
        }
        if (this.isTargetExtensionUnused()) {
            this.newExt = null;
        }
        if (this.newExt == this.oldExt) {
            if (this.oldExt != null) {
                eeList.set(eeList.indexOf(this.oldExt), this.newExt);
            }
        } else {
            if (this.oldExt != null) {
                eeList.remove(this.oldExt);
            }
            if (this.newExt != null) {
                eeList.add(this.newExt);
            }
        }
    }
}

