/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.adapters.delegates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.bpel.ui.adapters.delegates.AbstractContainer;
import org.eclipse.emf.ecore.EObject;

public class MultiContainer
extends AbstractContainer {
    boolean allowMixedTypeReplace = false;
    protected List<AbstractContainer> fContainers = new ArrayList<AbstractContainer>();

    public void add(AbstractContainer container) {
        this.fContainers.add(container);
    }

    public final AbstractContainer getSubContainer(EObject object, Object child) {
        if (!(child instanceof EObject)) {
            return null;
        }
        for (AbstractContainer sub : this.fContainers) {
            if (!sub.isValidChild(object, (EObject)child)) continue;
            return sub;
        }
        return null;
    }

    @Override
    protected final boolean isValidChild(EObject object, EObject child) {
        return this.getSubContainer(object, child) != null;
    }

    @Override
    public boolean addChild(EObject object, EObject child, EObject insertBefore) {
        List<EObject> children;
        AbstractContainer childContainer = this.getSubContainer(object, child);
        if (insertBefore == null) {
            if (childContainer == null) {
                return false;
            }
            return childContainer.addChild(object, child, null);
        }
        AbstractContainer insertBeforeContainer = this.getSubContainer(object, insertBefore);
        if (childContainer == insertBeforeContainer) {
            return childContainer.addChild(object, child, insertBefore);
        }
        int childRange = 0;
        int insertBeforeRange = 0;
        Object[] containers = this.fContainers.toArray();
        int i = 0;
        while (i < containers.length) {
            if (containers[i] == childContainer) {
                childRange = i;
            }
            if (containers[i] == insertBeforeContainer) {
                insertBeforeRange = i;
            }
            ++i;
        }
        if (childRange > insertBeforeRange && (children = childContainer.getChildren(object)).size() > 0) {
            return childContainer.addChild(object, child, children.get(0));
        }
        return childContainer.addChild(object, child, null);
    }

    @Override
    public List<EObject> getChildren(EObject object) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (AbstractContainer container : this.fContainers) {
            result.addAll(container.getChildren(object));
        }
        if (result.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public boolean removeChild(EObject object, EObject child) {
        return this.getSubContainer(object, child).removeChild(object, child);
    }

    @Override
    public boolean replaceChild(EObject object, EObject oldChild, EObject newChild) {
        AbstractContainer newSubContainer;
        AbstractContainer oldSubContainer = this.getSubContainer(object, oldChild);
        if (oldSubContainer == (newSubContainer = this.getSubContainer(object, newChild))) {
            return oldSubContainer.replaceChild(object, oldChild, newChild);
        }
        if (!this.allowMixedTypeReplace) {
            return false;
        }
        return this.replaceMixedTypeChild(object, oldChild, newChild);
    }

    protected boolean replaceMixedTypeChild(EObject object, EObject oldChild, EObject newChild) {
        AbstractContainer oldSubContainer = this.getSubContainer(object, oldChild);
        AbstractContainer newSubContainer = this.getSubContainer(object, newChild);
        oldSubContainer.removeChild(object, oldChild);
        newSubContainer.addChild(object, newChild, null);
        return true;
    }

    @Override
    public boolean canAddObject(EObject object, EObject child, EObject insertBefore) {
        AbstractContainer ac = this.getSubContainer(object, child);
        return ac == null ? false : ac.canAddObject(object, child, insertBefore);
    }

    @Override
    public boolean canRemoveChild(EObject object, EObject child) {
        AbstractContainer ac = this.getSubContainer(object, child);
        return ac == null ? false : ac.canRemoveChild(object, child);
    }
}

