/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.adapters;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpel.model.Activity;
import org.eclipse.bpel.ui.actions.editpart.AbstractAction;
import org.eclipse.bpel.ui.actions.editpart.CreateCompensationHandlerAction;
import org.eclipse.bpel.ui.actions.editpart.CreateEventHandlerAction;
import org.eclipse.bpel.ui.actions.editpart.CreateFaultHandlerAction;
import org.eclipse.bpel.ui.actions.editpart.CreateFlowLinkAction;
import org.eclipse.bpel.ui.actions.editpart.CreateTerminationHandlerAction;
import org.eclipse.bpel.ui.adapters.AdapterNotification;
import org.eclipse.bpel.ui.adapters.ICompensationHandlerHolder;
import org.eclipse.bpel.ui.adapters.IEditPartActionContributor;
import org.eclipse.bpel.ui.adapters.IEventHandlerHolder;
import org.eclipse.bpel.ui.adapters.IExtensionFactory;
import org.eclipse.bpel.ui.adapters.IFaultHandlerHolder;
import org.eclipse.bpel.ui.adapters.ILabeledElement;
import org.eclipse.bpel.ui.adapters.IMarkerHolder;
import org.eclipse.bpel.ui.adapters.INamedElement;
import org.eclipse.bpel.ui.adapters.IOutlineEditPartFactory;
import org.eclipse.bpel.ui.adapters.ITerminationHandlerHolder;
import org.eclipse.bpel.ui.adapters.MarkerHolderAdapter;
import org.eclipse.bpel.ui.editparts.LeafEditPart;
import org.eclipse.bpel.ui.editparts.OutlineTreeEditPart;
import org.eclipse.bpel.ui.factories.AbstractUIObjectFactory;
import org.eclipse.bpel.ui.factories.UIObjectFactoryProvider;
import org.eclipse.bpel.ui.uiextensionmodel.UiextensionmodelFactory;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.FlowLinkUtil;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.swt.graphics.Image;

public abstract class ActivityAdapter
extends MarkerHolderAdapter
implements INamedElement,
ILabeledElement,
EditPartFactory,
IOutlineEditPartFactory,
IMarkerHolder,
IEditPartActionContributor,
IExtensionFactory,
AdapterNotification {
    protected AbstractUIObjectFactory getUIObjectFactory(Object modelObject) {
        if (modelObject instanceof EObject) {
            EClass effectiveClass = BPELUtil.getEClassFor(modelObject);
            return UIObjectFactoryProvider.getInstance().getFactoryFor(effectiveClass);
        }
        return null;
    }

    @Override
    public String getName(Object modelObject) {
        return ((Activity)modelObject).getName();
    }

    @Override
    public void setName(Object modelObject, String name) {
        ((Activity)modelObject).setName(name);
    }

    @Override
    public boolean isNameAffected(Object modelObject, Notification n) {
        return n.getFeatureID(Activity.class) == 4;
    }

    @Override
    public String getLabel(Object object) {
        String name = this.getName(object);
        if (name != null) {
            return name;
        }
        return this.getTypeLabel(object);
    }

    @Override
    public String getTypeLabel(Object object) {
        return this.getUIObjectFactory(object).getTypeLabel();
    }

    @Override
    public Image getSmallImage(Object object) {
        return this.getUIObjectFactory(object).getSmallImage();
    }

    @Override
    public Image getLargeImage(Object object) {
        return this.getUIObjectFactory(object).getLargeImage();
    }

    public EditPart createEditPart(EditPart context, Object model) {
        LeafEditPart result = new LeafEditPart();
        result.setModel(model);
        return result;
    }

    @Override
    public EditPart createOutlineEditPart(EditPart context, Object model) {
        OutlineTreeEditPart result = new OutlineTreeEditPart();
        result.setModel(model);
        return result;
    }

    public List<AbstractAction> getEditPartActions(EditPart editPart) {
        IEventHandlerHolder ieh;
        ITerminationHandlerHolder ith;
        ICompensationHandlerHolder ich;
        ArrayList<AbstractAction> actions = new ArrayList<AbstractAction>();
        Object modelObject = editPart.getModel();
        IFaultHandlerHolder ifh = BPELUtil.adapt(modelObject, IFaultHandlerHolder.class);
        if (ifh != null && ifh.getFaultHandler(modelObject) == null) {
            actions.add(new CreateFaultHandlerAction(editPart));
        }
        if ((ich = BPELUtil.adapt(modelObject, ICompensationHandlerHolder.class)) != null && ich.getCompensationHandler(modelObject) == null) {
            actions.add(new CreateCompensationHandlerAction(editPart));
        }
        if ((ith = BPELUtil.adapt(modelObject, ITerminationHandlerHolder.class)) != null && ith.getTerminationHandler(modelObject) == null) {
            actions.add(new CreateTerminationHandlerAction(editPart));
        }
        if ((ieh = BPELUtil.adapt(modelObject, IEventHandlerHolder.class)) != null && ieh.getEventHandler(modelObject) == null) {
            actions.add(new CreateEventHandlerAction(editPart));
        }
        if (FlowLinkUtil.hasParentFlow((EObject)modelObject)) {
            actions.add(new CreateFlowLinkAction(editPart));
        }
        return actions;
    }

    @Override
    public EObject createExtension(EObject object) {
        return UiextensionmodelFactory.eINSTANCE.createActivityExtension();
    }
}

