/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.actions;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PrinterGraphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.print.PrintGraphicalViewerOperation;
import org.eclipse.gef.ui.actions.PrintAction;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;

public class BPELPrintAction
extends PrintAction {
    public BPELPrintAction(IWorkbenchPart part) {
        super(part);
    }

    public void run() {
        GraphicalViewer viewer = (GraphicalViewer)this.getWorkbenchPart().getAdapter(GraphicalViewer.class);
        PrintDialog dialog = new PrintDialog(viewer.getControl().getShell(), 0);
        PrinterData data = dialog.open();
        if (data != null) {
            InternalPrintGraphicalViewerOperation op = new InternalPrintGraphicalViewerOperation(new Printer(data), viewer);
            op.run(this.getWorkbenchPart().getTitle());
        }
    }

    protected class InternalPrintGraphicalViewerOperation
    extends PrintGraphicalViewerOperation {
        protected boolean needMultiPageX;
        protected boolean needMultiPageY;
        private long fPagesX;
        private long fPagesY;

        public InternalPrintGraphicalViewerOperation(Printer p, GraphicalViewer g) {
            super(p, g);
            this.needMultiPageX = false;
            this.needMultiPageY = false;
            this.fPagesX = 1L;
            this.fPagesY = 1L;
        }

        protected ImageData getNewImageData(Image image) {
            ImageData imageData = image.getImageData();
            int x = imageData.width;
            int y = imageData.height;
            return imageData.scaledTo(x, y);
        }

        protected void setupPrinterGraphicsFor(Graphics graphics, IFigure figure) {
            super.setupPrinterGraphicsFor(graphics, figure);
            double dpiScale = (double)this.getPrinter().getDPI().x / (double)Display.getCurrent().getDPI().x;
            Rectangle printableRegion = this.getPrintRegion();
            printableRegion.width = (int)((double)printableRegion.width / dpiScale);
            printableRegion.height = (int)((double)printableRegion.height / dpiScale);
            Rectangle printRegion = figure.getBounds();
            if (printRegion.width > printableRegion.width) {
                this.needMultiPageX = true;
                this.fPagesX = printRegion.width / printableRegion.width;
                if (printRegion.width % printableRegion.width != 0) {
                    ++this.fPagesX;
                }
            }
            if (printRegion.height > printableRegion.height) {
                this.needMultiPageY = true;
                this.fPagesY = printRegion.height / printableRegion.height;
                if (printRegion.height % printableRegion.height != 0) {
                    ++this.fPagesY;
                }
            }
        }

        protected void printPages() {
            PrinterGraphics graphics = this.getFreshPrinterGraphics();
            IFigure figure = this.getPrintSource();
            this.setupPrinterGraphicsFor((Graphics)graphics, figure);
            Rectangle region = figure.getBounds();
            Image image = new Image(null, region.width, region.height);
            GC gc = new GC((Drawable)image);
            SWTGraphics g = new SWTGraphics(gc);
            g.translate(region.x, region.y);
            figure.paint((Graphics)g);
            double dpiScale = (double)this.getPrinter().getDPI().x / (double)Display.getCurrent().getDPI().x;
            region = this.getPrintRegion();
            region.width = (int)((double)region.width / dpiScale);
            region.height = (int)((double)region.height / dpiScale);
            ImageData imageData = this.getNewImageData(image);
            Image newImage = new Image(null, imageData);
            int j = 0;
            while ((long)j < this.fPagesY) {
                int i = 0;
                while ((long)i < this.fPagesX) {
                    int x = region.width * i;
                    int y = region.height * j;
                    graphics.pushState();
                    this.getPrinter().startPage();
                    graphics.drawImage(newImage, x, y, imageData.width - x, imageData.height - y, 0, 0, imageData.width - x, imageData.height - y);
                    this.getPrinter().endPage();
                    graphics.popState();
                    ++i;
                }
                ++j;
            }
            g.dispose();
            gc.dispose();
            image.dispose();
        }
    }
}

