/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.join;

import java.util.List;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.federated.algebra.StatementTupleExpr;
import org.eclipse.rdf4j.federated.evaluation.FederationEvalStrategy;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ParallelExecutor;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ParallelTaskBase;
import org.eclipse.rdf4j.query.BindingSet;

public class ParallelBoundJoinTask
extends ParallelTaskBase<BindingSet> {
    protected final FederationEvalStrategy strategy;
    protected final StatementTupleExpr expr;
    protected final List<BindingSet> bindings;
    protected final ParallelExecutor<BindingSet> joinControl;

    public ParallelBoundJoinTask(ParallelExecutor<BindingSet> joinControl, FederationEvalStrategy strategy, StatementTupleExpr expr, List<BindingSet> bindings) {
        this.strategy = strategy;
        this.expr = expr;
        this.bindings = bindings;
        this.joinControl = joinControl;
    }

    @Override
    protected CloseableIteration<BindingSet> performTaskInternal() throws Exception {
        return this.strategy.evaluateBoundJoinStatementPattern(this.expr, this.bindings);
    }

    @Override
    public ParallelExecutor<BindingSet> getControl() {
        return this.joinControl;
    }
}

