/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.iterator;

import org.eclipse.rdf4j.common.iteration.AbstractCloseableIteration;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;

public class GraphToBindingSetConversionIteration
extends AbstractCloseableIteration<BindingSet> {
    protected final GraphQueryResult graph;

    public GraphToBindingSetConversionIteration(GraphQueryResult graph) {
        this.graph = graph;
    }

    public boolean hasNext() throws QueryEvaluationException {
        return this.graph.hasNext();
    }

    public BindingSet next() throws QueryEvaluationException {
        return this.convert((Statement)this.graph.next());
    }

    public void remove() throws QueryEvaluationException {
        this.graph.remove();
    }

    protected BindingSet convert(Statement st) {
        QueryBindingSet result = new QueryBindingSet();
        result.addBinding("subject", (Value)st.getSubject());
        result.addBinding("predicate", (Value)st.getPredicate());
        result.addBinding("object", st.getObject());
        if (st.getContext() != null) {
            result.addBinding("context", (Value)st.getContext());
        }
        return result;
    }

    protected void handleClose() throws QueryEvaluationException {
        this.graph.close();
    }
}

