/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.datetime;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;

public class Tz
implements Function {
    @Override
    public String getURI() {
        return "TZ";
    }

    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException("TZ requires 1 argument, got " + args.length);
        }
        Value argValue = args[0];
        if (argValue instanceof Literal) {
            Literal literal = (Literal)argValue;
            CoreDatatype.XSD datatype = literal.getCoreDatatype().asXSDDatatypeOrNull();
            if (datatype != null && datatype.isCalendarDatatype()) {
                String lexValue = literal.getLabel();
                Pattern pattern = Pattern.compile("Z|[+-]\\d\\d:\\d\\d");
                Matcher m = pattern.matcher(lexValue);
                String timeZone = "";
                if (m.find()) {
                    timeZone = m.group();
                }
                return valueFactory.createLiteral(timeZone);
            }
            throw new ValueExprEvaluationException("unexpected input value for function: " + argValue);
        }
        throw new ValueExprEvaluationException("unexpected input value for function: " + args[0]);
    }
}

