/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Comparator;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.util.lmdb.LMDB;
import org.lwjgl.util.lmdb.MDBCmpFuncI;
import org.lwjgl.util.lmdb.MDBVal;

final class LmdbUtil {
    static final long MIN_FREE_SPACE = 524288L;

    private LmdbUtil() {
    }

    static void E(int rc) throws IOException {
        if (rc != 0 && rc != -30798) {
            throw new IOException(LMDB.mdb_strerror((int)rc));
        }
    }

    static <T> T readTransaction(long env, Transaction<T> transaction) throws IOException {
        return LmdbUtil.readTransaction(env, 0L, transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T readTransaction(long env, long writeTxn, Transaction<T> transaction) throws IOException {
        T ret;
        try (MemoryStack stack = MemoryStack.stackPush();){
            long txn;
            if (writeTxn == 0L) {
                PointerBuffer pp = stack.mallocPointer(1);
                LmdbUtil.E(LMDB.mdb_txn_begin((long)env, (long)0L, (int)131072, (PointerBuffer)pp));
                txn = pp.get(0);
            } else {
                txn = writeTxn;
            }
            try {
                ret = transaction.exec(stack, txn);
            }
            finally {
                if (writeTxn == 0L) {
                    LMDB.mdb_txn_abort((long)txn);
                }
            }
        }
        return ret;
    }

    static <T> T transaction(long env, Transaction<T> transaction) throws IOException {
        T ret;
        try (MemoryStack stack = MemoryStack.stackPush();){
            int err;
            PointerBuffer pp = stack.mallocPointer(1);
            LmdbUtil.E(LMDB.mdb_txn_begin((long)env, (long)0L, (int)0, (PointerBuffer)pp));
            long txn = pp.get(0);
            try {
                ret = transaction.exec(stack, txn);
                err = LMDB.mdb_txn_commit((long)txn);
            }
            catch (Throwable t) {
                LMDB.mdb_txn_abort((long)txn);
                throw t;
            }
            LmdbUtil.E(err);
        }
        return ret;
    }

    static int openDatabase(long env, String name, int flags, Comparator<ByteBuffer> comparator) throws IOException {
        return LmdbUtil.transaction(env, (stack, txn) -> {
            IntBuffer ip = stack.mallocInt(1);
            LmdbUtil.E(LMDB.mdb_dbi_open((long)txn, (CharSequence)name, (int)flags, (IntBuffer)ip));
            int dbi = ip.get(0);
            if (comparator != null) {
                MDBCmpFuncI cmp = (a, b) -> {
                    MDBVal aVal = MDBVal.create((long)a);
                    MDBVal bVal = MDBVal.create((long)b);
                    return comparator.compare(aVal.mv_data(), bVal.mv_data());
                };
                LMDB.mdb_set_compare((long)txn, (int)dbi, (MDBCmpFuncI)cmp);
            }
            return dbi;
        });
    }

    private static long mdbTxnMtNextPgno(long txn) {
        return MemoryUtil.memGetAddress((long)(txn + (long)(2 * Pointer.POINTER_SIZE)));
    }

    static boolean requiresResize(long mapSize, long pageSize, long txn, long requiredSize) {
        long nextPageNo = LmdbUtil.mdbTxnMtNextPgno(txn);
        return mapSize - nextPageNo * pageSize < Math.max(requiredSize, 524288L);
    }

    static long autoGrowMapSize(long mapSize, long pageSize, long requiredSize) {
        return (mapSize = Math.max(mapSize * 2L, Math.max(requiredSize, 524288L))) % pageSize == 0L ? mapSize : mapSize + (mapSize / pageSize + 1L) * pageSize;
    }

    @FunctionalInterface
    static interface Transaction<T> {
        public T exec(MemoryStack var1, long var2) throws IOException;
    }
}

