/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb;

import org.eclipse.rdf4j.common.concurrent.locks.Lock;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.SailReadOnlyException;
import org.eclipse.rdf4j.sail.base.SailSourceConnection;
import org.eclipse.rdf4j.sail.helpers.AbstractSail;
import org.eclipse.rdf4j.sail.helpers.DefaultSailChangedEvent;
import org.eclipse.rdf4j.sail.lmdb.LmdbStore;

public class LmdbStoreConnection
extends SailSourceConnection {
    protected final LmdbStore lmdbStore;
    private volatile DefaultSailChangedEvent sailChangedEvent;
    private volatile Lock txnLock;

    protected LmdbStoreConnection(LmdbStore sail) {
        super((AbstractSail)sail, sail.getSailStore(), sail.getEvaluationStrategyFactory());
        this.lmdbStore = sail;
        this.sailChangedEvent = new DefaultSailChangedEvent(sail);
    }

    @Override
    protected void startTransactionInternal() throws SailException {
        if (!this.lmdbStore.isWritable()) {
            throw new SailReadOnlyException("Unable to start transaction: data file is locked or read-only");
        }
        boolean releaseLock = true;
        try {
            if (this.txnLock == null || !this.txnLock.isActive()) {
                this.txnLock = this.lmdbStore.getTransactionLock(this.getTransactionIsolation());
                if (this.lmdbStore.isIsolationDisabled()) {
                    releaseLock = false;
                }
            }
            super.startTransactionInternal();
        }
        finally {
            if (releaseLock && this.txnLock != null && this.txnLock.isActive()) {
                this.txnLock.release();
            }
        }
    }

    @Override
    protected void commitInternal() throws SailException {
        try {
            super.commitInternal();
        }
        finally {
            if (this.txnLock != null && this.txnLock.isActive()) {
                this.txnLock.release();
            }
        }
        this.lmdbStore.notifySailChanged(this.sailChangedEvent);
        this.sailChangedEvent = new DefaultSailChangedEvent(this.lmdbStore);
    }

    @Override
    protected void rollbackInternal() throws SailException {
        try {
            super.rollbackInternal();
        }
        finally {
            if (this.txnLock != null && this.txnLock.isActive()) {
                this.txnLock.release();
            }
        }
        this.sailChangedEvent = new DefaultSailChangedEvent(this.lmdbStore);
    }

    @Override
    protected void addStatementInternal(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        this.sailChangedEvent.setStatementsAdded(true);
    }

    @Override
    public boolean addInferredStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        boolean ret = super.addInferredStatement(subj, pred, obj, contexts);
        this.sailChangedEvent.setStatementsAdded(true);
        return ret;
    }

    @Override
    protected void removeStatementsInternal(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        this.sailChangedEvent.setStatementsRemoved(true);
    }

    @Override
    public boolean removeInferredStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        boolean ret = super.removeInferredStatement(subj, pred, obj, contexts);
        this.sailChangedEvent.setStatementsRemoved(true);
        return ret;
    }

    @Override
    protected void clearInternal(Resource ... contexts) throws SailException {
        super.clearInternal(contexts);
        this.sailChangedEvent.setStatementsRemoved(true);
    }

    @Override
    public void clearInferred(Resource ... contexts) throws SailException {
        super.clearInferred(contexts);
        this.sailChangedEvent.setStatementsRemoved(true);
    }
}

