/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.impl;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.TimeLimitIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryInterruptedException;
import org.eclipse.rdf4j.query.impl.AbstractQuery;
import org.eclipse.rdf4j.query.impl.FallbackDataset;
import org.eclipse.rdf4j.query.parser.ParsedQuery;

public abstract class AbstractParserQuery
extends AbstractQuery {
    private final ParsedQuery parsedQuery;
    protected static final int DEFAULT_EXPLANATION_EXECUTION_TIMEOUT = 60;

    protected AbstractParserQuery(ParsedQuery parsedQuery) {
        this.parsedQuery = parsedQuery;
    }

    public ParsedQuery getParsedQuery() {
        return this.parsedQuery;
    }

    protected CloseableIteration<? extends BindingSet> enforceMaxQueryTime(CloseableIteration<? extends BindingSet> bindingsIter) {
        if (this.getMaxExecutionTime() > 0) {
            bindingsIter = new QueryInterruptIteration(bindingsIter, 1000L * (long)this.getMaxExecutionTime());
        }
        return bindingsIter;
    }

    public Dataset getActiveDataset() {
        if (this.dataset != null) {
            return FallbackDataset.fallback(this.dataset, this.parsedQuery.getDataset());
        }
        return this.parsedQuery.getDataset();
    }

    public String toString() {
        return this.parsedQuery.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractParserQuery that = (AbstractParserQuery)o;
        return this.parsedQuery.equals(that.parsedQuery);
    }

    public int hashCode() {
        return this.parsedQuery.hashCode();
    }

    @Deprecated(since="4.1.0")
    protected class QueryInterruptIteration
    extends TimeLimitIteration<BindingSet> {
        public QueryInterruptIteration(CloseableIteration<? extends BindingSet> iter, long timeLimit) {
            super(iter, timeLimit);
        }

        @Override
        protected void throwInterruptedException() throws QueryEvaluationException {
            throw new QueryInterruptedException("Query evaluation took too long");
        }
    }
}

