/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast;

import org.eclipse.rdf4j.common.exception.RDF4JException;
import org.eclipse.rdf4j.model.Resource;

public class ShaclShapeParsingException
extends RDF4JException {
    Resource id;

    public ShaclShapeParsingException(String msg, Resource id) {
        super(msg + " - Caused by shape with id: " + ShaclShapeParsingException.resourceToString(id));
        this.id = id;
    }

    public ShaclShapeParsingException(String msg, Throwable t, Resource id) {
        super(msg + " - Caused by shape with id: " + ShaclShapeParsingException.resourceToString(id), t);
        this.id = id;
    }

    public ShaclShapeParsingException(Throwable t, Resource id) {
        super(t.getMessage() + " - Caused by shape with id: " + ShaclShapeParsingException.resourceToString(id), t);
        this.id = id;
    }

    public Resource getId() {
        return this.id;
    }

    private static String resourceToString(Resource id) {
        assert (id != null);
        if (id == null) {
            return "null";
        }
        if (id.isIRI()) {
            return "<" + id.stringValue() + ">";
        }
        if (id.isBNode()) {
            return id.toString();
        }
        if (id.isTriple()) {
            return "TRIPLE " + id;
        }
        return id.toString();
    }
}

