/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.paths;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclAstLists;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.paths.Path;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.AllTargetsPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeWrapper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Select;
import org.eclipse.rdf4j.sail.shacl.ast.targets.EffectiveTarget;
import org.eclipse.rdf4j.sail.shacl.ast.targets.TargetChainRetriever;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.ShapeSource;

public class SequencePath
extends Path {
    private final List<Path> paths;

    public SequencePath(Resource id, ShapeSource shapeSource) {
        super(id);
        this.paths = ShaclAstLists.toList(shapeSource, id, Resource.class).stream().map(p -> Path.buildPath(shapeSource, p)).collect(Collectors.toList());
    }

    public SequencePath(Resource id, List<Path> paths) {
        super(id);
        this.paths = paths;
    }

    public String toString() {
        return "SequencePath{ " + Arrays.toString(this.paths.toArray()) + " }";
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        List values = this.paths.stream().map(Path::getId).collect(Collectors.toList());
        if (!model.contains(this.id, null, null, new Resource[0])) {
            ShaclAstLists.listToRdf(values, this.id, model);
        }
        this.paths.forEach(p -> p.toModel(p.getId(), null, model, cycleDetection));
    }

    @Override
    public PlanNode getAllAdded(ConnectionsGroup connectionsGroup, Resource[] dataGraph, PlanNodeWrapper planNodeWrapper) {
        List<StatementMatcher.Variable<Value>> variables = List.of(new StatementMatcher.Variable<String>("subject"), new StatementMatcher.Variable<String>("value"));
        SparqlFragment targetQueryFragment = this.getTargetQueryFragment(variables.get(0), variables.get(1), connectionsGroup.getRdfsSubClassOfReasoner(), new StatementMatcher.StableRandomVariableProvider(), Set.of());
        PlanNode targetChainRetriever = new TargetChainRetriever(connectionsGroup, dataGraph, targetQueryFragment.getStatementMatchers(), List.of(), null, targetQueryFragment, variables, ConstraintComponent.Scope.propertyShape, true);
        targetChainRetriever = connectionsGroup.getCachedNodeFor(targetChainRetriever);
        if (planNodeWrapper != null) {
            targetChainRetriever = (PlanNode)planNodeWrapper.apply(targetChainRetriever);
        }
        return connectionsGroup.getCachedNodeFor(targetChainRetriever);
    }

    @Override
    public PlanNode getAnyAdded(ConnectionsGroup connectionsGroup, Resource[] dataGraph, PlanNodeWrapper planNodeWrapper) {
        List<StatementMatcher.Variable<String>> variables = List.of(new StatementMatcher.Variable<String>("subject"), new StatementMatcher.Variable<String>("value"));
        SparqlFragment targetQueryFragment = this.getTargetQueryFragment(variables.get(0), variables.get(1), connectionsGroup.getRdfsSubClassOfReasoner(), new StatementMatcher.StableRandomVariableProvider(), Set.of());
        PlanNode unorderedSelect = new Select(connectionsGroup.getAddedStatements(), targetQueryFragment, null, new AllTargetsPlanNode.AllTargetsBindingSetMapper(List.of("subject", "value"), ConstraintComponent.Scope.propertyShape, true, dataGraph), dataGraph);
        if (planNodeWrapper != null) {
            unorderedSelect = (PlanNode)planNodeWrapper.apply(unorderedSelect);
        }
        return connectionsGroup.getCachedNodeFor(unorderedSelect);
    }

    @Override
    public SparqlFragment getTargetQueryFragment(StatementMatcher.Variable subject, StatementMatcher.Variable object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider, Set<String> inheritedVarNames) {
        inheritedVarNames = inheritedVarNames.isEmpty() ? Set.of(subject.getName()) : Sets.union(inheritedVarNames, Set.of(subject.getName()));
        String variablePrefix = this.getVariablePrefix(subject, object);
        ArrayList<SparqlFragment> sparqlFragments = new ArrayList<SparqlFragment>(this.paths.size());
        StatementMatcher.Variable head = subject;
        StatementMatcher.Variable tail = null;
        for (int i = 0; i < this.paths.size(); ++i) {
            if (tail != null) {
                head = tail;
            }
            tail = i + 1 == this.paths.size() ? object : new StatementMatcher.Variable(subject, variablePrefix + i);
            Path path2 = this.paths.get(i);
            SparqlFragment targetQueryFragment = path2.getTargetQueryFragment(head, tail, rdfsSubClassOfReasoner, stableRandomVariableProvider, (Set<String>)inheritedVarNames);
            sparqlFragments.add(targetQueryFragment);
        }
        return SparqlFragment.join(sparqlFragments, (connectionsGroup, dataGraph, path, currentStatementMatcher, currentStatements) -> {
            Stream<EffectiveTarget.StatementsAndMatcher> currentRoot = null;
            for (int i = sparqlFragments.size() - 1; i >= 0; --i) {
                SparqlFragment sparqlFragment = (SparqlFragment)sparqlFragments.get(i);
                currentRoot = currentRoot != null ? currentRoot.flatMap(root -> sparqlFragment.getRoot(connectionsGroup, dataGraph, path, root.getStatementMatcher(), root.getStatements())).filter(EffectiveTarget.StatementsAndMatcher::hasStatements) : sparqlFragment.getRoot(connectionsGroup, dataGraph, path, currentStatementMatcher, currentStatements);
            }
            return currentRoot;
        });
    }

    @Override
    public boolean isSupported() {
        for (Path path : this.paths) {
            if (path.isSupported()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toSparqlPathString() {
        return "(" + this.paths.stream().map(Path::toSparqlPathString).collect(Collectors.joining(" / ")) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SequencePath that = (SequencePath)o;
        return this.paths.equals(that.paths);
    }

    public int hashCode() {
        return this.paths.hashCode();
    }
}

