/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.MutableBindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.ExtensionElem;
import org.eclipse.rdf4j.query.algebra.Group;
import org.eclipse.rdf4j.query.algebra.MultiProjection;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.ProjectionElem;
import org.eclipse.rdf4j.query.algebra.QueryRoot;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.UnaryTupleOperator;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.ZeroLengthPath;
import org.eclipse.rdf4j.query.algebra.evaluation.ArrayBindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryEvaluationContext;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractSimpleQueryModelVisitor;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;

public final class ArrayBindingBasedQueryEvaluationContext
implements QueryEvaluationContext {
    private final QueryEvaluationContext context;
    private final String[] allVariables;
    private final Set<String> allVariablesSet;
    private final ArrayBindingSet defaultArrayBindingSet;
    private final Predicate<BindingSet>[] hasBinding;
    private final Function<BindingSet, Binding>[] getBinding;
    private final Function<BindingSet, Value>[] getValue;
    private final BiConsumer<Value, MutableBindingSet>[] setBinding;
    private final BiConsumer<Value, MutableBindingSet>[] addBinding;
    boolean initialized;

    ArrayBindingBasedQueryEvaluationContext(QueryEvaluationContext context, String[] allVariables) {
        assert (new HashSet<String>(Arrays.asList(allVariables)).size() == allVariables.length);
        this.context = context;
        this.allVariables = allVariables;
        this.allVariablesSet = Set.of(allVariables);
        this.defaultArrayBindingSet = new ArrayBindingSet(allVariables);
        this.hasBinding = new Predicate[allVariables.length];
        this.getBinding = new Function[allVariables.length];
        this.getValue = new Function[allVariables.length];
        this.setBinding = new BiConsumer[allVariables.length];
        this.addBinding = new BiConsumer[allVariables.length];
        for (int i = 0; i < allVariables.length; ++i) {
            this.hasBinding[i] = this.hasBinding(allVariables[i]);
            this.getBinding[i] = this.getBinding(allVariables[i]);
            this.getValue[i] = this.getValue(allVariables[i]);
            this.setBinding[i] = this.setBinding(allVariables[i]);
            this.addBinding[i] = this.addBinding(allVariables[i]);
        }
        this.initialized = true;
    }

    @Override
    public Literal getNow() {
        return this.context.getNow();
    }

    @Override
    public Dataset getDataset() {
        return this.context.getDataset();
    }

    @Override
    public ArrayBindingSet createBindingSet() {
        return new ArrayBindingSet(this.allVariables);
    }

    @Override
    public Predicate<BindingSet> hasBinding(String variableName) {
        if (this.initialized) {
            for (int i = 0; i < this.allVariables.length; ++i) {
                if (this.allVariables[i] != variableName) continue;
                return this.hasBinding[i];
            }
        }
        assert (variableName != null && !variableName.isEmpty());
        Function<ArrayBindingSet, Boolean> directHasVariable = this.defaultArrayBindingSet.getDirectHasBinding(variableName);
        return new HasBinding(variableName, directHasVariable);
    }

    @Override
    public Function<BindingSet, Binding> getBinding(String variableName) {
        if (this.initialized) {
            for (int i = 0; i < this.allVariables.length; ++i) {
                if (this.allVariables[i] != variableName) continue;
                return this.getBinding[i];
            }
        }
        Function<ArrayBindingSet, Binding> directAccessForVariable = this.defaultArrayBindingSet.getDirectGetBinding(variableName);
        return bs -> {
            if (bs.isEmpty()) {
                return null;
            }
            if (bs instanceof ArrayBindingSet) {
                return (Binding)directAccessForVariable.apply((ArrayBindingSet)bs);
            }
            return bs.getBinding(variableName);
        };
    }

    @Override
    public Function<BindingSet, Value> getValue(String variableName) {
        if (this.initialized) {
            for (int i = 0; i < this.allVariables.length; ++i) {
                if (this.allVariables[i] != variableName) continue;
                return this.getValue[i];
            }
        }
        Function<ArrayBindingSet, Value> directAccessForVariable = this.defaultArrayBindingSet.getDirectGetValue(variableName);
        return new ValueGetter(variableName, directAccessForVariable);
    }

    @Override
    public BiConsumer<Value, MutableBindingSet> setBinding(String variableName) {
        if (this.initialized) {
            for (int i = 0; i < this.allVariables.length; ++i) {
                if (this.allVariables[i] != variableName) continue;
                return this.setBinding[i];
            }
        }
        BiConsumer<Value, ArrayBindingSet> directAccessForVariable = this.defaultArrayBindingSet.getDirectSetBinding(variableName);
        return (val, bs) -> {
            if (bs instanceof ArrayBindingSet) {
                directAccessForVariable.accept((Value)val, (ArrayBindingSet)bs);
            } else {
                bs.setBinding(variableName, (Value)val);
            }
        };
    }

    @Override
    public BiConsumer<Value, MutableBindingSet> addBinding(String variableName) {
        if (this.initialized) {
            for (int i = 0; i < this.allVariables.length; ++i) {
                if (this.allVariables[i] != variableName) continue;
                return this.addBinding[i];
            }
        }
        BiConsumer<Value, ArrayBindingSet> wrapped = this.defaultArrayBindingSet.getDirectAddBinding(variableName);
        return (val, bs) -> {
            if (bs instanceof ArrayBindingSet) {
                wrapped.accept((Value)val, (ArrayBindingSet)bs);
            } else {
                bs.addBinding(variableName, (Value)val);
            }
        };
    }

    @Override
    public ArrayBindingSet createBindingSet(BindingSet bindings) {
        if (bindings instanceof ArrayBindingSet) {
            return new ArrayBindingSet((ArrayBindingSet)bindings, this.allVariables);
        }
        if (bindings == EmptyBindingSet.getInstance()) {
            return this.createBindingSet();
        }
        return new ArrayBindingSet(bindings, this.allVariablesSet, this.allVariables);
    }

    public static String[] findAllVariablesUsedInQuery(QueryRoot node) {
        final LinkedHashMap varNames = new LinkedHashMap();
        AbstractSimpleQueryModelVisitor<QueryEvaluationException> queryModelVisitorBase = new AbstractSimpleQueryModelVisitor<QueryEvaluationException>(true){

            @Override
            public void meet(Var node) throws QueryEvaluationException {
                super.meet(node);
                if (!node.isConstant() || !(node.getParentNode() instanceof StatementPattern)) {
                    Var replacement = new Var(varNames.computeIfAbsent(node.getName(), k -> k), node.getValue(), node.isAnonymous(), node.isConstant());
                    node.replaceWith(replacement);
                }
            }

            @Override
            public void meet(ProjectionElem node) throws QueryEvaluationException {
                super.meet(node);
                node.setName(varNames.computeIfAbsent(node.getName(), k -> k));
                node.setProjectionAlias(varNames.computeIfAbsent(node.getProjectionAlias().orElse(null), k -> k));
            }

            @Override
            protected void meetUnaryTupleOperator(UnaryTupleOperator node) throws QueryEvaluationException {
                if (node instanceof Projection) {
                    node.getArg().visit(this);
                    ((Projection)node).getProjectionElemList().visit(this);
                } else {
                    node.visitChildren(this);
                }
            }

            @Override
            public void meet(MultiProjection node) throws QueryEvaluationException {
                for (String bindingName : node.getBindingNames()) {
                    varNames.computeIfAbsent(bindingName, k -> k);
                }
                super.meet(node);
            }

            @Override
            public void meet(ZeroLengthPath node) throws QueryEvaluationException {
                varNames.computeIfAbsent("zero-length-internal-start", k -> k);
                varNames.computeIfAbsent("zero-length-internal-pred", k -> k);
                varNames.computeIfAbsent("zero-length-internal-end", k -> k);
                varNames.computeIfAbsent("zero-length-internal-seq", k -> k);
                super.meet(node);
            }

            @Override
            public void meet(ExtensionElem node) throws QueryEvaluationException {
                node.setName(varNames.computeIfAbsent(node.getName(), k -> k));
                super.meet(node);
            }

            @Override
            public void meet(Group node) throws QueryEvaluationException {
                List<String> collect = node.getGroupBindingNames().stream().map(varName -> varNames.computeIfAbsent(varName, k -> k)).collect(Collectors.toList());
                node.setGroupBindingNames(collect);
                super.meet(node);
            }
        };
        node.visit(queryModelVisitorBase);
        return ((HashMap)varNames).keySet().toArray(new String[0]);
    }

    private static class ValueGetter
    implements Function<BindingSet, Value> {
        private final String variableName;
        private final Function<ArrayBindingSet, Value> directAccessForVariable;

        public ValueGetter(String variableName, Function<ArrayBindingSet, Value> directAccessForVariable) {
            this.variableName = variableName;
            this.directAccessForVariable = directAccessForVariable;
        }

        @Override
        public Value apply(BindingSet bs) {
            if (bs.isEmpty()) {
                return null;
            }
            if (bs instanceof ArrayBindingSet) {
                return this.directAccessForVariable.apply((ArrayBindingSet)bs);
            }
            return bs.getValue(this.variableName);
        }
    }

    private static class HasBinding
    implements Predicate<BindingSet> {
        private final String variableName;
        private final Function<ArrayBindingSet, Boolean> directHasVariable;

        public HasBinding(String variableName, Function<ArrayBindingSet, Boolean> directHasVariable) {
            this.variableName = variableName;
            this.directHasVariable = directHasVariable;
        }

        @Override
        public boolean test(BindingSet bs) {
            if (bs.isEmpty()) {
                return false;
            }
            if (bs instanceof ArrayBindingSet) {
                return this.directHasVariable.apply((ArrayBindingSet)bs);
            }
            return bs.hasBinding(this.variableName);
        }
    }
}

