/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.helpers;

import java.io.File;
import java.util.List;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolverClient;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.StackableSail;

public class SailWrapper
implements StackableSail,
FederatedServiceResolverClient {
    private Sail baseSail;

    public SailWrapper() {
    }

    public SailWrapper(Sail baseSail) {
        this.setBaseSail(baseSail);
    }

    @Override
    public void setBaseSail(Sail baseSail) {
        this.baseSail = baseSail;
    }

    @Override
    public Sail getBaseSail() {
        return this.baseSail;
    }

    protected void verifyBaseSailSet() {
        if (this.baseSail == null) {
            throw new IllegalStateException("No base Sail has been set");
        }
    }

    @Override
    public void setFederatedServiceResolver(FederatedServiceResolver resolver) {
        if (this.baseSail instanceof FederatedServiceResolverClient) {
            ((FederatedServiceResolverClient)((Object)this.baseSail)).setFederatedServiceResolver(resolver);
        }
    }

    @Override
    public File getDataDir() {
        return this.baseSail.getDataDir();
    }

    @Override
    public void setDataDir(File dataDir) {
        this.baseSail.setDataDir(dataDir);
    }

    @Override
    public void init() throws SailException {
        this.verifyBaseSailSet();
        this.baseSail.init();
    }

    @Override
    public void shutDown() throws SailException {
        this.verifyBaseSailSet();
        this.baseSail.shutDown();
    }

    @Override
    public boolean isWritable() throws SailException {
        this.verifyBaseSailSet();
        return this.baseSail.isWritable();
    }

    @Override
    public SailConnection getConnection() throws SailException {
        this.verifyBaseSailSet();
        return this.baseSail.getConnection();
    }

    @Override
    public ValueFactory getValueFactory() {
        this.verifyBaseSailSet();
        return this.baseSail.getValueFactory();
    }

    @Override
    public List<IsolationLevel> getSupportedIsolationLevels() {
        this.verifyBaseSailSet();
        return this.baseSail.getSupportedIsolationLevels();
    }

    @Override
    public IsolationLevel getDefaultIsolationLevel() {
        this.verifyBaseSailSet();
        return this.baseSail.getDefaultIsolationLevel();
    }
}

