/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.helpers;

import java.lang.ref.Cleaner;
import org.eclipse.rdf4j.common.concurrent.locks.diagnostics.ConcurrentCleaner;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CleanerIteration<E, X extends Exception>
implements CloseableIteration<E, X> {
    private static final Logger logger = LoggerFactory.getLogger(CleanerIteration.class);
    private final CloseableIteration<E, X> delegate;
    private final Cleaner.Cleanable cleanable;
    private final CleanableState<E, X> state;

    public CleanerIteration(CloseableIteration<E, X> delegate, ConcurrentCleaner cleaner) {
        this.delegate = delegate;
        this.state = new CleanableState<E, X>(delegate);
        this.cleanable = cleaner.register(this, this.state);
    }

    @Override
    public void close() throws X {
        this.state.close();
        this.cleanable.clean();
    }

    @Override
    public boolean hasNext() throws X {
        return this.delegate.hasNext();
    }

    @Override
    public E next() throws X {
        return this.delegate.next();
    }

    @Override
    public void remove() throws X {
        this.delegate.remove();
    }

    private static final class CleanableState<E, X extends Exception>
    implements Runnable {
        private final CloseableIteration<E, X> iteration;
        private boolean closed = false;

        public CleanableState(CloseableIteration<E, X> iteration) {
            this.iteration = iteration;
        }

        @Override
        public void run() {
            if (!this.closed) {
                try {
                    logger.warn("Forced closing of unclosed iteration. Set the system property 'org.eclipse.rdf4j.repository.debug' to 'true' to get stack traces.");
                    this.iteration.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public void close() throws X {
            this.closed = true;
            this.iteration.close();
        }
    }
}

