/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.panama;

import java.util.Arrays;
import javax.annotation.Nullable;
import jdk.incubator.foreign.MemorySegment;
import jdk.incubator.foreign.ResourceScope;
import org.lwjgl.panama.Test;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class MemoryStackPanama
extends Pointer.Default
implements AutoCloseable {
    private static final int DEFAULT_STACK_SIZE = Configuration.STACK_SIZE.get(64) * 1024;
    private static final int DEFAULT_STACK_FRAMES = 8;
    private static final ThreadLocal<MemoryStackPanama> TLS = ThreadLocal.withInitial(MemoryStackPanama::create);
    @Nullable
    private final MemorySegment container;
    private final int size;
    private int pointer;
    private int[] frames;
    protected int frameIndex;

    protected MemoryStackPanama(@Nullable MemorySegment container, long address, long size) {
        super(address);
        this.container = container;
        this.size = (int)size;
        this.pointer = (int)size;
        this.frames = new int[8];
    }

    public static MemoryStackPanama create() {
        return MemoryStackPanama.create(DEFAULT_STACK_SIZE);
    }

    public static MemoryStackPanama create(int capacity) {
        return MemoryStackPanama.create(MemorySegment.allocateNative((long)capacity, (ResourceScope)ResourceScope.globalScope()));
    }

    public static MemoryStackPanama create(MemorySegment buffer) {
        long address = buffer.address().toRawLongValue();
        long size = buffer.byteSize();
        return new MemoryStackPanama(buffer, address, size);
    }

    public static MemoryStackPanama ncreate(long address, int size) {
        return new MemoryStackPanama(null, address, size);
    }

    public MemoryStackPanama push() {
        if (this.frameIndex == this.frames.length) {
            this.frameOverflow();
        }
        this.frames[this.frameIndex++] = this.pointer;
        return this;
    }

    private void frameOverflow() {
        if (Checks.DEBUG) {
            APIUtil.apiLog("[WARNING] Out of frame stack space (" + this.frames.length + ") in thread: " + String.valueOf(Thread.currentThread()));
        }
        this.frames = Arrays.copyOf(this.frames, this.frames.length * 3 / 2);
    }

    public MemoryStackPanama pop() {
        this.pointer = this.frames[--this.frameIndex];
        return this;
    }

    @Override
    public void close() {
        this.pop();
    }

    public long getAddress() {
        return this.address;
    }

    public int getSize() {
        return this.size;
    }

    public int getFrameIndex() {
        return this.frameIndex;
    }

    public long getPointerAddress() {
        return this.address + ((long)this.pointer & 0xFFFFFFFFL);
    }

    public int getPointer() {
        return this.pointer;
    }

    public void setPointer(int pointer) {
        if (Checks.CHECKS) {
            this.checkPointer(pointer);
        }
        this.pointer = pointer;
    }

    private void checkPointer(int pointer) {
        if (pointer < 0 || this.size < pointer) {
            throw new IndexOutOfBoundsException("Invalid stack pointer");
        }
    }

    private static void checkAlignment(int alignment) {
        if (Integer.bitCount(alignment) != 1) {
            throw new IllegalArgumentException("Alignment must be a power-of-two value.");
        }
    }

    public long nmalloc(int size) {
        return this.nmalloc(1, size);
    }

    public long nmalloc(int alignment, int size) {
        long address = this.address + (long)this.pointer - (long)size & (Integer.toUnsignedLong(alignment - 1) ^ 0xFFFFFFFFFFFFFFFFL);
        this.pointer = (int)(address - this.address);
        if (Checks.CHECKS && this.pointer < 0) {
            throw new OutOfMemoryError("Out of stack space.");
        }
        return address;
    }

    public long ncalloc(int alignment, int num, int size) {
        int bytes = num * size;
        long address = this.nmalloc(alignment, bytes);
        MemoryUtil.memSet(address, 0, bytes);
        return address;
    }

    public MemorySegment malloc(int alignment, int size) {
        if (Checks.DEBUG) {
            MemoryStackPanama.checkAlignment(alignment);
        }
        return Test.wrap(this.nmalloc(alignment, size), size);
    }

    public MemorySegment calloc(int alignment, int size) {
        if (Checks.DEBUG) {
            MemoryStackPanama.checkAlignment(alignment);
        }
        return Test.wrap(this.ncalloc(alignment, size, 1), size);
    }

    public MemorySegment malloc(int size) {
        return Test.wrap(this.nmalloc(1, size), size);
    }

    public MemorySegment calloc(int size) {
        return Test.wrap(this.ncalloc(1, size, 1), size);
    }

    public MemorySegment ASCII(CharSequence text) {
        return this.ASCII(text, true);
    }

    public MemorySegment ASCII(CharSequence text, boolean nullTerminated) {
        int length = MemoryUtil.memLengthASCII(text, nullTerminated);
        long target = this.nmalloc(1, length);
        MemoryUtil.encodeASCIIUnsafe(text, nullTerminated, target);
        return Test.wrap(target, length);
    }

    public int nASCII(CharSequence text, boolean nullTerminated) {
        long target = this.nmalloc(1, MemoryUtil.memLengthASCII(text, nullTerminated));
        return MemoryUtil.encodeASCIIUnsafe(text, nullTerminated, target);
    }

    @Nullable
    public MemorySegment ASCIISafe(@Nullable CharSequence text) {
        return this.ASCIISafe(text, true);
    }

    @Nullable
    public MemorySegment ASCIISafe(@Nullable CharSequence text, boolean nullTerminated) {
        return text == null ? null : this.ASCII(text, nullTerminated);
    }

    public int nASCIISafe(@Nullable CharSequence text, boolean nullTerminated) {
        return text == null ? 0 : this.nASCII(text, nullTerminated);
    }

    public MemorySegment UTF8(CharSequence text) {
        return this.UTF8(text, true);
    }

    public MemorySegment UTF8(CharSequence text, boolean nullTerminated) {
        int length = MemoryUtil.memLengthUTF8(text, nullTerminated);
        long target = this.nmalloc(1, length);
        MemoryUtil.encodeUTF8Unsafe(text, nullTerminated, target);
        return Test.wrap(target, length);
    }

    public int nUTF8(CharSequence text, boolean nullTerminated) {
        long target = this.nmalloc(1, MemoryUtil.memLengthUTF8(text, nullTerminated));
        return MemoryUtil.encodeUTF8Unsafe(text, nullTerminated, target);
    }

    @Nullable
    public MemorySegment UTF8Safe(@Nullable CharSequence text) {
        return this.UTF8Safe(text, true);
    }

    @Nullable
    public MemorySegment UTF8Safe(@Nullable CharSequence text, boolean nullTerminated) {
        return text == null ? null : this.UTF8(text, nullTerminated);
    }

    public int nUTF8Safe(@Nullable CharSequence text, boolean nullTerminated) {
        return text == null ? 0 : this.nUTF8(text, nullTerminated);
    }

    public MemorySegment UTF16(CharSequence text) {
        return this.UTF16(text, true);
    }

    public MemorySegment UTF16(CharSequence text, boolean nullTerminated) {
        int length = MemoryUtil.memLengthUTF16(text, nullTerminated);
        long target = this.nmalloc(2, length);
        MemoryUtil.encodeUTF16Unsafe(text, nullTerminated, target);
        return Test.wrap(target, length);
    }

    public int nUTF16(CharSequence text, boolean nullTerminated) {
        long target = this.nmalloc(2, MemoryUtil.memLengthUTF16(text, nullTerminated));
        return MemoryUtil.encodeUTF16Unsafe(text, nullTerminated, target);
    }

    @Nullable
    public MemorySegment UTF16Safe(@Nullable CharSequence text) {
        return this.UTF16Safe(text, true);
    }

    @Nullable
    public MemorySegment UTF16Safe(@Nullable CharSequence text, boolean nullTerminated) {
        return text == null ? null : this.UTF16(text, nullTerminated);
    }

    public int nUTF16Safe(@Nullable CharSequence text, boolean nullTerminated) {
        return text == null ? 0 : this.nUTF16(text, nullTerminated);
    }

    public static MemoryStackPanama stackGet() {
        return TLS.get();
    }

    public static MemoryStackPanama stackPush() {
        return MemoryStackPanama.stackGet().push();
    }

    public static MemoryStackPanama stackPop() {
        return MemoryStackPanama.stackGet().pop();
    }

    static {
        if (DEFAULT_STACK_SIZE < 0) {
            throw new IllegalStateException("Invalid stack size.");
        }
    }
}

