/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory.model;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.GenericStatement;
import org.eclipse.rdf4j.sail.memory.model.MemIRI;
import org.eclipse.rdf4j.sail.memory.model.MemResource;
import org.eclipse.rdf4j.sail.memory.model.MemValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemStatement
extends GenericStatement<MemResource, MemIRI, MemValue> {
    private static final Logger logger = LoggerFactory.getLogger(MemStatement.class);
    private static final long serialVersionUID = -3073275483628334134L;
    private final boolean explicit;
    private final int sinceSnapshot;
    private volatile int tillSnapshot = Integer.MAX_VALUE;
    private static final VarHandle TILL_SNAPSHOT;

    public MemStatement(MemResource subject, MemIRI predicate, MemValue object, MemResource context, int sinceSnapshot) {
        this(subject, predicate, object, context, true, sinceSnapshot);
    }

    public MemStatement(MemResource subject, MemIRI predicate, MemValue object, MemResource context, boolean explicit, int sinceSnapshot) {
        super((Resource)subject, (IRI)predicate, (Value)object, (Resource)context);
        this.explicit = explicit;
        this.sinceSnapshot = sinceSnapshot;
    }

    public int getSinceSnapshot() {
        return this.sinceSnapshot;
    }

    public void setTillSnapshot(int snapshot) {
        TILL_SNAPSHOT.setRelease(this, snapshot);
    }

    public int getTillSnapshot() {
        return TILL_SNAPSHOT.getAcquire(this);
    }

    public boolean isInSnapshot(int snapshot) {
        return snapshot >= this.sinceSnapshot && snapshot < TILL_SNAPSHOT.getAcquire(this);
    }

    @Deprecated(since="4.0.0", forRemoval=true)
    public void setExplicit(boolean explicit) {
        logger.warn("The explicit field has been set to final for improved performance. Java reflection will be used to modify it. Take note that the MemorySailStore will not detect this change and may assume that it doesn't have any inferred statements!");
        try {
            Field explicitField = MemStatement.class.getDeclaredField("explicit");
            explicitField.setAccessible(true);
            explicitField.set((Object)this, explicit);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    public void addToComponentLists() throws InterruptedException {
        ((MemResource)this.getSubject()).addSubjectStatement(this);
        ((MemIRI)this.getPredicate()).addPredicateStatement(this);
        ((MemValue)this.getObject()).addObjectStatement(this);
        MemResource context = (MemResource)this.getContext();
        if (context != null) {
            context.addContextStatement(this);
        }
    }

    public boolean matchesSPO(MemResource subject, MemIRI predicate, MemValue object) {
        return !(object != null && object != this.object || subject != null && subject != this.subject || predicate != null && predicate != this.predicate);
    }

    public boolean matchesContext(MemResource[] memContexts) {
        if (memContexts != null && memContexts.length > 0) {
            for (MemResource context : memContexts) {
                if (context != this.context) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean exactMatch(MemResource subject, MemIRI predicate, MemValue object, MemResource context) {
        return this.subject == subject && this.predicate == predicate && this.object == object && this.context == context;
    }

    static {
        try {
            TILL_SNAPSHOT = MethodHandles.lookup().in(MemStatement.class).findVarHandle(MemStatement.class, "tillSnapshot", Integer.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new Error(e);
        }
    }
}

