/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.manager;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.http.client.HttpClient;
import org.eclipse.rdf4j.http.client.HttpClientDependent;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.ModelFactory;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.impl.TreeModelFactory;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResolver;
import org.eclipse.rdf4j.repository.config.RepositoryConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.manager.RepositoryInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RepositoryManager
implements RepositoryResolver,
HttpClientDependent {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String NAMESPACE = "http://www.openrdf.org/config/repository/proxy#";
    public static final IRI PROXIED_ID = SimpleValueFactory.getInstance().createIRI("http://www.openrdf.org/config/repository/proxy#", "proxiedID");
    private ModelFactory modelFactory = new TreeModelFactory();
    protected Map<String, Repository> initializedRepositories;
    private boolean initialized;

    protected RepositoryManager() {
        this(new HashMap<String, Repository>());
    }

    protected RepositoryManager(Map<String, Repository> initializedRepositories) {
        this.setInitializedRepositories(initializedRepositories);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public abstract HttpClient getHttpClient();

    public abstract void setHttpClient(HttpClient var1);

    public ModelFactory getModelFactory() {
        return this.modelFactory;
    }

    public void setModelFactory(ModelFactory modelFactory) {
        Objects.requireNonNull(modelFactory);
        this.modelFactory = modelFactory;
    }

    public void init() throws RepositoryException {
        this.initialized = true;
    }

    public String getNewRepositoryID(String baseName) throws RepositoryException, RepositoryConfigException {
        if (baseName != null) {
            baseName = ((String)baseName).trim();
            int length = ((String)baseName).length();
            StringBuilder buffer = new StringBuilder(length);
            for (char c : ((String)baseName).toCharArray()) {
                if (Character.isLetter(c) || Character.isDigit(c) || c == '-' || c == '_' || c == '.') {
                    buffer.append(Character.toLowerCase(c));
                    continue;
                }
                if (c == '\"' || c == '\'') continue;
                buffer.append('-');
            }
            baseName = buffer.toString();
        }
        if (baseName != null && ((String)baseName).length() > 0 && !this.hasRepositoryConfig((String)baseName)) {
            return baseName;
        }
        if (baseName == null || ((String)baseName).length() == 0) {
            baseName = "repository-";
        } else if (!((String)baseName).endsWith("-")) {
            baseName = (String)baseName + "-";
        }
        int index = 2;
        while (this.hasRepositoryConfig((String)baseName + index)) {
            ++index;
        }
        return (String)baseName + index;
    }

    public Set<String> getRepositoryIDs() throws RepositoryException {
        LinkedHashSet<String> idSet = new LinkedHashSet<String>();
        this.getAllRepositoryInfos().forEach(info -> idSet.add(info.getId()));
        return idSet;
    }

    public boolean hasRepositoryConfig(String repositoryID) throws RepositoryException, RepositoryConfigException {
        return this.getRepositoryInfo(repositoryID) != null;
    }

    public abstract RepositoryConfig getRepositoryConfig(String var1) throws RepositoryConfigException, RepositoryException;

    public abstract void addRepositoryConfig(RepositoryConfig var1) throws RepositoryException, RepositoryConfigException;

    public boolean isSafeToRemove(String repositoryID) throws RepositoryException {
        for (String id : this.getRepositoryIDs()) {
            RepositoryConfig config = this.getRepositoryConfig(id);
            LinkedHashModel model = new LinkedHashModel();
            config.export((Model)model, (Resource)Values.bnode());
            if (!model.contains(null, PROXIED_ID, (Value)Values.literal((String)repositoryID), new Resource[0])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRepository(String repositoryID) throws RepositoryException, RepositoryConfigException {
        this.logger.debug("Removing repository {}.", (Object)repositoryID);
        boolean isRemoved = this.hasRepositoryConfig(repositoryID);
        Map<String, Repository> map = this.initializedRepositories;
        synchronized (map) {
            if (isRemoved) {
                this.logger.debug("Shutdown repository {} after removal of configuration.", (Object)repositoryID);
                Repository repository = this.initializedRepositories.remove(repositoryID);
                if (repository != null && repository.isInitialized()) {
                    repository.shutDown();
                }
            }
        }
        return isRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Repository getRepository(String identity) throws RepositoryConfigException, RepositoryException {
        Map<String, Repository> map = this.initializedRepositories;
        synchronized (map) {
            this.updateInitializedRepositories();
            Repository result = this.initializedRepositories.get(identity);
            if (result != null && !result.isInitialized()) {
                this.initializedRepositories.remove(identity);
                result = null;
            }
            if (result == null && (result = this.createRepository(identity)) != null) {
                this.initializedRepositories.put(identity, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getInitializedRepositoryIDs() {
        Map<String, Repository> map = this.initializedRepositories;
        synchronized (map) {
            this.updateInitializedRepositories();
            return new HashSet<String>(this.initializedRepositories.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Repository> getInitializedRepositories() {
        Map<String, Repository> map = this.initializedRepositories;
        synchronized (map) {
            this.updateInitializedRepositories();
            return new ArrayList<Repository>(this.initializedRepositories.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Repository getInitializedRepository(String repositoryID) {
        Map<String, Repository> map = this.initializedRepositories;
        synchronized (map) {
            this.updateInitializedRepositories();
            return this.initializedRepositories.get(repositoryID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Repository removeInitializedRepository(String repositoryID) {
        Map<String, Repository> map = this.initializedRepositories;
        synchronized (map) {
            this.updateInitializedRepositories();
            return this.initializedRepositories.remove(repositoryID);
        }
    }

    protected void setInitializedRepositories(Map<String, Repository> nextInitializedRepositories) {
        this.initializedRepositories = nextInitializedRepositories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateInitializedRepositories() {
        Map<String, Repository> map = this.initializedRepositories;
        synchronized (map) {
            Iterator<Repository> iter = this.initializedRepositories.values().iterator();
            while (iter.hasNext()) {
                Repository next = iter.next();
                if (next.isInitialized()) continue;
                iter.remove();
                try {
                    next.shutDown();
                }
                catch (RepositoryException repositoryException) {}
            }
        }
    }

    public Collection<Repository> getAllRepositories() throws RepositoryConfigException, RepositoryException {
        Set<String> idSet = this.getRepositoryIDs();
        ArrayList<Repository> result = new ArrayList<Repository>(idSet.size());
        for (String id : idSet) {
            result.add(this.getRepository(id));
        }
        return result;
    }

    protected abstract Repository createRepository(String var1) throws RepositoryConfigException, RepositoryException;

    public RepositoryInfo getRepositoryInfo(String id) throws RepositoryException {
        for (RepositoryInfo repInfo : this.getAllRepositoryInfos()) {
            if (!repInfo.getId().equals(id)) continue;
            return repInfo;
        }
        return null;
    }

    public abstract Collection<RepositoryInfo> getAllRepositoryInfos() throws RepositoryException;

    @Deprecated
    public Collection<RepositoryInfo> getAllUserRepositoryInfos() throws RepositoryException {
        return this.getAllRepositoryInfos();
    }

    @Deprecated
    public Collection<RepositoryInfo> getAllRepositoryInfos(boolean skipSystemRepo) throws RepositoryException {
        return this.getAllRepositoryInfos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        this.logger.debug("Refreshing repository information in manager...");
        try {
            Map<String, Repository> map = this.initializedRepositories;
            synchronized (map) {
                Iterator<Map.Entry<String, Repository>> iter = this.initializedRepositories.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<String, Repository> entry = iter.next();
                    String repositoryID = entry.getKey();
                    Repository repository = entry.getValue();
                    iter.remove();
                    this.refreshRepository(repositoryID, repository);
                }
            }
        }
        catch (RepositoryException re) {
            this.logger.error("Failed to refresh repositories", (Throwable)re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        Map<String, Repository> map = this.initializedRepositories;
        synchronized (map) {
            this.updateInitializedRepositories();
            for (Repository repository : this.initializedRepositories.values()) {
                try {
                    if (!repository.isInitialized()) continue;
                    repository.shutDown();
                }
                catch (RepositoryException e) {
                    this.logger.error("Repository shut down failed", (Throwable)e);
                }
            }
            this.initializedRepositories.clear();
            this.initialized = false;
        }
    }

    void refreshRepository(String repositoryID, Repository repository) {
        this.logger.debug("Refreshing repository {}...", (Object)repositoryID);
        try {
            if (repository.isInitialized()) {
                repository.shutDown();
            }
        }
        catch (RepositoryException e) {
            this.logger.error("Failed to shut down repository", (Throwable)e);
        }
    }

    public abstract URL getLocation() throws MalformedURLException;
}

