/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.wrapper.data;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.Stats;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.BufferedSplitter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnBufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnorderedSelect;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.RdfsSubClassOfReasoner;

@InternalUseOnly
public class ConnectionsGroup
implements AutoCloseable {
    private final SailConnection baseConnection;
    private final SailConnection previousStateConnection;
    private final SailConnection addedStatements;
    private final SailConnection removedStatements;
    private final ShaclSailConnection.Settings transactionSettings;
    private final Stats stats;
    private final RdfsSubClassOfReasonerProvider rdfsSubClassOfReasonerProvider;
    private final boolean sparqlValidation;
    private final Map<PlanNode, BufferedSplitter> nodeCache = new HashMap<PlanNode, BufferedSplitter>();

    public ConnectionsGroup(SailConnection baseConnection, SailConnection previousStateConnection, Sail addedStatements, Sail removedStatements, Stats stats, RdfsSubClassOfReasonerProvider rdfsSubClassOfReasonerProvider, ShaclSailConnection.Settings transactionSettings, boolean sparqlValidation) {
        this.baseConnection = baseConnection;
        this.previousStateConnection = previousStateConnection;
        this.stats = stats;
        this.rdfsSubClassOfReasonerProvider = rdfsSubClassOfReasonerProvider;
        this.transactionSettings = transactionSettings;
        this.sparqlValidation = sparqlValidation;
        if (addedStatements != null) {
            this.addedStatements = addedStatements.getConnection();
            this.addedStatements.begin(IsolationLevels.NONE);
        } else {
            this.addedStatements = null;
        }
        if (removedStatements != null) {
            this.removedStatements = removedStatements.getConnection();
            this.removedStatements.begin(IsolationLevels.NONE);
        } else {
            this.removedStatements = null;
        }
    }

    public SailConnection getPreviousStateConnection() {
        return this.previousStateConnection;
    }

    public SailConnection getAddedStatements() {
        return this.addedStatements;
    }

    public SailConnection getRemovedStatements() {
        return this.removedStatements;
    }

    @Override
    public void close() {
        if (this.addedStatements != null) {
            this.addedStatements.commit();
            this.addedStatements.close();
        }
        if (this.removedStatements != null) {
            this.removedStatements.commit();
            this.removedStatements.close();
        }
        this.nodeCache.clear();
    }

    public SailConnection getBaseConnection() {
        return this.baseConnection;
    }

    public synchronized PlanNode getCachedNodeFor(PlanNode planNode) {
        if (!this.transactionSettings.isCacheSelectNodes()) {
            return planNode;
        }
        if (planNode instanceof UnorderedSelect || planNode instanceof UnBufferedPlanNode) {
            return planNode;
        }
        BufferedSplitter bufferedSplitter = this.nodeCache.computeIfAbsent(planNode, BufferedSplitter::new);
        return bufferedSplitter.getPlanNode();
    }

    public RdfsSubClassOfReasoner getRdfsSubClassOfReasoner() {
        return this.rdfsSubClassOfReasonerProvider.getRdfsSubClassOfReasoner();
    }

    public Stats getStats() {
        return this.stats;
    }

    public ShaclSailConnection.Settings getTransactionSettings() {
        return this.transactionSettings;
    }

    public boolean isSparqlValidation() {
        return this.sparqlValidation;
    }

    public static interface RdfsSubClassOfReasonerProvider {
        public RdfsSubClassOfReasoner getRdfsSubClassOfReasoner();
    }
}

