/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.rdf4j.common.concurrent.locks.Lock;
import org.eclipse.rdf4j.common.concurrent.locks.LockingIteration;
import org.eclipse.rdf4j.common.concurrent.locks.ReadPrefReadWriteLockManager;
import org.eclipse.rdf4j.common.concurrent.locks.ReadWriteLockManager;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteratorIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleNamespace;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.EvaluationStatistics;
import org.eclipse.rdf4j.sail.SailConflictException;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.base.BackingSailSource;
import org.eclipse.rdf4j.sail.base.SailDataset;
import org.eclipse.rdf4j.sail.base.SailSink;
import org.eclipse.rdf4j.sail.base.SailSource;
import org.eclipse.rdf4j.sail.base.SailStore;
import org.eclipse.rdf4j.sail.memory.MemEvaluationStatistics;
import org.eclipse.rdf4j.sail.memory.MemNamespaceStore;
import org.eclipse.rdf4j.sail.memory.MemTripleIterator;
import org.eclipse.rdf4j.sail.memory.model.MemBNode;
import org.eclipse.rdf4j.sail.memory.model.MemIRI;
import org.eclipse.rdf4j.sail.memory.model.MemResource;
import org.eclipse.rdf4j.sail.memory.model.MemStatement;
import org.eclipse.rdf4j.sail.memory.model.MemStatementIterator;
import org.eclipse.rdf4j.sail.memory.model.MemStatementIteratorCache;
import org.eclipse.rdf4j.sail.memory.model.MemStatementList;
import org.eclipse.rdf4j.sail.memory.model.MemTriple;
import org.eclipse.rdf4j.sail.memory.model.MemValue;
import org.eclipse.rdf4j.sail.memory.model.MemValueFactory;
import org.eclipse.rdf4j.sail.memory.model.WeakObjectRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MemorySailStore
implements SailStore {
    public static final EmptyIteration<MemStatement, SailException> EMPTY_ITERATION = new EmptyIteration();
    public static final EmptyIteration<MemTriple, SailException> EMPTY_TRIPLE_ITERATION = new EmptyIteration();
    public static final MemResource[] EMPTY_CONTEXT = new MemResource[0];
    private static final Logger logger = LoggerFactory.getLogger(MemorySailStore.class);
    private final MemStatementIteratorCache iteratorCache = new MemStatementIteratorCache(10);
    private final MemValueFactory valueFactory = new MemValueFactory();
    private final MemStatementList statements = new MemStatementList(256);
    private volatile boolean mayHaveInferred = false;
    private volatile int currentSnapshot;
    private final MemNamespaceStore namespaceStore = new MemNamespaceStore();
    private final ReadWriteLockManager statementListLockManager;
    private final ReentrantLock txnLockManager = new ReentrantLock();
    private volatile Thread snapshotCleanupThread;
    private final Object snapshotCleanupThreadLockObject = new Object();

    public MemorySailStore(boolean debug) {
        this.statementListLockManager = new ReadPrefReadWriteLockManager(debug);
    }

    @Override
    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    @Override
    public void close() {
        try {
            Lock stLock = this.statementListLockManager.getWriteLock();
            try {
                this.valueFactory.clear();
                this.statements.clear();
                this.invalidateCache();
            }
            finally {
                stLock.release();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void invalidateCache() {
        this.iteratorCache.invalidateCache();
    }

    @Override
    public EvaluationStatistics getEvaluationStatistics() {
        return new MemEvaluationStatistics(this.valueFactory, this.statements);
    }

    @Override
    public SailSource getExplicitSailSource() {
        return new MemorySailSource(true);
    }

    @Override
    public SailSource getInferredSailSource() {
        return new MemorySailSource(false);
    }

    private Lock openStatementsReadLock() throws SailException {
        try {
            return this.statementListLockManager.getReadLock();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SailException(e);
        }
    }

    private CloseableIteration<MemStatement, SailException> createStatementIterator(Resource subj, IRI pred, Value obj, Boolean explicit, int snapshot, Resource ... contexts) {
        MemStatementList smallestList;
        MemResource[] memContexts;
        MemResource memSubj = this.valueFactory.getMemResource(subj);
        if (subj != null && memSubj == null) {
            return EMPTY_ITERATION;
        }
        MemIRI memPred = this.valueFactory.getMemURI(pred);
        if (pred != null && memPred == null) {
            return EMPTY_ITERATION;
        }
        MemValue memObj = this.valueFactory.getMemValue(obj);
        if (obj != null && memObj == null) {
            return EMPTY_ITERATION;
        }
        if (contexts.length == 0) {
            memContexts = EMPTY_CONTEXT;
            smallestList = this.statements;
        } else if (contexts.length == 1 && contexts[0] != null) {
            MemResource memContext = this.valueFactory.getMemResource(contexts[0]);
            if (memContext == null) {
                return EMPTY_ITERATION;
            }
            memContexts = new MemResource[]{memContext};
            smallestList = memContext.getContextStatementList();
        } else {
            LinkedHashSet<MemResource> contextSet = new LinkedHashSet<MemResource>(2 * contexts.length);
            for (Resource context : contexts) {
                MemResource memContext = this.valueFactory.getMemResource(context);
                if (context != null && memContext == null) continue;
                contextSet.add(memContext);
            }
            if (contextSet.isEmpty()) {
                return EMPTY_ITERATION;
            }
            memContexts = contextSet.toArray(new MemResource[contextSet.size()]);
            smallestList = this.statements;
        }
        return this.getMemStatementIterator(memSubj, memPred, memObj, explicit, snapshot, memContexts, smallestList);
    }

    private CloseableIteration<MemStatement, SailException> createStatementIterator(MemResource subj, MemIRI pred, MemValue obj, Boolean explicit, int snapshot, MemResource ... contexts) {
        MemStatementList smallestList;
        MemResource[] memContexts;
        if (contexts.length == 0) {
            memContexts = EMPTY_CONTEXT;
            smallestList = this.statements;
        } else if (contexts.length == 1 && contexts[0] != null) {
            memContexts = contexts;
            smallestList = contexts[0].getContextStatementList();
        } else {
            memContexts = contexts;
            smallestList = this.statements;
        }
        return this.getMemStatementIterator(subj, pred, obj, explicit, snapshot, memContexts, smallestList);
    }

    private CloseableIteration<MemStatement, SailException> getMemStatementIterator(MemResource subj, MemIRI pred, MemValue obj, Boolean explicit, int snapshot, MemResource[] memContexts, MemStatementList statementList) {
        MemStatementList l;
        if (explicit != null && !explicit.booleanValue() && !this.mayHaveInferred) {
            return EMPTY_ITERATION;
        }
        MemStatementList smallestList = statementList;
        if (subj != null && (l = subj.getSubjectStatementList()).size() < smallestList.size()) {
            smallestList = l;
        }
        if (pred != null && (l = pred.getPredicateStatementList()).size() < smallestList.size()) {
            smallestList = l;
        }
        if (obj != null && (l = obj.getObjectStatementList()).size() < smallestList.size()) {
            smallestList = l;
        }
        if (smallestList.isEmpty()) {
            return EMPTY_ITERATION;
        }
        return MemStatementIterator.cacheAwareInstance(smallestList, subj, pred, obj, explicit, snapshot, memContexts, this.iteratorCache);
    }

    private CloseableIteration<MemTriple, SailException> createTripleIterator(Resource subj, IRI pred, Value obj, int snapshot) {
        MemResource memSubj = this.valueFactory.getMemResource(subj);
        if (subj != null && memSubj == null) {
            return EMPTY_TRIPLE_ITERATION;
        }
        MemIRI memPred = this.valueFactory.getMemURI(pred);
        if (pred != null && memPred == null) {
            return EMPTY_TRIPLE_ITERATION;
        }
        MemValue memObj = this.valueFactory.getMemValue(obj);
        if (obj != null && memObj == null) {
            return EMPTY_TRIPLE_ITERATION;
        }
        return new MemTripleIterator<SailException>(this.statements, memSubj, memPred, memObj, snapshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanSnapshots() throws InterruptedException {
        int lastStmtPos;
        HashSet<MemResource> processedSubjects = new HashSet<MemResource>();
        HashSet<MemIRI> processedPredicates = new HashSet<MemIRI>();
        HashSet<MemValue> processedObjects = new HashSet<MemValue>();
        HashSet<MemResource> processedContexts = new HashSet<MemResource>();
        Lock stReadLock = this.statementListLockManager.getReadLock();
        try {
            lastStmtPos = this.statements.size() - 1;
        }
        finally {
            stReadLock.release();
        }
        int nextSnapshot = this.currentSnapshot;
        for (int i = lastStmtPos; i >= 0; --i) {
            Lock stWriteLock = this.statementListLockManager.getWriteLock();
            try {
                MemResource context;
                MemValue obj;
                MemIRI pred;
                MemStatement st;
                lastStmtPos = this.statements.size() - 1;
                i = Math.min(i, lastStmtPos);
                if (i < 0 || (st = this.statements.get(i)).getTillSnapshot() > nextSnapshot) continue;
                MemResource subj = st.getSubject();
                if (processedSubjects.add(subj)) {
                    subj.cleanSnapshotsFromSubjectStatements(nextSnapshot);
                }
                if (processedPredicates.add(pred = st.getPredicate())) {
                    pred.cleanSnapshotsFromPredicateStatements(nextSnapshot);
                }
                if (processedObjects.add(obj = st.getObject())) {
                    obj.cleanSnapshotsFromObjectStatements(nextSnapshot);
                }
                if ((context = st.getContext()) != null && processedContexts.add(context)) {
                    context.cleanSnapshotsFromContextStatements(nextSnapshot);
                }
                this.statements.remove(i);
                continue;
            }
            finally {
                stWriteLock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleSnapshotCleanup() {
        Object object = this.snapshotCleanupThreadLockObject;
        synchronized (object) {
            Thread toCheckSnapshotCleanupThread = this.snapshotCleanupThread;
            if (toCheckSnapshotCleanupThread == null || !toCheckSnapshotCleanupThread.isAlive()) {
                Runnable runnable = () -> {
                    try {
                        this.cleanSnapshots();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        logger.warn("snapshot cleanup interrupted");
                    }
                };
                toCheckSnapshotCleanupThread = this.snapshotCleanupThread = new Thread(runnable, "MemoryStore snapshot cleanup");
                toCheckSnapshotCleanupThread.setDaemon(true);
                toCheckSnapshotCleanupThread.start();
            }
        }
    }

    private final class MemorySailDataset
    implements SailDataset {
        private final boolean explicit;
        private final int snapshot;
        private final Lock lock;

        public MemorySailDataset(boolean explicit) throws SailException {
            this.explicit = explicit;
            this.snapshot = -1;
            this.lock = null;
        }

        public MemorySailDataset(boolean explicit, int snapshot) throws SailException {
            this.explicit = explicit;
            this.snapshot = snapshot;
            this.lock = MemorySailStore.this.openStatementsReadLock();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.explicit) {
                sb.append("explicit ");
            } else {
                sb.append("inferred ");
            }
            if (this.snapshot >= 0) {
                sb.append("snapshot ").append(this.snapshot);
            } else {
                sb.append(super.toString());
            }
            return sb.toString();
        }

        @Override
        public void close() {
            if (this.lock != null) {
                this.lock.release();
            }
        }

        @Override
        public String getNamespace(String prefix) throws SailException {
            return MemorySailStore.this.namespaceStore.getNamespace(prefix);
        }

        @Override
        public CloseableIteration<? extends Namespace, SailException> getNamespaces() {
            return new CloseableIteratorIteration<SimpleNamespace, SailException>(MemorySailStore.this.namespaceStore.iterator());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CloseableIteration<? extends Resource, SailException> getContextIDs() throws SailException {
            ArrayList<MemResource> contextIDs = new ArrayList<MemResource>(32);
            Lock stLock = MemorySailStore.this.openStatementsReadLock();
            try {
                MemResource memResource;
                int snapshot = this.getCurrentSnapshot();
                try (WeakObjectRegistry.AutoCloseableIterator<MemIRI> memIRIsIterator = MemorySailStore.this.valueFactory.getMemIRIsIterator();){
                    while (memIRIsIterator.hasNext()) {
                        memResource = memIRIsIterator.next();
                        if (!this.isContextResource(memResource, snapshot)) continue;
                        contextIDs.add(memResource);
                    }
                }
                try (WeakObjectRegistry.AutoCloseableIterator<MemBNode> memBNodesIterator = MemorySailStore.this.valueFactory.getMemBNodesIterator();){
                    while (memBNodesIterator.hasNext()) {
                        memResource = memBNodesIterator.next();
                        if (!this.isContextResource(memResource, snapshot)) continue;
                        contextIDs.add(memResource);
                    }
                }
            }
            finally {
                stLock.release();
            }
            return new CloseableIteratorIteration(contextIDs.iterator());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CloseableIteration<? extends Statement, SailException> getStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
            CloseableIteration<MemStatement, SailException> stIter1 = null;
            LockingIteration<MemStatement, SailException> stIter2 = null;
            boolean allGood = false;
            Lock stLock = MemorySailStore.this.openStatementsReadLock();
            try {
                stIter1 = MemorySailStore.this.createStatementIterator(subj, pred, obj, (Boolean)this.explicit, this.getCurrentSnapshot(), contexts);
                if (stIter1 instanceof EmptyIteration) {
                    stLock.release();
                    allGood = true;
                    CloseableIteration<MemStatement, SailException> closeableIteration = stIter1;
                    return closeableIteration;
                }
                stIter2 = new LockingIteration<MemStatement, SailException>(stLock, stIter1);
                allGood = true;
                LockingIteration<MemStatement, SailException> lockingIteration = stIter2;
                return lockingIteration;
            }
            finally {
                if (!allGood) {
                    try {
                        stLock.release();
                    }
                    finally {
                        try {
                            if (stIter2 != null) {
                                stIter2.close();
                            }
                        }
                        finally {
                            if (stIter1 != null) {
                                stIter1.close();
                            }
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CloseableIteration<? extends Triple, SailException> getTriples(Resource subj, IRI pred, Value obj) throws SailException {
            CloseableIteration<MemTriple, SailException> stIter1 = null;
            LockingIteration<MemTriple, SailException> stIter2 = null;
            boolean allGood = false;
            Lock stLock = MemorySailStore.this.openStatementsReadLock();
            try {
                stIter1 = MemorySailStore.this.createTripleIterator(subj, pred, obj, this.getCurrentSnapshot());
                stIter2 = new LockingIteration<MemTriple, SailException>(stLock, stIter1);
                allGood = true;
                LockingIteration<MemTriple, SailException> lockingIteration = stIter2;
                return lockingIteration;
            }
            finally {
                if (!allGood) {
                    try {
                        stLock.release();
                    }
                    finally {
                        try {
                            if (stIter2 != null) {
                                stIter2.close();
                            }
                        }
                        finally {
                            if (stIter1 != null) {
                                stIter1.close();
                            }
                        }
                    }
                }
            }
        }

        private int getCurrentSnapshot() {
            if (this.snapshot >= 0) {
                return this.snapshot;
            }
            return MemorySailStore.this.currentSnapshot;
        }

        private boolean isContextResource(MemResource memResource, int snapshot) throws SailException {
            MemStatementList contextStatements = memResource.getContextStatementList();
            if (contextStatements.size() == 0) {
                return false;
            }
            try (MemStatementIterator iter = new MemStatementIterator(contextStatements, null, null, null, null, snapshot, new MemResource[0]);){
                boolean bl = iter.hasNext();
                return bl;
            }
        }
    }

    private final class MemorySailSink
    implements SailSink {
        private final boolean explicit;
        private final int serializable;
        private final Lock txnStLock;
        private volatile int nextSnapshot;
        private volatile Set<StatementPattern> observations;
        private volatile boolean txnLock;
        private boolean requireCleanup;

        public MemorySailSink(boolean explicit, boolean serializable) throws SailException {
            this.explicit = explicit;
            this.serializable = serializable ? MemorySailStore.this.currentSnapshot : Integer.MAX_VALUE;
            this.txnStLock = MemorySailStore.this.openStatementsReadLock();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.explicit) {
                sb.append("explicit ");
            } else {
                sb.append("inferred ");
            }
            if (this.txnLock) {
                sb.append("snapshot ").append(this.nextSnapshot);
            } else {
                sb.append(super.toString());
            }
            return sb.toString();
        }

        @Override
        public synchronized void prepare() throws SailException {
            this.acquireExclusiveTransactionLock();
            if (this.observations != null) {
                for (StatementPattern p : this.observations) {
                    Resource subj = (Resource)p.getSubjectVar().getValue();
                    IRI pred = (IRI)p.getPredicateVar().getValue();
                    Value obj = p.getObjectVar().getValue();
                    Var ctxVar = p.getContextVar();
                    Resource[] contexts = ctxVar == null ? new Resource[]{} : new Resource[]{(Resource)ctxVar.getValue()};
                    try (CloseableIteration<MemStatement, SailException> iter = MemorySailStore.this.createStatementIterator(subj, pred, obj, null, -1, contexts);){
                        while (iter.hasNext()) {
                            MemStatement st = (MemStatement)iter.next();
                            int since = st.getSinceSnapshot();
                            int till = st.getTillSnapshot();
                            if ((this.serializable >= since || since >= this.nextSnapshot) && (this.serializable >= till || till >= this.nextSnapshot)) continue;
                            throw new SailConflictException("Observed State has Changed");
                        }
                    }
                }
            }
        }

        @Override
        public synchronized void flush() throws SailException {
            if (this.txnLock) {
                MemorySailStore.this.invalidateCache();
                MemorySailStore.this.currentSnapshot = Math.max(MemorySailStore.this.currentSnapshot, this.nextSnapshot);
                if (this.requireCleanup) {
                    MemorySailStore.this.scheduleSnapshotCleanup();
                }
            }
        }

        @Override
        public void close() {
            try {
                boolean toCloseTxnLock = this.txnLock;
                this.txnLock = false;
                if (toCloseTxnLock) {
                    MemorySailStore.this.txnLockManager.unlock();
                }
            }
            finally {
                if (this.txnStLock != null) {
                    this.txnStLock.release();
                }
            }
        }

        @Override
        public synchronized void setNamespace(String prefix, String name) throws SailException {
            this.acquireExclusiveTransactionLock();
            MemorySailStore.this.namespaceStore.setNamespace(prefix, name);
        }

        @Override
        public synchronized void removeNamespace(String prefix) throws SailException {
            this.acquireExclusiveTransactionLock();
            MemorySailStore.this.namespaceStore.removeNamespace(prefix);
        }

        @Override
        public synchronized void clearNamespaces() throws SailException {
            this.acquireExclusiveTransactionLock();
            MemorySailStore.this.namespaceStore.clear();
        }

        @Override
        public synchronized void observe(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
            if (this.observations == null) {
                this.observations = new HashSet<StatementPattern>();
            }
            if (contexts == null) {
                this.observations.add(new StatementPattern(new Var("s", subj), new Var("p", pred), new Var("o", obj), new Var("g", null)));
            } else if (contexts.length == 0) {
                this.observations.add(new StatementPattern(new Var("s", subj), new Var("p", pred), new Var("o", obj)));
            } else {
                for (Resource ctx : contexts) {
                    this.observations.add(new StatementPattern(new Var("s", subj), new Var("p", pred), new Var("o", obj), new Var("g", ctx)));
                }
            }
        }

        @Override
        public synchronized void clear(Resource ... contexts) throws SailException {
            this.acquireExclusiveTransactionLock();
            MemorySailStore.this.invalidateCache();
            this.requireCleanup = true;
            try (CloseableIteration<MemStatement, SailException> iter = MemorySailStore.this.createStatementIterator(null, null, null, (Boolean)this.explicit, this.nextSnapshot, contexts);){
                while (iter.hasNext()) {
                    MemStatement st = (MemStatement)iter.next();
                    st.setTillSnapshot(this.nextSnapshot);
                }
            }
        }

        @Override
        public synchronized void approve(Resource subj, IRI pred, Value obj, Resource ctx) throws SailException {
            this.acquireExclusiveTransactionLock();
            MemorySailStore.this.invalidateCache();
            this.addStatement(subj, pred, obj, ctx, this.explicit);
        }

        @Override
        public synchronized void deprecate(Statement statement) throws SailException {
            this.acquireExclusiveTransactionLock();
            MemorySailStore.this.invalidateCache();
            this.requireCleanup = true;
            if (statement instanceof MemStatement) {
                MemStatement toDeprecate = (MemStatement)statement;
                if ((this.nextSnapshot < 0 || toDeprecate.isInSnapshot(this.nextSnapshot)) && toDeprecate.isExplicit() == this.explicit) {
                    toDeprecate.setTillSnapshot(this.nextSnapshot);
                }
            } else if (statement instanceof LinkedHashModel.ModelStatement && ((LinkedHashModel.ModelStatement)statement).getStatement() instanceof MemStatement) {
                MemStatement toDeprecate = (MemStatement)((LinkedHashModel.ModelStatement)statement).getStatement();
                if ((this.nextSnapshot < 0 || toDeprecate.isInSnapshot(this.nextSnapshot)) && toDeprecate.isExplicit() == this.explicit) {
                    toDeprecate.setTillSnapshot(this.nextSnapshot);
                }
            } else {
                try (CloseableIteration<MemStatement, SailException> iter = MemorySailStore.this.createStatementIterator(statement.getSubject(), statement.getPredicate(), statement.getObject(), (Boolean)this.explicit, this.nextSnapshot, statement.getContext());){
                    while (iter.hasNext()) {
                        MemStatement st = (MemStatement)iter.next();
                        st.setTillSnapshot(this.nextSnapshot);
                    }
                }
            }
        }

        private void acquireExclusiveTransactionLock() throws SailException {
            if (!this.txnLock) {
                MemorySailStore.this.txnLockManager.lock();
                this.nextSnapshot = MemorySailStore.this.currentSnapshot + 1;
                this.txnLock = true;
            }
        }

        private MemStatement addStatement(Resource subj, IRI pred, Value obj, Resource context, boolean explicit) throws SailException {
            MemResource memContext;
            MemValue memObj;
            MemIRI memPred;
            MemResource memSubj;
            block10: {
                if (!explicit) {
                    MemorySailStore.this.mayHaveInferred = true;
                }
                memSubj = MemorySailStore.this.valueFactory.getOrCreateMemResource(subj);
                memPred = MemorySailStore.this.valueFactory.getOrCreateMemURI(pred);
                memObj = MemorySailStore.this.valueFactory.getOrCreateMemValue(obj);
                MemResource memResource = memContext = context == null ? null : MemorySailStore.this.valueFactory.getOrCreateMemResource(context);
                if (memSubj.hasStatements() && memPred.hasStatements() && memObj.hasStatements() && (memContext == null || memContext.hasStatements())) {
                    try (CloseableIteration<MemStatement, SailException> stIter = MemorySailStore.this.createStatementIterator(memSubj, memPred, memObj, null, 0x7FFFFFFE, memContext);){
                        if (!stIter.hasNext()) break block10;
                        MemStatement st = (MemStatement)stIter.next();
                        if (!st.isExplicit() && explicit) {
                            st.setTillSnapshot(this.nextSnapshot);
                            break block10;
                        }
                        if (!st.isInSnapshot(this.nextSnapshot)) {
                            st.setSinceSnapshot(this.nextSnapshot);
                            break block10;
                        }
                        MemStatement memStatement = null;
                        return memStatement;
                    }
                }
            }
            MemStatement st = new MemStatement(memSubj, memPred, memObj, memContext, explicit, this.nextSnapshot);
            MemorySailStore.this.statements.add(st);
            st.addToComponentLists();
            MemorySailStore.this.invalidateCache();
            return st;
        }

        @Override
        public boolean deprecateByQuery(Resource subj, IRI pred, Value obj, Resource[] contexts) {
            this.acquireExclusiveTransactionLock();
            boolean deprecated = false;
            this.requireCleanup = true;
            try (CloseableIteration<MemStatement, SailException> iter = MemorySailStore.this.createStatementIterator(subj, pred, obj, (Boolean)this.explicit, this.nextSnapshot, contexts);){
                while (iter.hasNext()) {
                    deprecated = true;
                    MemStatement st = (MemStatement)iter.next();
                    st.setTillSnapshot(this.nextSnapshot);
                }
            }
            MemorySailStore.this.invalidateCache();
            return deprecated;
        }
    }

    private final class MemorySailSource
    extends BackingSailSource {
        private final boolean explicit;

        public MemorySailSource(boolean explicit) {
            this.explicit = explicit;
        }

        @Override
        public SailSink sink(IsolationLevel level) throws SailException {
            return new MemorySailSink(this.explicit, level.isCompatibleWith(IsolationLevels.SERIALIZABLE));
        }

        @Override
        public MemorySailDataset dataset(IsolationLevel level) throws SailException {
            if (level.isCompatibleWith(IsolationLevels.SNAPSHOT_READ)) {
                return new MemorySailDataset(this.explicit, MemorySailStore.this.currentSnapshot);
            }
            return new MemorySailDataset(this.explicit);
        }
    }
}

