/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository.statements;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.eclipse.rdf4j.common.webapp.util.HttpServerUtil;
import org.eclipse.rdf4j.common.webapp.views.EmptySuccessView;
import org.eclipse.rdf4j.http.protocol.error.ErrorInfo;
import org.eclipse.rdf4j.http.protocol.error.ErrorType;
import org.eclipse.rdf4j.http.protocol.transaction.TransactionReader;
import org.eclipse.rdf4j.http.protocol.transaction.operations.TransactionOperation;
import org.eclipse.rdf4j.http.server.ClientHTTPException;
import org.eclipse.rdf4j.http.server.HTTPException;
import org.eclipse.rdf4j.http.server.ProtocolUtil;
import org.eclipse.rdf4j.http.server.ServerHTTPException;
import org.eclipse.rdf4j.http.server.repository.RepositoryInterceptor;
import org.eclipse.rdf4j.http.server.repository.statements.ExportStatementsView;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryInterruptedException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.eclipse.rdf4j.query.impl.SimpleDataset;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFWriterFactory;
import org.eclipse.rdf4j.rio.RDFWriterRegistry;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class StatementsController
extends AbstractController {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public StatementsController() throws ApplicationContextException {
        this.setSupportedMethods(new String[]{"GET", "POST", "HEAD", "PUT", "DELETE"});
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView result;
        Repository repository = RepositoryInterceptor.getRepository(request);
        String reqMethod = request.getMethod();
        if ("GET".equals(reqMethod)) {
            this.logger.info("GET statements");
            result = this.getExportStatementsResult(repository, request, response);
        } else if ("HEAD".equals(reqMethod)) {
            this.logger.info("HEAD statements");
            result = this.getExportStatementsResult(repository, request, response);
        } else if ("POST".equals(reqMethod)) {
            String mimeType = HttpServerUtil.getMIMEType(request.getContentType());
            if ("application/x-rdftransaction".equals(mimeType)) {
                this.logger.info("POST transaction to repository");
                result = this.getTransactionResultResult(repository, request, response);
            } else if ("application/sparql-update".equals(mimeType) || request.getParameterMap().containsKey("update")) {
                this.logger.info("POST SPARQL update request to repository");
                result = this.getSparqlUpdateResult(repository, request, response);
            } else {
                this.logger.info("POST data to repository");
                result = this.getAddDataResult(repository, request, response, false);
            }
        } else if ("PUT".equals(reqMethod)) {
            this.logger.info("PUT data in repository");
            result = this.getAddDataResult(repository, request, response, true);
        } else if ("DELETE".equals(reqMethod)) {
            this.logger.info("DELETE data from repository");
            result = this.getDeleteDataResult(repository, request, response);
        } else {
            throw new ClientHTTPException(405, "Method not allowed: " + reqMethod);
        }
        return result;
    }

    private ModelAndView getSparqlUpdateResult(Repository repository, HttpServletRequest request, HttpServletResponse response) throws ServerHTTPException, ClientHTTPException, HTTPException {
        ModelAndView modelAndView;
        block35: {
            IRI uri;
            String sparqlUpdateString;
            ProtocolUtil.logRequestParameters(request);
            String mimeType = HttpServerUtil.getMIMEType(request.getContentType());
            if ("application/sparql-update".equals(mimeType)) {
                try {
                    sparqlUpdateString = IOUtils.toString((Reader)request.getReader());
                }
                catch (IOException e) {
                    throw new ClientHTTPException(400, "Error reading request message body", e);
                }
                if (sparqlUpdateString.isEmpty()) {
                    sparqlUpdateString = null;
                }
            } else {
                sparqlUpdateString = request.getParameterValues("update")[0];
            }
            QueryLanguage queryLn = QueryLanguage.SPARQL;
            String queryLnStr = request.getParameter("queryLn");
            this.logger.debug("query language param = {}", (Object)queryLnStr);
            if (queryLnStr != null && (queryLn = QueryLanguage.valueOf(queryLnStr)) == null) {
                throw new ClientHTTPException(400, "Unknown query language: " + queryLnStr);
            }
            String baseURI = request.getParameter("baseURI");
            boolean includeInferred = ProtocolUtil.parseBooleanParam(request, "infer", true);
            String[] defaultRemoveGraphURIs = request.getParameterValues("remove-graph-uri");
            String[] defaultInsertGraphURIs = request.getParameterValues("insert-graph-uri");
            String[] defaultGraphURIs = request.getParameterValues("using-graph-uri");
            String[] namedGraphURIs = request.getParameterValues("using-named-graph-uri");
            SimpleDataset dataset = null;
            if (defaultRemoveGraphURIs != null || defaultInsertGraphURIs != null || defaultGraphURIs != null || namedGraphURIs != null) {
                dataset = new SimpleDataset();
            }
            if (defaultRemoveGraphURIs != null) {
                String[] stringArray = defaultRemoveGraphURIs;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String graphURI = stringArray[i];
                    try {
                        uri = this.createURIOrNull(repository, graphURI);
                        dataset.addDefaultRemoveGraph(uri);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        throw new ClientHTTPException(400, "Illegal URI for default remove graph: " + graphURI);
                    }
                }
            }
            if (defaultInsertGraphURIs != null && defaultInsertGraphURIs.length > 0) {
                String string = defaultInsertGraphURIs[0];
                try {
                    IRI uri2 = this.createURIOrNull(repository, string);
                    dataset.setDefaultInsertGraph(uri2);
                }
                catch (IllegalArgumentException e) {
                    throw new ClientHTTPException(400, "Illegal URI for default insert graph: " + string);
                }
            }
            if (defaultGraphURIs != null) {
                for (String defaultGraphURI : defaultGraphURIs) {
                    try {
                        uri = this.createURIOrNull(repository, defaultGraphURI);
                        dataset.addDefaultGraph(uri);
                    }
                    catch (IllegalArgumentException e) {
                        throw new ClientHTTPException(400, "Illegal URI for default graph: " + defaultGraphURI);
                    }
                }
            }
            if (namedGraphURIs != null) {
                for (String namedGraphURI : namedGraphURIs) {
                    try {
                        uri = this.createURIOrNull(repository, namedGraphURI);
                        dataset.addNamedGraph(uri);
                    }
                    catch (IllegalArgumentException e) {
                        throw new ClientHTTPException(400, "Illegal URI for named graph: " + namedGraphURI);
                    }
                }
            }
            int n = ProtocolUtil.parseTimeoutParam(request);
            RepositoryConnection repositoryCon = RepositoryInterceptor.getRepositoryConnection(request);
            try {
                Update update = repositoryCon.prepareUpdate(queryLn, sparqlUpdateString, baseURI);
                update.setIncludeInferred(includeInferred);
                update.setMaxExecutionTime(n);
                if (dataset != null) {
                    update.setDataset(dataset);
                }
                Enumeration parameterNames = request.getParameterNames();
                while (parameterNames.hasMoreElements()) {
                    String parameterName = (String)parameterNames.nextElement();
                    if (!parameterName.startsWith("$") || parameterName.length() <= "$".length()) continue;
                    String bindingName = parameterName.substring("$".length());
                    Value bindingValue = ProtocolUtil.parseValueParam(request, parameterName, repository.getValueFactory());
                    update.setBinding(bindingName, bindingValue);
                }
                update.execute();
                modelAndView = new ModelAndView((View)EmptySuccessView.getInstance());
                if (repositoryCon == null) break block35;
            }
            catch (Throwable update) {
                try {
                    if (repositoryCon != null) {
                        try {
                            repositoryCon.close();
                        }
                        catch (Throwable throwable) {
                            update.addSuppressed(throwable);
                        }
                    }
                    throw update;
                }
                catch (QueryInterruptedException e) {
                    throw new ServerHTTPException(503, "update execution took too long");
                }
                catch (UpdateExecutionException | RepositoryException e) {
                    if (e.getCause() != null && e.getCause() instanceof HTTPException) {
                        throw (HTTPException)e.getCause();
                    }
                    throw new ServerHTTPException("Repository update error: " + e.getMessage(), (Throwable)e);
                }
                catch (MalformedQueryException e) {
                    ErrorInfo errInfo = new ErrorInfo(ErrorType.MALFORMED_QUERY, e.getMessage());
                    throw new ClientHTTPException(400, errInfo.toString());
                }
            }
            repositoryCon.close();
        }
        return modelAndView;
    }

    private IRI createURIOrNull(Repository repository, String graphURI) {
        if ("null".equals(graphURI)) {
            return null;
        }
        return repository.getValueFactory().createIRI(graphURI);
    }

    private ModelAndView getExportStatementsResult(Repository repository, HttpServletRequest request, HttpServletResponse response) throws ClientHTTPException {
        ProtocolUtil.logRequestParameters(request);
        ValueFactory vf = repository.getValueFactory();
        Resource subj = ProtocolUtil.parseResourceParam(request, "subj", vf);
        IRI pred = ProtocolUtil.parseURIParam(request, "pred", vf);
        Value obj = ProtocolUtil.parseValueParam(request, "obj", vf);
        Resource[] contexts = ProtocolUtil.parseContextParam(request, "context", vf);
        boolean useInferencing = ProtocolUtil.parseBooleanParam(request, "infer", true);
        RDFWriterFactory rdfWriterFactory = ProtocolUtil.getAcceptableService(request, response, RDFWriterRegistry.getInstance());
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("subject", subj);
        model.put("predicate", pred);
        model.put("object", obj);
        model.put("contexts", contexts);
        model.put("useInferencing", useInferencing);
        model.put("factory", rdfWriterFactory);
        model.put("headersOnly", "HEAD".equals(request.getMethod()));
        return new ModelAndView((View)ExportStatementsView.getInstance(), model);
    }

    private ModelAndView getTransactionResultResult(Repository repository, HttpServletRequest request, HttpServletResponse response) throws IOException, ClientHTTPException, ServerHTTPException, HTTPException {
        ModelAndView modelAndView;
        block13: {
            ServletInputStream in = request.getInputStream();
            RepositoryConnection repositoryCon = RepositoryInterceptor.getRepositoryConnection(request);
            try {
                this.logger.debug("Processing transaction...");
                TransactionReader reader = new TransactionReader();
                Collection<TransactionOperation> txn = reader.parse((InputStream)in);
                repositoryCon.begin();
                for (TransactionOperation op : txn) {
                    op.execute(repositoryCon);
                }
                repositoryCon.commit();
                this.logger.debug("Transaction processed ");
                modelAndView = new ModelAndView((View)EmptySuccessView.getInstance());
                if (repositoryCon == null) break block13;
            }
            catch (Throwable reader) {
                try {
                    if (repositoryCon != null) {
                        try {
                            repositoryCon.close();
                        }
                        catch (Throwable throwable) {
                            reader.addSuppressed(throwable);
                        }
                    }
                    throw reader;
                }
                catch (SAXParseException e) {
                    ErrorInfo errInfo = new ErrorInfo(ErrorType.MALFORMED_DATA, e.getMessage());
                    throw new ClientHTTPException(400, errInfo.toString());
                }
                catch (SAXException e) {
                    throw new ServerHTTPException("Failed to parse transaction data: " + e.getMessage(), (Throwable)e);
                }
                catch (IOException e) {
                    throw new ServerHTTPException("Failed to read data: " + e.getMessage(), (Throwable)e);
                }
                catch (RepositoryException e) {
                    if (e.getCause() != null && e.getCause() instanceof HTTPException) {
                        throw (HTTPException)e.getCause();
                    }
                    throw new ServerHTTPException("Repository update error: " + e.getMessage(), (Throwable)e);
                }
            }
            repositoryCon.close();
        }
        return modelAndView;
    }

    private ModelAndView getAddDataResult(Repository repository, HttpServletRequest request, HttpServletResponse response, boolean replaceCurrent) throws IOException, ServerHTTPException, ClientHTTPException, HTTPException {
        ModelAndView modelAndView;
        block15: {
            ProtocolUtil.logRequestParameters(request);
            String mimeType = HttpServerUtil.getMIMEType(request.getContentType());
            RDFFormat rdfFormat = Rio.getParserFormatForMIMEType(mimeType).orElseThrow(() -> new ClientHTTPException(415, "Unsupported MIME type: " + mimeType));
            ValueFactory vf = repository.getValueFactory();
            Resource[] contexts = ProtocolUtil.parseContextParam(request, "context", vf);
            IRI baseURI = ProtocolUtil.parseURIParam(request, "baseURI", vf);
            boolean preserveNodeIds = ProtocolUtil.parseBooleanParam(request, "preserveNodeId", false);
            String baseURIString = null;
            if (baseURI != null) {
                baseURIString = baseURI.toString();
            }
            ServletInputStream in = request.getInputStream();
            RepositoryConnection repositoryCon = RepositoryInterceptor.getRepositoryConnection(request);
            try {
                repositoryCon.begin();
                if (preserveNodeIds) {
                    repositoryCon.getParserConfig().set((RioSetting)BasicParserSettings.PRESERVE_BNODE_IDS, (Object)true);
                }
                if (replaceCurrent) {
                    repositoryCon.clear(contexts);
                }
                repositoryCon.add((InputStream)in, baseURIString, rdfFormat, contexts);
                repositoryCon.commit();
                modelAndView = new ModelAndView((View)EmptySuccessView.getInstance());
                if (repositoryCon == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (repositoryCon != null) {
                        try {
                            repositoryCon.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (UnsupportedRDFormatException e) {
                    throw new ClientHTTPException(415, "No RDF parser available for format " + rdfFormat.getName());
                }
                catch (RDFParseException e) {
                    ErrorInfo errInfo = new ErrorInfo(ErrorType.MALFORMED_DATA, e.getMessage());
                    throw new ClientHTTPException(400, errInfo.toString());
                }
                catch (IOException e) {
                    throw new ServerHTTPException("Failed to read data: " + e.getMessage(), (Throwable)e);
                }
                catch (RepositoryException e) {
                    if (e.getCause() != null && e.getCause() instanceof HTTPException) {
                        throw (HTTPException)e.getCause();
                    }
                    throw new ServerHTTPException("Repository update error: " + e.getMessage(), (Throwable)e);
                }
            }
            repositoryCon.close();
        }
        return modelAndView;
    }

    private ModelAndView getDeleteDataResult(Repository repository, HttpServletRequest request, HttpServletResponse response) throws ServerHTTPException, ClientHTTPException, HTTPException {
        ModelAndView modelAndView;
        block9: {
            ProtocolUtil.logRequestParameters(request);
            ValueFactory vf = repository.getValueFactory();
            Resource subj = ProtocolUtil.parseResourceParam(request, "subj", vf);
            IRI pred = ProtocolUtil.parseURIParam(request, "pred", vf);
            Value obj = ProtocolUtil.parseValueParam(request, "obj", vf);
            Resource[] contexts = ProtocolUtil.parseContextParam(request, "context", vf);
            RepositoryConnection repositoryCon = RepositoryInterceptor.getRepositoryConnection(request);
            try {
                repositoryCon.remove(subj, pred, obj, contexts);
                modelAndView = new ModelAndView((View)EmptySuccessView.getInstance());
                if (repositoryCon == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (repositoryCon != null) {
                        try {
                            repositoryCon.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RepositoryException e) {
                    if (e.getCause() != null && e.getCause() instanceof HTTPException) {
                        throw (HTTPException)e.getCause();
                    }
                    throw new ServerHTTPException("Repository update error: " + e.getMessage(), (Throwable)e);
                }
            }
            repositoryCon.close();
        }
        return modelAndView;
    }
}

