/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb;

import java.io.IOException;
import org.eclipse.rdf4j.common.concurrent.locks.Lock;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailChangedEvent;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.SailReadOnlyException;
import org.eclipse.rdf4j.sail.base.SailSourceConnection;
import org.eclipse.rdf4j.sail.helpers.AbstractSail;
import org.eclipse.rdf4j.sail.helpers.DefaultSailChangedEvent;
import org.eclipse.rdf4j.sail.lmdb.LmdbStore;

public class LmdbStoreConnection
extends SailSourceConnection {
    protected final LmdbStore lmdbStore;
    private volatile DefaultSailChangedEvent sailChangedEvent;
    private volatile Lock txnLock;
    private int addedCount;

    protected LmdbStoreConnection(LmdbStore sail) throws IOException {
        super((AbstractSail)sail, sail.getSailStore(), sail.getEvaluationStrategyFactory());
        this.lmdbStore = sail;
        this.sailChangedEvent = new DefaultSailChangedEvent((Sail)sail);
    }

    protected void startTransactionInternal() throws SailException {
        this.addedCount = 0;
        if (!this.lmdbStore.isWritable()) {
            throw new SailReadOnlyException("Unable to start transaction: data file is locked or read-only");
        }
        boolean releaseLock = true;
        try {
            if (this.txnLock == null || !this.txnLock.isActive()) {
                this.txnLock = this.lmdbStore.getTransactionLock(this.getTransactionIsolation());
                if (this.lmdbStore.isIsolationDisabled()) {
                    releaseLock = false;
                }
            }
            super.startTransactionInternal();
        }
        finally {
            if (releaseLock && this.txnLock != null) {
                this.txnLock.release();
            }
        }
    }

    protected void commitInternal() throws SailException {
        try {
            super.commitInternal();
        }
        finally {
            if (this.txnLock != null) {
                this.txnLock.release();
            }
        }
        this.lmdbStore.notifySailChanged((SailChangedEvent)this.sailChangedEvent);
        this.sailChangedEvent = new DefaultSailChangedEvent((Sail)this.lmdbStore);
    }

    protected void rollbackInternal() throws SailException {
        try {
            super.rollbackInternal();
        }
        finally {
            if (this.txnLock != null) {
                this.txnLock.release();
            }
        }
        this.sailChangedEvent = new DefaultSailChangedEvent((Sail)this.lmdbStore);
    }

    protected void addStatementInternal(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        this.sailChangedEvent.setStatementsAdded(true);
    }

    public boolean addInferredStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        boolean ret = super.addInferredStatement(subj, pred, obj, contexts);
        this.sailChangedEvent.setStatementsAdded(true);
        return ret;
    }

    protected void removeStatementsInternal(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        this.sailChangedEvent.setStatementsRemoved(true);
    }

    public boolean removeInferredStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        boolean ret = super.removeInferredStatement(subj, pred, obj, contexts);
        this.sailChangedEvent.setStatementsRemoved(true);
        return ret;
    }

    protected void clearInternal(Resource ... contexts) throws SailException {
        super.clearInternal(contexts);
        this.sailChangedEvent.setStatementsRemoved(true);
    }

    public void clearInferred(Resource ... contexts) throws SailException {
        super.clearInferred(contexts);
        this.sailChangedEvent.setStatementsRemoved(true);
    }
}

