/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.repository.RepositoryConnection;

@InternalUseOnly
public class ShaclAstLists {
    public static void listToRdf(Collection<? extends Value> values, Resource head, Model model) {
        Iterator<? extends Value> iter = values.iterator();
        while (iter.hasNext()) {
            Value value = iter.next();
            model.add(head, RDF.FIRST, value, new Resource[0]);
            if (iter.hasNext()) {
                BNode next = Values.bnode();
                model.add(head, RDF.REST, (Value)next, new Resource[0]);
                head = next;
                continue;
            }
            model.add(head, RDF.REST, (Value)RDF.NIL, new Resource[0]);
        }
    }

    private static List<Value> toList(RepositoryConnection connection, Resource head) {
        ArrayList<Value> ret = new ArrayList<Value>();
        while (!head.equals(RDF.NIL)) {
            try (Stream stream = connection.getStatements(head, RDF.FIRST, null, new Resource[0]).stream();){
                Value value = stream.map(Statement::getObject).findAny().get();
                ret.add(value);
            }
            stream = connection.getStatements(head, RDF.REST, null, new Resource[0]).stream();
            try {
                head = stream.map(Statement::getObject).map(v -> (Resource)v).findAny().get();
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
        return ret;
    }

    public static <T extends Value> List<T> toList(RepositoryConnection connection, Resource head, Class<T> type) {
        if (type == Value.class) {
            return ShaclAstLists.toList(connection, head);
        }
        ArrayList<Value> ret = new ArrayList<Value>();
        while (!head.equals(RDF.NIL)) {
            Stream stream;
            block14: {
                stream = connection.getStatements(head, RDF.FIRST, null, new Resource[0]).stream();
                try {
                    Value value = stream.map(Statement::getObject).findAny().get();
                    if (type.isInstance(value)) {
                        ret.add(value);
                        break block14;
                    }
                    throw new IllegalStateException("RDF list should contain only type " + type.getSimpleName() + ", but found " + value.getClass().getSimpleName());
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            stream = connection.getStatements(head, RDF.REST, null, new Resource[0]).stream();
            try {
                head = stream.map(Statement::getObject).map(v -> (Resource)v).findAny().get();
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
        return ret;
    }
}

