/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.memory.MemoryStoreConnection;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Formatter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;

public class ExternalFilterByPredicate
implements PlanNode {
    private final SailConnection connection;
    private final Set<IRI> filterOnPredicates;
    final PlanNode parent;
    private final On on;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public ExternalFilterByPredicate(SailConnection connection, Set<IRI> filterOnPredicates, PlanNode parent, On on) {
        parent = PlanNodeHelper.handleSorting(this, parent);
        this.connection = connection;
        this.filterOnPredicates = filterOnPredicates;
        this.parent = parent;
        this.on = on;
    }

    @Override
    public CloseableIteration<? extends ValidationTuple, SailException> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            ValidationTuple next;
            final CloseableIteration<? extends ValidationTuple, SailException> parentIterator;
            {
                this.next = null;
                this.parentIterator = ExternalFilterByPredicate.this.parent.iterator();
            }

            void calculateNext() {
                while (this.next == null && this.parentIterator.hasNext()) {
                    ValidationTuple temp = (ValidationTuple)this.parentIterator.next();
                    Value subject = temp.getActiveTarget();
                    IRI matchedPredicate = this.matchesFilter(subject);
                    if (matchedPredicate == null) continue;
                    this.next = temp;
                }
            }

            private IRI matchesFilter(Value node) {
                if (node.isResource() && ExternalFilterByPredicate.this.on == On.Subject) {
                    return ExternalFilterByPredicate.this.filterOnPredicates.stream().filter(predicate -> ExternalFilterByPredicate.this.connection.hasStatement((Resource)node, (IRI)predicate, null, true, new Resource[0])).findFirst().orElse(null);
                }
                if (ExternalFilterByPredicate.this.on == On.Object) {
                    return ExternalFilterByPredicate.this.filterOnPredicates.stream().filter(predicate -> ExternalFilterByPredicate.this.connection.hasStatement(null, (IRI)predicate, node, true, new Resource[0])).findFirst().orElse(null);
                }
                return null;
            }

            @Override
            public void localClose() throws SailException {
                this.parentIterator.close();
            }

            @Override
            protected boolean localHasNext() throws SailException {
                this.calculateNext();
                return this.next != null;
            }

            @Override
            protected ValidationTuple loggingNext() throws SailException {
                this.calculateNext();
                ValidationTuple temp = this.next;
                this.next = null;
                return temp;
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.parent.getId() + " -> " + this.getId()).append("\n");
        if (this.connection instanceof MemoryStoreConnection) {
            stringBuilder.append(System.identityHashCode(((MemoryStoreConnection)this.connection).getSail()) + " -> " + this.getId() + " [label=\"filter source\"]").append("\n");
        } else {
            stringBuilder.append(System.identityHashCode(this.connection) + " -> " + this.getId() + " [label=\"filter source\"]").append("\n");
        }
        this.parent.getPlanAsGraphvizDot(stringBuilder);
    }

    public String toString() {
        return "ExternalFilterByPredicate{filterOnPredicates=" + Arrays.toString(this.filterOnPredicates.stream().map(Formatter::prefix).toArray()) + '}';
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.parent.receiveLogger(validationExecutionLogger);
    }

    @Override
    public boolean producesSorted() {
        return this.parent.producesSorted();
    }

    @Override
    public boolean requiresSorted() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalFilterByPredicate that = (ExternalFilterByPredicate)o;
        if (this.connection instanceof MemoryStoreConnection && that.connection instanceof MemoryStoreConnection) {
            return ((MemoryStoreConnection)this.connection).getSail().equals(((MemoryStoreConnection)that.connection).getSail()) && this.filterOnPredicates.equals(that.filterOnPredicates) && this.parent.equals(that.parent) && this.on == that.on;
        }
        return this.connection.equals(that.connection) && this.filterOnPredicates.equals(that.filterOnPredicates) && this.parent.equals(that.parent) && this.on == that.on;
    }

    public int hashCode() {
        if (this.connection instanceof MemoryStoreConnection) {
            return Objects.hash(new Object[]{((MemoryStoreConnection)this.connection).getSail(), this.filterOnPredicates, this.parent, this.on});
        }
        return Objects.hash(new Object[]{this.connection, this.filterOnPredicates, this.parent, this.on});
    }

    public static enum On {
        Subject,
        Object;

    }
}

