/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream.expr;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;

public class StreamExpressionParser {
    static char[] wordChars = new char[]{'_', '.', '-'};

    public static StreamExpression parse(String clause) {
        StreamExpressionParameter expr = StreamExpressionParser.generateStreamExpression(clause = StreamExpressionParser.stripComments(clause));
        if (null != expr && expr instanceof StreamExpression) {
            return (StreamExpression)expr;
        }
        return null;
    }

    private static String stripComments(String clause) throws RuntimeException {
        StringBuilder builder = new StringBuilder();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new StringReader(clause));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.trim().startsWith("#")) continue;
                builder.append(line + '\n');
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
        return builder.toString();
    }

    private static StreamExpressionParameter generateStreamExpression(String clause) {
        String working = clause.trim();
        if (!StreamExpressionParser.isExpressionClause(working)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "'%s' is not a proper expression clause", working));
        }
        int firstOpenParen = StreamExpressionParser.findNextClear(working, 0, '(');
        StreamExpression expression = new StreamExpression(working.substring(0, firstOpenParen).trim());
        working = working.substring(firstOpenParen + 1, working.length() - 1).trim();
        List<String> parts = StreamExpressionParser.splitOn(working, ',');
        for (int idx = 0; idx < parts.size(); ++idx) {
            StreamExpressionParameter parameter;
            String part = parts.get(idx).trim();
            if (StreamExpressionParser.isExpressionClause(part)) {
                parameter = StreamExpressionParser.generateStreamExpression(part);
                if (null == parameter) continue;
                expression.addParameter(parameter);
                continue;
            }
            if (StreamExpressionParser.isNamedParameterClause(part)) {
                parameter = StreamExpressionParser.generateNamedParameterExpression(part);
                if (null == parameter) continue;
                expression.addParameter(parameter);
                continue;
            }
            expression.addParameter(new StreamExpressionValue(part));
        }
        return expression;
    }

    private static StreamExpressionNamedParameter generateNamedParameterExpression(String clause) {
        String working = clause.trim();
        if (!StreamExpressionParser.isNamedParameterClause(working)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "'%s' is not a proper named parameter clause", working));
        }
        int firstOpenEquals = StreamExpressionParser.findNextClear(working, 0, '=');
        StreamExpressionNamedParameter namedParameter = new StreamExpressionNamedParameter(working.substring(0, firstOpenEquals).trim());
        String parameter = working.substring(firstOpenEquals + 1, working.length());
        if (StreamExpressionParser.isExpressionClause(parameter)) {
            namedParameter.setParameter(StreamExpressionParser.generateStreamExpression(parameter));
        } else {
            if (parameter.startsWith("\"") && parameter.endsWith("\"") && 0 == (parameter = parameter.substring(1, parameter.length() - 1).trim()).length()) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "'%s' is not a proper named parameter clause", working));
            }
            if (parameter.contains("\\\"") && 0 == (parameter = parameter.replace("\\\"", "\"")).length()) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "'%s' is not a proper named parameter clause", working));
            }
            namedParameter.setParameter(new StreamExpressionValue(parameter));
        }
        return namedParameter;
    }

    private static boolean isExpressionClause(String clause) {
        if (!StreamExpressionParser.isBalanced(clause)) {
            return false;
        }
        int firstOpenParen = StreamExpressionParser.findNextClear(clause, 0, '(');
        if (firstOpenParen <= 0 || firstOpenParen == clause.length() - 1) {
            return false;
        }
        String functionName = clause.substring(0, firstOpenParen).trim();
        if (!StreamExpressionParser.wordToken(functionName)) {
            return false;
        }
        return clause.endsWith(")");
    }

    private static boolean isNamedParameterClause(String clause) {
        int firstOpenEquals = StreamExpressionParser.findNextClear(clause, 0, '=');
        if (firstOpenEquals <= 0 || firstOpenEquals == clause.length() - 1) {
            return false;
        }
        String name = clause.substring(0, firstOpenEquals);
        return StreamExpressionParser.wordToken(name.trim());
    }

    private static int findNextClear(String clause, int startingIdx, char findThis) {
        int openParens = 0;
        boolean isDoubleQuote = false;
        boolean isSingleQuote = false;
        boolean isEscaped = false;
        block7: for (int idx = startingIdx; idx < clause.length(); ++idx) {
            char c = clause.charAt(idx);
            if (!(c != findThis || isEscaped || isSingleQuote || isDoubleQuote || 0 != openParens)) {
                return idx;
            }
            switch (c) {
                case '\\': {
                    isEscaped = !isEscaped;
                    continue block7;
                }
                case '\"': {
                    if (!isEscaped && !isSingleQuote) {
                        isDoubleQuote = !isDoubleQuote;
                    }
                    isEscaped = false;
                    continue block7;
                }
                case '\'': {
                    if (!isEscaped && !isDoubleQuote) {
                        isSingleQuote = !isSingleQuote;
                    }
                    isEscaped = false;
                    continue block7;
                }
                case '(': {
                    if (!(isEscaped || isSingleQuote || isDoubleQuote)) {
                        ++openParens;
                    }
                    isEscaped = false;
                    continue block7;
                }
                case ')': {
                    if (!(isEscaped || isSingleQuote || isDoubleQuote)) {
                        --openParens;
                    }
                    isEscaped = false;
                    continue block7;
                }
                default: {
                    isEscaped = false;
                }
            }
        }
        return -1;
    }

    private static List<String> splitOn(String clause, char splitOnThis) {
        String working = clause.trim();
        ArrayList<String> parts = new ArrayList<String>();
        while (true) {
            int nextIdx;
            if ((nextIdx = StreamExpressionParser.findNextClear(working, 0, splitOnThis)) < 0) {
                parts.add(working);
                break;
            }
            parts.add(working.substring(0, nextIdx));
            if (nextIdx + 1 == working.length()) break;
            working = working.substring(nextIdx + 1).trim();
        }
        return parts;
    }

    private static boolean isBalanced(String clause) {
        int openParens = 0;
        boolean isDoubleQuote = false;
        boolean isSingleQuote = false;
        boolean isEscaped = false;
        block7: for (int idx = 0; idx < clause.length(); ++idx) {
            char c = clause.charAt(idx);
            switch (c) {
                case '\\': {
                    isEscaped = !isEscaped;
                    continue block7;
                }
                case '\"': {
                    if (!isEscaped && !isSingleQuote) {
                        isDoubleQuote = !isDoubleQuote;
                    }
                    isEscaped = false;
                    continue block7;
                }
                case '\'': {
                    if (!isEscaped && !isDoubleQuote) {
                        isSingleQuote = !isSingleQuote;
                    }
                    isEscaped = false;
                    continue block7;
                }
                case '(': {
                    if (!(isEscaped || isSingleQuote || isDoubleQuote)) {
                        ++openParens;
                    }
                    isEscaped = false;
                    continue block7;
                }
                case ')': {
                    if (!(isEscaped || isSingleQuote || isDoubleQuote || --openParens >= 0)) {
                        return false;
                    }
                    isEscaped = false;
                    continue block7;
                }
                default: {
                    isEscaped = false;
                }
            }
        }
        return 0 == openParens;
    }

    public static boolean wordToken(String token) {
        for (int i = 0; i < token.length(); ++i) {
            char c = token.charAt(i);
            if (Character.isLetterOrDigit(c) || Arrays.binarySearch(wordChars, c) >= 0) continue;
            return false;
        }
        return true;
    }

    static {
        Arrays.sort(wordChars);
    }
}

