/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console.command;

import java.util.Locale;
import java.util.Map;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.Help;
import org.eclipse.rdf4j.console.command.ConsoleCommand;

public class PrintHelp
extends ConsoleCommand {
    public static final String USAGE = "Usage:\n";
    private final Map<String, ? extends Help> commands;

    @Override
    public String getName() {
        return "help";
    }

    @Override
    public String getHelpShort() {
        return "Displays this help message";
    }

    @Override
    public String getHelpLong() {
        return "No additional help available";
    }

    public PrintHelp(ConsoleIO consoleIO, Map<String, ? extends Help> commands) {
        super(consoleIO);
        this.commands = commands;
    }

    @Override
    public void execute(String ... parameters) {
        if (parameters.length < 2) {
            this.printCommandOverview();
            return;
        }
        String target = parameters[1].toLowerCase(Locale.ENGLISH);
        Help cmd = this.commands.get(target);
        if (cmd != null) {
            CharSequence[] uses;
            this.writeln(cmd.getHelpLong());
            if (cmd instanceof ConsoleCommand && (uses = ((ConsoleCommand)cmd).usesSettings()).length > 0) {
                this.writeln("");
                this.writeln("Uses settings: " + String.join((CharSequence)", ", uses));
            }
        } else {
            this.writeln("No additional info available for command " + target);
        }
    }

    private void printCommandOverview() {
        this.writeln("For more information on a specific command, try 'help <command>'.");
        this.writeln("List of all commands:");
        this.commands.forEach((k, v) -> this.writeln(String.format("%-11s %s", k, v.getHelpShort())));
        this.writeln("exit, quit  Exit the console");
    }
}

