/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.cloud.NodeStateProvider;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaInfo;
import org.apache.solr.client.solrj.cloud.autoscaling.Row;
import org.apache.solr.client.solrj.cloud.autoscaling.Variable;
import org.apache.solr.client.solrj.cloud.autoscaling.VariableBase;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.ZkClientClusterStateProvider;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.client.solrj.response.SimpleSolrResponse;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.rule.ImplicitSnitch;
import org.apache.solr.common.cloud.rule.SnitchContext;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Pair;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrClientNodeStateProvider
implements NodeStateProvider,
MapWriter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static SolrClientNodeStateProvider INST;
    private final CloudSolrClient solrClient;
    protected final Map<String, Map<String, Map<String, List<ReplicaInfo>>>> nodeVsCollectionVsShardVsReplicaInfo = new HashMap<String, Map<String, Map<String, List<ReplicaInfo>>>>();
    private Map<String, Object> snitchSession = new HashMap<String, Object>();
    private Map<String, Map> nodeVsTags = new HashMap<String, Map>();
    private Map<String, String> withCollectionsMap = new HashMap<String, String>();

    public SolrClientNodeStateProvider(CloudSolrClient solrClient) {
        this.solrClient = solrClient;
        try {
            this.readReplicaDetails();
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            INST = this;
        }
    }

    protected ClusterStateProvider getClusterStateProvider() {
        return this.solrClient.getClusterStateProvider();
    }

    protected void readReplicaDetails() throws IOException {
        ClusterStateProvider clusterStateProvider = this.getClusterStateProvider();
        ClusterState clusterState = clusterStateProvider.getClusterState();
        if (clusterState == null) {
            return;
        }
        Map<String, ClusterState.CollectionRef> all = clusterStateProvider.getClusterState().getCollectionStates();
        all.forEach((collName, ref) -> {
            DocCollection coll = ref.get();
            if (coll == null) {
                return;
            }
            if (coll.getProperties().get("withCollection") != null) {
                this.withCollectionsMap.put(coll.getName(), (String)coll.getProperties().get("withCollection"));
            }
            coll.forEachReplica((shard, replica) -> {
                Map nodeData = this.nodeVsCollectionVsShardVsReplicaInfo.computeIfAbsent(replica.getNodeName(), k -> new HashMap());
                Map collData = nodeData.computeIfAbsent(collName, k -> new HashMap());
                List replicas = collData.computeIfAbsent(shard, k -> new ArrayList());
                replicas.add(new ReplicaInfo((String)collName, (String)shard, (Replica)replica, (Map<String, Object>)new HashMap<String, Object>(replica.getProperties())));
            });
        });
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        ew.put((CharSequence)"replicaInfo", Utils.getDeepCopy(this.nodeVsCollectionVsShardVsReplicaInfo, 5));
        ew.put((CharSequence)"nodeValues", this.nodeVsTags);
    }

    @Override
    public Map<String, Object> getNodeValues(String node, Collection<String> tags) {
        Map<String, Object> tagVals = this.fetchTagValues(node, tags);
        this.nodeVsTags.put(node, tagVals);
        if (tags.contains(Variable.Type.WITH_COLLECTION.tagName)) {
            tagVals.put(Variable.Type.WITH_COLLECTION.tagName, this.withCollectionsMap);
        }
        return tagVals;
    }

    protected Map<String, Object> fetchTagValues(String node, Collection<String> tags) {
        AutoScalingSnitch snitch = new AutoScalingSnitch();
        ClientSnitchCtx ctx = new ClientSnitchCtx(null, node, this.snitchSession, this.solrClient);
        snitch.getTags(node, new HashSet<String>(tags), ctx);
        return ctx.getTags();
    }

    public void forEachReplica(String node, Consumer<ReplicaInfo> consumer) {
        Row.forEachReplica(this.nodeVsCollectionVsShardVsReplicaInfo.get(node), consumer);
    }

    @Override
    public Map<String, Map<String, List<ReplicaInfo>>> getReplicaInfo(String node, Collection<String> keys) {
        Map<String, Map<String, List<ReplicaInfo>>> result = this.nodeVsCollectionVsShardVsReplicaInfo.computeIfAbsent(node, Utils.NEW_HASHMAP_FUN);
        if (!keys.isEmpty()) {
            HashMap<String, Pair<String, ReplicaInfo>> metricsKeyVsTagReplica = new HashMap<String, Pair<String, ReplicaInfo>>();
            Row.forEachReplica(result, r -> {
                for (String key : keys) {
                    if (r.getVariables().containsKey(key)) continue;
                    String perReplicaMetricsKey = "solr.core." + r.getCollection() + "." + r.getShard() + "." + Utils.parseMetricsReplicaName(r.getCollection(), r.getCore()) + ":";
                    Variable.Type tagType = VariableBase.getTagType(key);
                    String perReplicaValue = key;
                    if (tagType != null) {
                        perReplicaValue = tagType.metricsAttribute;
                        perReplicaValue = perReplicaValue == null ? key : perReplicaValue;
                    }
                    perReplicaMetricsKey = perReplicaMetricsKey + perReplicaValue;
                    metricsKeyVsTagReplica.put(perReplicaMetricsKey, new Pair<String, ReplicaInfo>(key, (ReplicaInfo)r));
                }
            });
            if (!metricsKeyVsTagReplica.isEmpty()) {
                Map<String, Object> tagValues = this.fetchReplicaMetrics(node, metricsKeyVsTagReplica);
                tagValues.forEach((k, o) -> {
                    Pair p = (Pair)metricsKeyVsTagReplica.get(k);
                    Variable.Type validator = VariableBase.getTagType((String)p.first());
                    if (validator != null) {
                        o = validator.convertVal(o);
                    }
                    if (p.second() != null) {
                        ((ReplicaInfo)p.second()).getVariables().put((String)p.first(), o);
                    }
                });
            }
        }
        return result;
    }

    protected Map<String, Object> fetchReplicaMetrics(String node, Map<String, Pair<String, ReplicaInfo>> metricsKeyVsTagReplica) {
        Map<String, Object> collect = metricsKeyVsTagReplica.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getKey));
        ClientSnitchCtx ctx = new ClientSnitchCtx(null, null, Collections.emptyMap(), this.solrClient);
        SolrClientNodeStateProvider.fetchReplicaMetrics(node, ctx, collect);
        return ctx.getTags();
    }

    static void fetchReplicaMetrics(String solrNode, ClientSnitchCtx ctx, Map<String, Object> metricsKeyVsTag) {
        if (!ctx.isNodeAlive(solrNode)) {
            return;
        }
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.add("key", metricsKeyVsTag.keySet().toArray(new String[0]));
        try {
            SimpleSolrResponse rsp = null;
            int cnt = 0;
            while (cnt++ < 3) {
                try {
                    rsp = ctx.invoke(solrNode, "/admin/metrics", params);
                    break;
                }
                catch (IOException | SolrServerException | SolrException e) {
                    boolean hasCauseIOException = false;
                    for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                        if (!(cause instanceof IOException)) continue;
                        hasCauseIOException = true;
                        break;
                    }
                    if (hasCauseIOException || e instanceof IOException) {
                        log.info("Error on getting remote info, trying again: " + e.getMessage());
                        Thread.sleep(500L);
                        continue;
                    }
                    throw e;
                }
            }
            SimpleSolrResponse frsp = rsp;
            metricsKeyVsTag.forEach((key, tag) -> {
                Object v = Utils.getObjectByPath(frsp.nl, true, Arrays.asList("metrics", key));
                if (tag instanceof Function) {
                    Pair p = (Pair)((Function)tag).apply(v);
                    ctx.getTags().put((String)p.first(), p.second());
                } else if (v != null) {
                    ctx.getTags().put(tag.toString(), v);
                }
            });
        }
        catch (Exception e) {
            log.warn("could not get tags from node " + solrNode, (Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
    }

    public String toString() {
        return Utils.toJSONString(this);
    }

    static class ClientSnitchCtx
    extends SnitchContext {
        private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        ZkClientClusterStateProvider zkClientClusterStateProvider;
        CloudSolrClient solrClient;

        public boolean isNodeAlive(String node) {
            if (this.zkClientClusterStateProvider != null) {
                return this.zkClientClusterStateProvider.getLiveNodes().contains(node);
            }
            return true;
        }

        public ClientSnitchCtx(SnitchContext.SnitchInfo perSnitch, String node, Map<String, Object> session, CloudSolrClient solrClient) {
            super(perSnitch, node, session);
            this.solrClient = solrClient;
            this.zkClientClusterStateProvider = (ZkClientClusterStateProvider)solrClient.getClusterStateProvider();
        }

        @Override
        public Map getZkJson(String path) throws KeeperException, InterruptedException {
            return Utils.getJson(this.zkClientClusterStateProvider.getZkStateReader().getZkClient(), path, true);
        }

        public SimpleSolrResponse invoke(String solrNode, String path, SolrParams params) throws IOException, SolrServerException {
            String url = this.zkClientClusterStateProvider.getZkStateReader().getBaseUrlForNodeName(solrNode);
            GenericSolrRequest request = new GenericSolrRequest(SolrRequest.METHOD.POST, path, params);
            try (HttpSolrClient client = ((HttpSolrClient.Builder)((HttpSolrClient.Builder)new HttpSolrClient.Builder().withHttpClient(this.solrClient.getHttpClient())).withBaseSolrUrl(url).withResponseParser(new BinaryResponseParser())).build();){
                NamedList<Object> rsp = client.request(request);
                request.response.nl = rsp;
                SimpleSolrResponse simpleSolrResponse = request.response;
                return simpleSolrResponse;
            }
        }
    }

    static class AutoScalingSnitch
    extends ImplicitSnitch {
        AutoScalingSnitch() {
        }

        @Override
        protected void getRemoteInfo(String solrNode, Set<String> requestedTags, SnitchContext ctx) {
            if (!((ClientSnitchCtx)ctx).isNodeAlive(solrNode)) {
                return;
            }
            ClientSnitchCtx snitchContext = (ClientSnitchCtx)ctx;
            HashMap<String, Object> metricsKeyVsTag = new HashMap<String, Object>();
            for (String tag : requestedTags) {
                if (tag.startsWith("sysprop.")) {
                    metricsKeyVsTag.put("solr.jvm:system.properties:" + tag.substring("sysprop.".length()), tag);
                    continue;
                }
                if (!tag.startsWith("metrics:")) continue;
                metricsKeyVsTag.put(tag.substring("metrics:".length()), tag);
            }
            if (requestedTags.contains("diskType")) {
                metricsKeyVsTag.put("solr.node:CONTAINER.fs.coreRoot.spins", o -> {
                    if ("true".equals(String.valueOf(o))) {
                        return new Pair<String, String>("diskType", "rotational");
                    }
                    if ("false".equals(String.valueOf(o))) {
                        return new Pair<String, String>("diskType", "ssd");
                    }
                    return new Pair<String, Object>("diskType", null);
                });
            }
            if (!metricsKeyVsTag.isEmpty()) {
                SolrClientNodeStateProvider.fetchReplicaMetrics(solrNode, snitchContext, metricsKeyVsTag);
            }
            HashSet<String> groups = new HashSet<String>();
            ArrayList<String> prefixes = new ArrayList<String>();
            if (requestedTags.contains("freedisk")) {
                groups.add("solr.node");
                prefixes.add("CONTAINER.fs.usableSpace");
            }
            if (requestedTags.contains(Variable.Type.TOTALDISK.tagName)) {
                groups.add("solr.node");
                prefixes.add("CONTAINER.fs.totalSpace");
            }
            if (requestedTags.contains("cores")) {
                groups.add("solr.core");
                prefixes.add("CORE.coreName");
            }
            if (requestedTags.contains("sysLoadAvg")) {
                groups.add("solr.jvm");
                prefixes.add("os.systemLoadAverage");
            }
            if (requestedTags.contains("heapUsage")) {
                groups.add("solr.jvm");
                prefixes.add("memory.heap.usage");
            }
            if (groups.isEmpty() || prefixes.isEmpty()) {
                return;
            }
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.add("group", StrUtils.join(groups, ','));
            params.add("prefix", StrUtils.join(prefixes, ','));
            try {
                Object n;
                SimpleSolrResponse rsp = null;
                int retries = 5;
                int cnt = 0;
                while (cnt++ < retries) {
                    try {
                        rsp = snitchContext.invoke(solrNode, "/admin/metrics", params);
                        break;
                    }
                    catch (IOException | SolrServerException | SolrException e) {
                        if (e instanceof SolrServerException) {
                            // empty if block
                        }
                        boolean hasCauseIOException = false;
                        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                            if (!(cause instanceof IOException)) continue;
                            hasCauseIOException = true;
                            break;
                        }
                        if (hasCauseIOException || e instanceof IOException) {
                            log.info("Error on getting remote info, trying again: " + e.getMessage());
                            Thread.sleep(500L);
                            continue;
                        }
                        throw e;
                    }
                }
                if (cnt == retries) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not get remote info after many retries on NoHttpResponseException");
                }
                Map m = rsp.nl.asMap(4);
                if (requestedTags.contains(Variable.Type.FREEDISK.tagName) && (n = Utils.getObjectByPath((Object)m, true, "metrics/solr.node/CONTAINER.fs.usableSpace")) != null) {
                    ctx.getTags().put(Variable.Type.FREEDISK.tagName, Variable.Type.FREEDISK.convertVal(n));
                }
                if (requestedTags.contains(Variable.Type.TOTALDISK.tagName) && (n = Utils.getObjectByPath((Object)m, true, "metrics/solr.node/CONTAINER.fs.totalSpace")) != null) {
                    ctx.getTags().put(Variable.Type.TOTALDISK.tagName, Variable.Type.TOTALDISK.convertVal(n));
                }
                if (requestedTags.contains("cores")) {
                    int count = 0;
                    Map cores = (Map)m.get("metrics");
                    for (Object o2 : cores.keySet()) {
                        if (!o2.toString().startsWith("solr.core.")) continue;
                        ++count;
                    }
                    ctx.getTags().put("cores", count);
                }
                if (requestedTags.contains("sysLoadAvg") && (n = (Number)Utils.getObjectByPath((Object)m, true, "metrics/solr.jvm/os.systemLoadAverage")) != null) {
                    ctx.getTags().put("sysLoadAvg", n.doubleValue() * 100.0);
                }
                if (requestedTags.contains("heapUsage") && (n = (Number)Utils.getObjectByPath((Object)m, true, "metrics/solr.jvm/memory.heap.usage")) != null) {
                    ctx.getTags().put("heapUsage", n.doubleValue() * 100.0);
                }
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error getting remote info", (Throwable)e);
            }
        }
    }
}

