/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.targets;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclUnsupportedException;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.Targetable;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.BindSelect;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ExternalFilterByQuery;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Select;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.TupleMapper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnBufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.ast.targets.RSXTargetShape;
import org.eclipse.rdf4j.sail.shacl.ast.targets.Target;
import org.eclipse.rdf4j.sail.shacl.ast.targets.TargetChainRetriever;
import org.eclipse.rdf4j.sail.shacl.ast.targets.TargetNode;

public class EffectiveTarget {
    private final ArrayDeque<EffectiveTargetObject> chain;
    private final EffectiveTargetObject optional;
    private final RdfsSubClassOfReasoner rdfsSubClassOfReasoner;

    public EffectiveTarget(ArrayDeque<Targetable> chain, Targetable optional, String targetVarPrefix, RdfsSubClassOfReasoner rdfsSubClassOfReasoner) {
        int index = 0;
        this.chain = new ArrayDeque();
        EffectiveTargetObject previous = null;
        for (Targetable targetable : chain) {
            EffectiveTargetObject effectiveTargetObject;
            previous = effectiveTargetObject = new EffectiveTargetObject(new StatementMatcher.Variable(targetVarPrefix + String.format("%010d", index++)), targetable, previous, rdfsSubClassOfReasoner);
            this.chain.addLast(effectiveTargetObject);
        }
        this.optional = optional != null ? new EffectiveTargetObject(new StatementMatcher.Variable(targetVarPrefix + String.format("%010d", index)), optional, previous, rdfsSubClassOfReasoner) : null;
        this.rdfsSubClassOfReasoner = rdfsSubClassOfReasoner;
    }

    public StatementMatcher.Variable getTargetVar() {
        return this.chain.getLast().var;
    }

    public PlanNode extend(PlanNode source, ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope, Extend direction, boolean includePropertyShapeValues) {
        List<String> varNames;
        String query = this.getQuery(includePropertyShapeValues);
        List<StatementMatcher.Variable> vars = this.getVars();
        if (includePropertyShapeValues) {
            vars = new ArrayList<StatementMatcher.Variable>(vars);
            vars.add(this.optional.var);
        }
        if ((varNames = vars.stream().map(StatementMatcher.Variable::getName).collect(Collectors.toList())).size() == 1) {
            return connectionsGroup.getCachedNodeFor(this.getTargetFilter(connectionsGroup, new Unique(new TupleMapper(source, new ActiveTargetTupleMapper(scope, includePropertyShapeValues)), false)));
        }
        return connectionsGroup.getCachedNodeFor(new Unique(new BindSelect(connectionsGroup.getBaseConnection(), query, vars, source, varNames, scope, 100, direction, includePropertyShapeValues), true));
    }

    private List<StatementMatcher.Variable> getVars() {
        return this.chain.stream().map(t -> t.var).collect(Collectors.toList());
    }

    public boolean couldMatch(ConnectionsGroup connectionsGroup) {
        boolean hasTargetNode = Stream.concat(this.chain.stream(), this.getOptionalAsStream()).anyMatch(e -> e.target instanceof TargetNode);
        if (hasTargetNode) {
            return true;
        }
        return Stream.concat(this.chain.stream(), this.getOptionalAsStream()).flatMap(EffectiveTargetObject::getStatementMatcher).anyMatch(currentStatementPattern -> connectionsGroup.getAddedStatements().hasStatement(currentStatementPattern.getSubjectValue(), currentStatementPattern.getPredicateValue(), currentStatementPattern.getObjectValue(), false, new Resource[0]) || connectionsGroup.getRemovedStatements().hasStatement(currentStatementPattern.getSubjectValue(), currentStatementPattern.getPredicateValue(), currentStatementPattern.getObjectValue(), false, new Resource[0]));
    }

    private Stream<EffectiveTargetObject> getOptionalAsStream() {
        Stream<EffectiveTargetObject> optional = this.optional != null ? Stream.of(this.optional) : Stream.empty();
        return optional;
    }

    public PlanNode getAllTargets(ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope) {
        String query = this.chain.stream().map(EffectiveTargetObject::getQueryFragment).reduce((a, b) -> a + "\n" + b).orElse("");
        List<String> varNames = this.getVars().stream().map(StatementMatcher.Variable::getName).collect(Collectors.toList());
        return new Select(connectionsGroup.getBaseConnection(), query, null, new AllTargetsBindingSetMapper(varNames, scope, false));
    }

    public PlanNode getPlanNode(ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope, boolean includeTargetsAffectedByRemoval) {
        ArrayList<StatementMatcher> statementMatchersRemoval;
        assert (!this.chain.isEmpty());
        if (!(this.chain.size() != 1 || includeTargetsAffectedByRemoval && this.optional != null)) {
            EffectiveTargetObject last = this.chain.getLast();
            if (last.target instanceof Target) {
                return connectionsGroup.getCachedNodeFor(((Target)last.target).getAdded(connectionsGroup, scope));
            }
            throw new ShaclUnsupportedException("Unknown target in chain is type: " + last.getClass().getSimpleName());
        }
        List<StatementMatcher> statementMatchers = this.chain.stream().flatMap(EffectiveTargetObject::getStatementMatcher).collect(Collectors.toList());
        String query = this.chain.stream().map(EffectiveTargetObject::getQueryFragment).reduce((a, b) -> a + "\n" + b).orElse("");
        List<StatementMatcher> list = statementMatchersRemoval = this.optional != null ? (List)this.optional.getStatementMatcher().collect(Collectors.toCollection(ArrayList::new)) : new ArrayList<StatementMatcher>();
        if (this.chain.getFirst().target instanceof RSXTargetShape) {
            statementMatchersRemoval.addAll(this.chain.getFirst().getStatementMatcher().collect(Collectors.toList()));
            includeTargetsAffectedByRemoval = true;
        }
        TargetChainRetriever targetChainRetriever = includeTargetsAffectedByRemoval ? new TargetChainRetriever(connectionsGroup, statementMatchers, statementMatchersRemoval, query, this.getVars(), scope) : new TargetChainRetriever(connectionsGroup, statementMatchers, null, query, this.getVars(), scope);
        return connectionsGroup.getCachedNodeFor(new Unique(targetChainRetriever, true));
    }

    public PlanNode getTargetFilter(ConnectionsGroup connectionsGroup, PlanNode parent) {
        EffectiveTargetObject last = this.chain.getLast();
        if (this.chain.size() == 1) {
            if (last.target instanceof Target) {
                return ((Target)last.target).getTargetFilter(connectionsGroup, parent);
            }
            throw new ShaclUnsupportedException("Unknown target in chain is type: " + last.getClass().getSimpleName());
        }
        String query = this.chain.stream().map(EffectiveTargetObject::getQueryFragment).reduce((a, b) -> a + "\n" + b).orElse("");
        return new ExternalFilterByQuery(connectionsGroup.getBaseConnection(), parent, query, last.var, ValidationTuple::getActiveTarget).getTrueNode(UnBufferedPlanNode.class);
    }

    public String getQuery(boolean includeOptional) {
        ArrayDeque<EffectiveTargetObject> chain;
        if (includeOptional) {
            chain = new ArrayDeque<EffectiveTargetObject>(this.chain);
            chain.addLast(this.optional);
        } else {
            chain = this.chain;
        }
        return chain.stream().map(EffectiveTargetObject::getQueryFragment).reduce((a, b) -> a + "\n" + b).orElse("");
    }

    static class ActiveTargetTupleMapper
    implements Function<ValidationTuple, ValidationTuple> {
        ConstraintComponent.Scope scope;
        boolean includePropertyShapeValues;

        public ActiveTargetTupleMapper(ConstraintComponent.Scope scope, boolean includePropertyShapeValues) {
            this.scope = scope;
            this.includePropertyShapeValues = includePropertyShapeValues;
        }

        @Override
        public ValidationTuple apply(ValidationTuple validationTuple) {
            return new ValidationTuple(validationTuple.getActiveTarget(), this.scope, this.includePropertyShapeValues);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ActiveTargetTupleMapper that = (ActiveTargetTupleMapper)o;
            return this.includePropertyShapeValues == that.includePropertyShapeValues && this.scope == that.scope;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.scope, this.includePropertyShapeValues});
        }
    }

    static class AllTargetsBindingSetMapper
    implements Function<BindingSet, ValidationTuple> {
        List<String> varNames;
        ConstraintComponent.Scope scope;
        boolean hasValue;

        public AllTargetsBindingSetMapper(List<String> varNames, ConstraintComponent.Scope scope, boolean hasValue) {
            this.varNames = varNames;
            this.scope = scope;
            this.hasValue = hasValue;
        }

        @Override
        public ValidationTuple apply(BindingSet b) {
            return new ValidationTuple(b, this.varNames, this.scope, false);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AllTargetsBindingSetMapper that = (AllTargetsBindingSetMapper)o;
            return this.hasValue == that.hasValue && this.varNames.equals(that.varNames) && this.scope == that.scope;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.varNames, this.scope, this.hasValue, AllTargetsBindingSetMapper.class});
        }
    }

    static class EffectiveTargetObject {
        final StatementMatcher.Variable var;
        final Targetable target;
        final EffectiveTargetObject prev;
        final RdfsSubClassOfReasoner rdfsSubClassOfReasoner;

        public EffectiveTargetObject(StatementMatcher.Variable var, Targetable target, EffectiveTargetObject prev, RdfsSubClassOfReasoner rdfsSubClassOfReasoner) {
            this.var = var;
            this.target = target;
            this.prev = prev;
            this.rdfsSubClassOfReasoner = rdfsSubClassOfReasoner;
        }

        public Stream<StatementMatcher> getStatementMatcher() {
            if (this.prev == null) {
                return this.target.getStatementMatcher(null, this.var, this.rdfsSubClassOfReasoner);
            }
            return this.target.getStatementMatcher(this.prev.var, this.var, this.rdfsSubClassOfReasoner);
        }

        public String getQueryFragment() {
            if (this.prev == null) {
                return this.target.getTargetQueryFragment(null, this.var, this.rdfsSubClassOfReasoner);
            }
            return this.target.getTargetQueryFragment(this.prev.var, this.var, this.rdfsSubClassOfReasoner);
        }
    }

    public static enum Extend {
        left,
        right;

    }
}

