/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.targets;

import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.EmptyNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ExternalFilterByPredicate;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnorderedSelect;
import org.eclipse.rdf4j.sail.shacl.ast.targets.Target;

public class TargetObjectsOf
extends Target {
    private final Set<IRI> targetObjectsOf;

    public TargetObjectsOf(Set<IRI> targetObjectsOf) {
        this.targetObjectsOf = targetObjectsOf;
        assert (!this.targetObjectsOf.isEmpty());
    }

    @Override
    public IRI getPredicate() {
        return SHACL.TARGET_OBJECTS_OF;
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection, Set<Resource> rdfListDedupe) {
        this.targetObjectsOf.forEach(t -> model.add(subject, this.getPredicate(), (Value)t, new Resource[0]));
    }

    @Override
    public PlanNode getAdded(ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope) {
        return this.getAddedRemovedInner(connectionsGroup, scope, connectionsGroup.getAddedStatements());
    }

    private PlanNode getAddedRemovedInner(ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope, SailConnection connection) {
        PlanNode planNode = this.targetObjectsOf.stream().map(predicate -> new UnorderedSelect(connection, null, (IRI)predicate, null, UnorderedSelect.Mapper.ObjectScopedMapper.getFunction(scope))).reduce((xva$0, xva$1) -> new UnionNode((PlanNode)xva$0, (PlanNode)xva$1)).orElse(new EmptyNode());
        return new Unique(planNode, false);
    }

    @Override
    public String getQueryFragment(String subjectVariable, String objectVariable, RdfsSubClassOfReasoner rdfsSubClassOfReasoner) {
        String tempVar = "?" + UUID.randomUUID().toString().replace("-", "");
        return this.targetObjectsOf.stream().map(target -> "\n{ BIND(<" + target + "> as " + tempVar + ") \n " + objectVariable + " " + tempVar + " " + subjectVariable + ". } \n").reduce((a, b) -> a + " UNION " + b).get();
    }

    @Override
    public PlanNode getTargetFilter(ConnectionsGroup connectionsGroup, PlanNode parent) {
        return new ExternalFilterByPredicate(connectionsGroup.getBaseConnection(), this.targetObjectsOf, parent, ExternalFilterByPredicate.On.Object);
    }

    @Override
    public Stream<StatementMatcher> getStatementMatcher(StatementMatcher.Variable subject, StatementMatcher.Variable object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner) {
        assert (subject == null);
        return this.targetObjectsOf.stream().map(t -> new StatementMatcher(null, new StatementMatcher.Variable((Value)t), object));
    }

    @Override
    public String getTargetQueryFragment(StatementMatcher.Variable subject, StatementMatcher.Variable object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner) {
        assert (subject == null);
        String tempVar = "?" + UUID.randomUUID().toString().replace("-", "");
        if (this.targetObjectsOf.size() == 1) {
            return this.targetObjectsOf.stream().map(t -> tempVar + " <" + t + "> ?" + object.getName() + " .").reduce((a, b) -> a + "\n" + b).orElse("");
        }
        String in = this.targetObjectsOf.stream().map(t -> "<" + t + ">").reduce((a, b) -> a + " , " + b).orElse("");
        return tempVar + " ?predicatefjhfuewhw ?" + object.getName() + " .\nFILTER(?predicatefjhfuewhw in (" + in + ")) \n";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetObjectsOf that = (TargetObjectsOf)o;
        return this.targetObjectsOf.equals(that.targetObjectsOf);
    }

    public int hashCode() {
        return Objects.hash(this.targetObjectsOf);
    }
}

