/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.AST.PropertyShape;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.ValidationExecutionLogger;

public class EnrichWithShape
implements PlanNode {
    private final PropertyShape propertyShape;
    private final PlanNode parent;
    private boolean printed = false;
    private boolean closed;
    private ValidationExecutionLogger validationExecutionLogger;

    public EnrichWithShape(PlanNode parent, PropertyShape propertyShape) {
        this.parent = parent;
        this.propertyShape = propertyShape;
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        if (this.closed) {
            throw new IllegalStateException();
        }
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            CloseableIteration<Tuple, SailException> parentIterator;
            {
                this.parentIterator = EnrichWithShape.this.parent.iterator();
            }

            @Override
            boolean localHasNext() throws SailException {
                return this.parentIterator.hasNext();
            }

            @Override
            Tuple loggingNext() throws SailException {
                Tuple next = (Tuple)this.parentIterator.next();
                next.addCausedByPropertyShape(EnrichWithShape.this.propertyShape);
                return next;
            }

            @Override
            public void remove() throws SailException {
                this.parentIterator.remove();
            }

            @Override
            public void close() throws SailException {
                EnrichWithShape.this.closed = true;
                if (this.parentIterator != null) {
                    this.parentIterator.close();
                    this.parentIterator = null;
                }
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId()).append(" [label=\"").append(StringEscapeUtils.escapeJava((String)this.toString())).append("\"];").append("\n");
        stringBuilder.append(this.parent.getId()).append(" -> ").append(this.getId()).append("\n");
        this.parent.getPlanAsGraphvizDot(stringBuilder);
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public IteratorData getIteratorDataType() {
        return this.parent.getIteratorDataType();
    }

    public String toString() {
        return "EnrichWithShape";
    }

    public PropertyShape getPropertyShape() {
        return this.propertyShape;
    }

    public PlanNode getParent() {
        return this.parent;
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.parent.receiveLogger(validationExecutionLogger);
    }
}

