/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository.transaction;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.rdf4j.common.transaction.TransactionSetting;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.SESAME;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.util.RDFInserter;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFHandler;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Transaction
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(Transaction.class);
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final AtomicBoolean closeCompleted = new AtomicBoolean(false);
    private final UUID id;
    private final Repository rep;
    private final RepositoryConnection txnConnection;
    private final ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("rdf4j-transaction-%d").build());
    private final AtomicInteger activeOperations = new AtomicInteger();

    Transaction(Repository repository) throws InterruptedException, ExecutionException {
        this.id = UUID.randomUUID();
        this.rep = repository;
        this.txnConnection = this.getTransactionConnection();
    }

    UUID getID() {
        return this.id;
    }

    void begin(TransactionSetting ... settings) throws InterruptedException, ExecutionException {
        Future<Boolean> result = this.submit(() -> {
            this.txnConnection.begin(settings);
            return true;
        });
        this.getFromFuture(result);
    }

    void rollback() throws InterruptedException, ExecutionException {
        Future<Boolean> result = this.submit(() -> {
            this.txnConnection.rollback();
            return true;
        });
        this.getFromFuture(result);
    }

    void commit() throws InterruptedException, ExecutionException {
        Future<Boolean> result = this.submit(() -> {
            this.txnConnection.commit();
            return true;
        });
        this.getFromFuture(result);
    }

    Query prepareQuery(QueryLanguage queryLanguage, String query, String baseURI) throws InterruptedException, ExecutionException {
        Future<Query> result = this.submit(() -> this.txnConnection.prepareQuery(queryLanguage, query, baseURI));
        return this.getFromFuture(result);
    }

    TupleQueryResult evaluate(TupleQuery tQuery) throws InterruptedException, ExecutionException {
        Future<TupleQueryResult> result = this.submit(tQuery::evaluate);
        return this.getFromFuture(result);
    }

    GraphQueryResult evaluate(GraphQuery gQuery) throws InterruptedException, ExecutionException {
        Future<GraphQueryResult> result = this.submit(gQuery::evaluate);
        return this.getFromFuture(result);
    }

    boolean evaluate(BooleanQuery bQuery) throws InterruptedException, ExecutionException {
        Future<Boolean> result = this.submit(() -> bQuery.evaluate());
        return this.getFromFuture(result);
    }

    void exportStatements(Resource subj, IRI pred, Value obj, boolean useInferencing, RDFWriter rdfWriter, Resource ... contexts) throws InterruptedException, ExecutionException {
        Future<Boolean> result = this.submit(() -> {
            this.txnConnection.exportStatements(subj, pred, obj, useInferencing, rdfWriter, contexts);
            return true;
        });
        this.getFromFuture(result);
    }

    long getSize(Resource[] contexts) throws InterruptedException, ExecutionException {
        Future<Long> result = this.submit(() -> this.txnConnection.size(contexts));
        return this.getFromFuture(result);
    }

    void add(InputStream inputStream, String baseURI, RDFFormat format, boolean preserveBNodes, Resource ... contexts) throws InterruptedException, ExecutionException {
        Future<Boolean> result = this.submit(() -> {
            logger.debug("executing add operation");
            try {
                if (preserveBNodes) {
                    RDFParser parser = Rio.createParser(format);
                    parser.getParserConfig().set((RioSetting)BasicParserSettings.PRESERVE_BNODE_IDS, (Object)true);
                    RDFInserter inserter = new RDFInserter(this.txnConnection);
                    inserter.setPreserveBNodeIDs(true);
                    if (contexts.length > 0) {
                        inserter.enforceContext(contexts);
                    }
                    parser.setRDFHandler(inserter);
                    parser.parse(inputStream, baseURI);
                } else {
                    this.txnConnection.add(inputStream, baseURI, format, contexts);
                }
                return true;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        this.getFromFuture(result);
    }

    void delete(RDFFormat contentType, InputStream inputStream, String baseURI) throws InterruptedException, ExecutionException {
        Future<Boolean> result = this.submit(() -> {
            logger.debug("executing delete operation");
            RDFParser parser = Rio.createParser(contentType, this.txnConnection.getValueFactory());
            parser.setRDFHandler(new WildcardRDFRemover(this.txnConnection));
            parser.getParserConfig().set((RioSetting)BasicParserSettings.PRESERVE_BNODE_IDS, (Object)true);
            try {
                parser.parse(inputStream, baseURI);
                return true;
            }
            catch (IOException e) {
                logger.error("error during txn delete operation", (Throwable)e);
                throw new RuntimeException(e);
            }
        });
        this.getFromFuture(result);
    }

    void executeUpdate(QueryLanguage queryLn, String sparqlUpdateString, String baseURI, boolean includeInferred, Dataset dataset, Map<String, Value> bindings) throws InterruptedException, ExecutionException {
        Future<Boolean> result = this.submit(() -> {
            Update update = this.txnConnection.prepareUpdate(queryLn, sparqlUpdateString, baseURI);
            update.setIncludeInferred(includeInferred);
            if (dataset != null) {
                update.setDataset(dataset);
            }
            for (String bindingName : bindings.keySet()) {
                update.setBinding(bindingName, (Value)bindings.get(bindingName));
            }
            update.execute();
            return true;
        });
        this.getFromFuture(result);
    }

    boolean hasActiveOperations() {
        return this.activeOperations.get() > 0;
    }

    boolean isClosed() {
        return this.isClosed.get();
    }

    boolean isComplete() {
        return this.closeCompleted.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws InterruptedException, ExecutionException {
        if (this.isClosed.compareAndSet(false, true)) {
            try {
                Future<Boolean> result = this.submitAndShutdown(() -> {
                    this.txnConnection.close();
                    return true;
                });
                this.getFromFuture(result);
            }
            finally {
                try {
                    if (!this.executor.isTerminated()) {
                        this.executor.shutdownNow();
                    }
                }
                finally {
                    this.closeCompleted.set(true);
                }
            }
        }
    }

    private RepositoryConnection getTransactionConnection() throws InterruptedException, ExecutionException {
        Future<RepositoryConnection> result = this.submit(() -> {
            RepositoryConnection conn = this.rep.getConnection();
            ParserConfig config = conn.getParserConfig();
            config.set((RioSetting)BasicParserSettings.PRESERVE_BNODE_IDS, (Object)true);
            config.addNonFatalError(BasicParserSettings.VERIFY_DATATYPE_VALUES);
            config.addNonFatalError(BasicParserSettings.VERIFY_LANGUAGE_TAGS);
            return conn;
        });
        return this.getFromFuture(result);
    }

    private <T> Future<T> submit(Callable<T> callable) {
        Future<T> result = this.executor.submit(callable);
        this.activeOperations.incrementAndGet();
        return result;
    }

    private <T> Future<T> submitAndShutdown(Callable<T> callable) {
        Future<T> result = this.executor.submit(callable);
        this.activeOperations.incrementAndGet();
        this.executor.shutdown();
        return result;
    }

    private <T> T getFromFuture(Future<T> result) throws InterruptedException, ExecutionException {
        try {
            T t = result.get();
            return t;
        }
        finally {
            this.activeOperations.decrementAndGet();
        }
    }

    private static class WildcardRDFRemover
    extends AbstractRDFHandler {
        private final RepositoryConnection conn;

        public WildcardRDFRemover(RepositoryConnection conn) {
            this.conn = conn;
        }

        @Override
        public void handleStatement(Statement st) throws RDFHandlerException {
            Resource subject = SESAME.WILDCARD.equals(st.getSubject()) ? null : st.getSubject();
            IRI predicate = SESAME.WILDCARD.equals(st.getPredicate()) ? null : st.getPredicate();
            Value object = SESAME.WILDCARD.equals(st.getObject()) ? null : st.getObject();
            boolean clearAllTriples = subject == null && predicate == null && object == null;
            try {
                Resource context = st.getContext();
                if (context != null) {
                    if (clearAllTriples) {
                        this.conn.clear(context);
                    } else {
                        this.conn.remove(subject, predicate, object, context);
                    }
                } else if (clearAllTriples) {
                    this.conn.clear(new Resource[0]);
                } else {
                    this.conn.remove(subject, predicate, object, new Resource[0]);
                }
            }
            catch (RepositoryException e) {
                throw new RDFHandlerException(e);
            }
        }
    }
}

